/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: CurveViewerEnginePluginInfo.C
// ************************************************************************* //

#include <CurvePluginInfo.h>
#include <avtCurvePlot.h>
#include <CurveAttributes.h>

//
// Storage for static data elements.
//
CurveAttributes *CurveViewerEnginePluginInfo::clientAtts = NULL;
CurveAttributes *CurveViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  CurveViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the plot atts.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
//  Modifications:
//    Kathleen Bonnell, Mon Oct 31 17:05:35 PST 2005
//    Initialize colorIndex. 
//
// ****************************************************************************
static int colorIndex;
void
CurveViewerEnginePluginInfo::InitializeGlobalObjects()
{
    colorIndex = 0;
    CurveViewerEnginePluginInfo::clientAtts  = new CurveAttributes;
    CurveViewerEnginePluginInfo::defaultAtts = new CurveAttributes;
}


// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CurveViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
CurveViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CurveViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(CurveAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
CurveViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(CurveAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::AllocAvtPlot
//
//  Purpose:
//    Return a pointer to a newly allocated avt plot.
//
//  Returns:    A pointer to the newly allocated avt plot.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

avtPlot *
CurveViewerEnginePluginInfo::AllocAvtPlot()
{
    return new avtCurvePlot;
}

bool
CurveViewerEnginePluginInfo::PermitsCurveViewScaling() const
{
    return true;
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::InitializePlotAtts
//
//  Purpose:
//    Initialize the plot attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: whitlocb -- generated by xml2info
//  Creation:   Fri Mar 26 15:09:32 PST 2004
//
//  Modifications:
//    Kathleen Bonnell, Mon Oct 31 17:05:35 PST 2005
//    Added call to SetColor.
//
// ****************************************************************************

void
CurveViewerEnginePluginInfo::InitializePlotAtts(AttributeSubject *atts,
    const avtPlotMetaData &)
{
    *(CurveAttributes*)atts = *defaultAtts;
    SetColor(atts);
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
CurveViewerEnginePluginInfo::GetMenuName() const
{
    return "Curve";
}

// ****************************************************************************
//  Method: CurveViewerEnginePluginInfo::SetColor
//
//  Purpose:
//    Sets the color if the CycleColors att is set to true. 
//
//  Arguments:
//    atts      The attribute subject. 
//
//  Programmer: Kathleen Bonnell 
//  Creation:   October 31, 2005 
//
//  Modifications:
//
//    Hank Childs, Sat Mar 13 10:35:34 PST 2010
//    Change Boolean test to comparison with enumeration.
//
//    Brad Whitlock, Fri Jul  5 16:55:22 PDT 2013
//    Set the fill color too.
//
// ****************************************************************************
#include <avtColorTables.h>

void
CurveViewerEnginePluginInfo::SetColor(AttributeSubject *atts)
{
    CurveAttributes *curveAtts = (CurveAttributes *)atts;

    if (curveAtts->GetCurveColorSource() == CurveAttributes::Cycle)
    {
        ColorAttribute c;
        unsigned char rgb[3] = {0,0,0};

        //
        // Try and get the color for the colorIndex'th color in the default
        // discrete color table.
        //
        avtColorTables *ct = avtColorTables::Instance();
        if(ct->GetControlPointColor(ct->GetDefaultDiscreteColorTable(),
           colorIndex, rgb))
        {
            c.SetRed(int(rgb[0]));
            c.SetGreen(int(rgb[1]));
            c.SetBlue(int(rgb[2]));
        }
        curveAtts->SetCurveColor(c);
        curveAtts->SetFillColor1(c);

        // Make a whiter version of the color for fill color 2.
        int R = int(rgb[0]) + 100;
        int G = int(rgb[1]) + 100;
        int B = int(rgb[2]) + 100;
        R = (R > 255) ? 255 : R;
        G = (G > 255) ? 255 : G;
        B = (B > 255) ? 255 : B;
        c.SetRed(R);
        c.SetGreen(G);
        c.SetBlue(B);
        curveAtts->SetFillColor2(c);

        // Increment the color index.
        colorIndex = (colorIndex + 1) % ct->GetNumColors();
    }
}

