/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTraceHistoryAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyTraceHistoryAttributes
//
// Purpose: 
//   Attributes for the TraceHistory operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TraceHistoryAttributes.
//
struct TraceHistoryAttributesObject
{
    PyObject_HEAD
    TraceHistoryAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTraceHistoryAttributes(int);

std::string
PyTraceHistoryAttributes_ToString(const TraceHistoryAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const stringVector &vars = atts->GetVars();
        SNPRINTF(tmpStr, 1000, "%svars = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < vars.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", vars[i].c_str());
            str += tmpStr;
            if(i < vars.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sdisplacement = \"%s\"\n", prefix, atts->GetDisplacement().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snumiter = %d\n", prefix, atts->GetNumiter());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%soutput = \"%s\"\n", prefix, atts->GetOutput().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
TraceHistoryAttributes_Notify(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TraceHistoryAttributes_SetVars(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;

    stringVector  &vec = obj->data->GetVars();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the vars in the object as modified.
    obj->data->SelectVars();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TraceHistoryAttributes_GetVars(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the vars.
    const stringVector &vars = obj->data->GetVars();
    PyObject *retval = PyTuple_New(vars.size());
    for(size_t i = 0; i < vars.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(vars[i].c_str()));
    return retval;
}

/*static*/ PyObject *
TraceHistoryAttributes_SetDisplacement(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the displacement in the object.
    obj->data->SetDisplacement(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TraceHistoryAttributes_GetDisplacement(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetDisplacement().c_str());
    return retval;
}

/*static*/ PyObject *
TraceHistoryAttributes_SetNumiter(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numiter in the object.
    obj->data->SetNumiter((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TraceHistoryAttributes_GetNumiter(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumiter()));
    return retval;
}

/*static*/ PyObject *
TraceHistoryAttributes_SetOutput(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the output in the object.
    obj->data->SetOutput(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TraceHistoryAttributes_GetOutput(PyObject *self, PyObject *args)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOutput().c_str());
    return retval;
}



PyMethodDef PyTraceHistoryAttributes_methods[TRACEHISTORYATTRIBUTES_NMETH] = {
    {"Notify", TraceHistoryAttributes_Notify, METH_VARARGS},
    {"SetVars", TraceHistoryAttributes_SetVars, METH_VARARGS},
    {"GetVars", TraceHistoryAttributes_GetVars, METH_VARARGS},
    {"SetDisplacement", TraceHistoryAttributes_SetDisplacement, METH_VARARGS},
    {"GetDisplacement", TraceHistoryAttributes_GetDisplacement, METH_VARARGS},
    {"SetNumiter", TraceHistoryAttributes_SetNumiter, METH_VARARGS},
    {"GetNumiter", TraceHistoryAttributes_GetNumiter, METH_VARARGS},
    {"SetOutput", TraceHistoryAttributes_SetOutput, METH_VARARGS},
    {"GetOutput", TraceHistoryAttributes_GetOutput, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TraceHistoryAttributes_dealloc(PyObject *v)
{
   TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TraceHistoryAttributes_compare(PyObject *v, PyObject *w)
{
    TraceHistoryAttributes *a = ((TraceHistoryAttributesObject *)v)->data;
    TraceHistoryAttributes *b = ((TraceHistoryAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTraceHistoryAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "vars") == 0)
        return TraceHistoryAttributes_GetVars(self, NULL);
    if(strcmp(name, "displacement") == 0)
        return TraceHistoryAttributes_GetDisplacement(self, NULL);
    if(strcmp(name, "numiter") == 0)
        return TraceHistoryAttributes_GetNumiter(self, NULL);
    if(strcmp(name, "output") == 0)
        return TraceHistoryAttributes_GetOutput(self, NULL);

    return Py_FindMethod(PyTraceHistoryAttributes_methods, self, name);
}

int
PyTraceHistoryAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "vars") == 0)
        obj = TraceHistoryAttributes_SetVars(self, tuple);
    else if(strcmp(name, "displacement") == 0)
        obj = TraceHistoryAttributes_SetDisplacement(self, tuple);
    else if(strcmp(name, "numiter") == 0)
        obj = TraceHistoryAttributes_SetNumiter(self, tuple);
    else if(strcmp(name, "output") == 0)
        obj = TraceHistoryAttributes_SetOutput(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TraceHistoryAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)v;
    fprintf(fp, "%s", PyTraceHistoryAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TraceHistoryAttributes_str(PyObject *v)
{
    TraceHistoryAttributesObject *obj = (TraceHistoryAttributesObject *)v;
    return PyString_FromString(PyTraceHistoryAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TraceHistoryAttributes_Purpose = "Attributes for the TraceHistory operator";
#else
static char *TraceHistoryAttributes_Purpose = "Attributes for the TraceHistory operator";
#endif

//
// The type description structure
//
static PyTypeObject TraceHistoryAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TraceHistoryAttributes",                    // tp_name
    sizeof(TraceHistoryAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TraceHistoryAttributes_dealloc,  // tp_dealloc
    (printfunc)TraceHistoryAttributes_print,     // tp_print
    (getattrfunc)PyTraceHistoryAttributes_getattr, // tp_getattr
    (setattrfunc)PyTraceHistoryAttributes_setattr, // tp_setattr
    (cmpfunc)TraceHistoryAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TraceHistoryAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TraceHistoryAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TraceHistoryAttributes *defaultAtts = 0;
static TraceHistoryAttributes *currentAtts = 0;

static PyObject *
NewTraceHistoryAttributes(int useCurrent)
{
    TraceHistoryAttributesObject *newObject;
    newObject = PyObject_NEW(TraceHistoryAttributesObject, &TraceHistoryAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TraceHistoryAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TraceHistoryAttributes(*defaultAtts);
    else
        newObject->data = new TraceHistoryAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTraceHistoryAttributes(const TraceHistoryAttributes *attr)
{
    TraceHistoryAttributesObject *newObject;
    newObject = PyObject_NEW(TraceHistoryAttributesObject, &TraceHistoryAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TraceHistoryAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TraceHistoryAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTraceHistoryAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TraceHistoryAttributesMethods[] = {
    {"TraceHistoryAttributes", TraceHistoryAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TraceHistoryAttributesObserver = 0;

std::string
PyTraceHistoryAttributes_GetLogString()
{
    std::string s("TraceHistoryAtts = TraceHistoryAttributes()\n");
    if(currentAtts != 0)
        s += PyTraceHistoryAttributes_ToString(currentAtts, "TraceHistoryAtts.");
    return s;
}

static void
PyTraceHistoryAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TraceHistoryAtts = TraceHistoryAttributes()\n");
        s += PyTraceHistoryAttributes_ToString(currentAtts, "TraceHistoryAtts.");
        cb(s);
    }
}

void
PyTraceHistoryAttributes_StartUp(TraceHistoryAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTraceHistoryAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TraceHistoryAttributesObserver == 0)
    {
        TraceHistoryAttributesObserver = new ObserverToCallback(subj,
            PyTraceHistoryAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTraceHistoryAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TraceHistoryAttributesObserver;
    TraceHistoryAttributesObserver = 0;
}

PyMethodDef *
PyTraceHistoryAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TraceHistoryAttributesMethods;
}

bool
PyTraceHistoryAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TraceHistoryAttributesType);
}

TraceHistoryAttributes *
PyTraceHistoryAttributes_FromPyObject(PyObject *obj)
{
    TraceHistoryAttributesObject *obj2 = (TraceHistoryAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTraceHistoryAttributes_New()
{
    return NewTraceHistoryAttributes(0);
}

PyObject *
PyTraceHistoryAttributes_Wrap(const TraceHistoryAttributes *attr)
{
    return WrapTraceHistoryAttributes(attr);
}

void
PyTraceHistoryAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TraceHistoryAttributesObject *obj2 = (TraceHistoryAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTraceHistoryAttributes_SetDefaults(const TraceHistoryAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TraceHistoryAttributes(*atts);
}

