/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: ThresholdViewerEnginePluginInfo.C
// ************************************************************************* //

#include <ThresholdPluginInfo.h>
#include <ThresholdAttributes.h>

//
// Storage for static data elements.
//
ThresholdAttributes *ThresholdViewerEnginePluginInfo::clientAtts = NULL;
ThresholdAttributes *ThresholdViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  ThresholdViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
ThresholdViewerEnginePluginInfo::InitializeGlobalObjects()
{
    ThresholdViewerEnginePluginInfo::clientAtts  = new ThresholdAttributes;
    ThresholdViewerEnginePluginInfo::defaultAtts = new ThresholdAttributes;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ThresholdViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(ThresholdAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(ThresholdAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts      The attribute subject to initialize.
//    md        The metadata used to initialize.
//    atts      The variable name used to initialize.
//
//  Programmer: mblair -- generated by xml2info
//  Creation:   Thu Mar 9 16:03:07 PST 2006
//
//   Modifications:
//   
//     Mark Blair, Thu Mar  9 18:25:00 PST 2006
//     Upgraded to support multiple threshold variables.
//
//     Mark Blair, Tue Aug  8 17:47:00 PDT 2006
//     Now accommodates an empty list of threshold variables; does pass-through.
//     Also checks for attribute consistency.
//
//     Mark Blair, Wed Sep  6 19:13:00 PDT 2006
//     Corrected bad policy: Was sometimes changing user's defaults explicitly.
//
//     Mark Blair, Thu Sep 28 12:07:05 PDT 2006
//     Accommodate old Threshold mode in CLI by supplying any missing default
//     attribute values if attributes are set up for a single threshold variable.
//
//     Mark Blair, Tue Oct  3 13:19:11 PDT 2006
//     Set attribute flag that indicates whether plot variable is a scalar.
//
// ****************************************************************************
#include <avtPlotMetaData.h>
#include <DebugStream.h>
void
ThresholdViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                                  const avtPlotMetaData &plot,
                                                  const bool fromDefault)
{
    if (fromDefault)
        *(ThresholdAttributes *)atts = *defaultAtts;
    else
        *(ThresholdAttributes *)atts = *clientAtts;
        
    ThresholdAttributes *initAtts = (ThresholdAttributes *)atts;
        
    initAtts->SupplyMissingDefaultsIfAppropriate();
    
    initAtts->SetDefaultVarName(plot.GetVariableName());
    initAtts->SetDefaultVarIsScalar(plot.GetVariableType() == AVT_SCALAR_VAR);

    UpdateOperatorAtts(initAtts, plot);
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ThresholdViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: ThresholdViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
ThresholdViewerEnginePluginInfo::GetMenuName() const
{
    return "Threshold";
}

