/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisStaggerWindow.h"

#include <StaggerAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisStaggerWindow::QvisStaggerWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisStaggerWindow::QvisStaggerWindow(const int type,
                         StaggerAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisStaggerWindow::~QvisStaggerWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisStaggerWindow::~QvisStaggerWindow()
{
}


// ****************************************************************************
// Method: QvisStaggerWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisStaggerWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    offsetXLabel = new QLabel(tr("X offset"), central);
    mainLayout->addWidget(offsetXLabel,0,0);
    offsetX = new QLineEdit(central);
    connect(offsetX, SIGNAL(returnPressed()),
            this, SLOT(offsetXProcessText()));
    mainLayout->addWidget(offsetX, 0,1);

    offsetYLabel = new QLabel(tr("Y offset"), central);
    mainLayout->addWidget(offsetYLabel,1,0);
    offsetY = new QLineEdit(central);
    connect(offsetY, SIGNAL(returnPressed()),
            this, SLOT(offsetYProcessText()));
    mainLayout->addWidget(offsetY, 1,1);

    offsetZLabel = new QLabel(tr("Z offset"), central);
    mainLayout->addWidget(offsetZLabel,2,0);
    offsetZ = new QLineEdit(central);
    connect(offsetZ, SIGNAL(returnPressed()),
            this, SLOT(offsetZProcessText()));
    mainLayout->addWidget(offsetZ, 2,1);

}


// ****************************************************************************
// Method: QvisStaggerWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisStaggerWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case StaggerAttributes::ID_offsetX:
            offsetX->setText(DoubleToQString(atts->GetOffsetX()));
            break;
          case StaggerAttributes::ID_offsetY:
            offsetY->setText(DoubleToQString(atts->GetOffsetY()));
            break;
          case StaggerAttributes::ID_offsetZ:
            offsetZ->setText(DoubleToQString(atts->GetOffsetZ()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisStaggerWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisStaggerWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do offsetX
    if(which_widget == StaggerAttributes::ID_offsetX || doAll)
    {
        double val;
        if(LineEditGetDouble(offsetX, val))
            atts->SetOffsetX(val);
        else
        {
            ResettingError(tr("X offset"),
                DoubleToQString(atts->GetOffsetX()));
            atts->SetOffsetX(atts->GetOffsetX());
        }
    }

    // Do offsetY
    if(which_widget == StaggerAttributes::ID_offsetY || doAll)
    {
        double val;
        if(LineEditGetDouble(offsetY, val))
            atts->SetOffsetY(val);
        else
        {
            ResettingError(tr("Y offset"),
                DoubleToQString(atts->GetOffsetY()));
            atts->SetOffsetY(atts->GetOffsetY());
        }
    }

    // Do offsetZ
    if(which_widget == StaggerAttributes::ID_offsetZ || doAll)
    {
        double val;
        if(LineEditGetDouble(offsetZ, val))
            atts->SetOffsetZ(val);
        else
        {
            ResettingError(tr("Z offset"),
                DoubleToQString(atts->GetOffsetZ()));
            atts->SetOffsetZ(atts->GetOffsetZ());
        }
    }

}


//
// Qt Slot functions
//


void
QvisStaggerWindow::offsetXProcessText()
{
    GetCurrentValues(StaggerAttributes::ID_offsetX);
    Apply();
}


void
QvisStaggerWindow::offsetYProcessText()
{
    GetCurrentValues(StaggerAttributes::ID_offsetY);
    Apply();
}


void
QvisStaggerWindow::offsetZProcessText()
{
    GetCurrentValues(StaggerAttributes::ID_offsetZ);
    Apply();
}


