/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <RevolveAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for RevolveAttributes::MeshType
//

static const char *MeshType_strings[] = {
"Auto", "XY", "RZ", 
"ZR"};

std::string
RevolveAttributes::MeshType_ToString(RevolveAttributes::MeshType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return MeshType_strings[index];
}

std::string
RevolveAttributes::MeshType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return MeshType_strings[index];
}

bool
RevolveAttributes::MeshType_FromString(const std::string &s, RevolveAttributes::MeshType &val)
{
    val = RevolveAttributes::Auto;
    for(int i = 0; i < 4; ++i)
    {
        if(s == MeshType_strings[i])
        {
            val = (MeshType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Init utility for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void RevolveAttributes::Init()
{
    meshType = Auto;
    autoAxis = true;
    axis[0] = 1;
    axis[1] = 0;
    axis[2] = 0;
    startAngle = 0;
    stopAngle = 360;
    steps = 30;

    RevolveAttributes::SelectAll();
}

// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Copy utility for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void RevolveAttributes::Copy(const RevolveAttributes &obj)
{
    meshType = obj.meshType;
    autoAxis = obj.autoAxis;
    axis[0] = obj.axis[0];
    axis[1] = obj.axis[1];
    axis[2] = obj.axis[2];

    startAngle = obj.startAngle;
    stopAngle = obj.stopAngle;
    steps = obj.steps;

    RevolveAttributes::SelectAll();
}

// Type map format string
const char *RevolveAttributes::TypeMapFormatString = REVOLVEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t RevolveAttributes::TmfsStruct = {REVOLVEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Default constructor for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes::RevolveAttributes() : 
    AttributeSubject(RevolveAttributes::TypeMapFormatString)
{
    RevolveAttributes::Init();
}

// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Constructor for the derived classes of RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes::RevolveAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    RevolveAttributes::Init();
}

// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Copy constructor for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes::RevolveAttributes(const RevolveAttributes &obj) : 
    AttributeSubject(RevolveAttributes::TypeMapFormatString)
{
    RevolveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RevolveAttributes::RevolveAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes::RevolveAttributes(const RevolveAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    RevolveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RevolveAttributes::~RevolveAttributes
//
// Purpose: 
//   Destructor for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes::~RevolveAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: RevolveAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

RevolveAttributes& 
RevolveAttributes::operator = (const RevolveAttributes &obj)
{
    if (this == &obj) return *this;

    RevolveAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: RevolveAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveAttributes::operator == (const RevolveAttributes &obj) const
{
    // Compare the axis arrays.
    bool axis_equal = true;
    for(int i = 0; i < 3 && axis_equal; ++i)
        axis_equal = (axis[i] == obj.axis[i]);

    // Create the return value
    return ((meshType == obj.meshType) &&
            (autoAxis == obj.autoAxis) &&
            axis_equal &&
            (startAngle == obj.startAngle) &&
            (stopAngle == obj.stopAngle) &&
            (steps == obj.steps));
}

// ****************************************************************************
// Method: RevolveAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveAttributes::operator != (const RevolveAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: RevolveAttributes::TypeName
//
// Purpose: 
//   Type name method for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
RevolveAttributes::TypeName() const
{
    return "RevolveAttributes";
}

// ****************************************************************************
// Method: RevolveAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const RevolveAttributes *tmp = (const RevolveAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: RevolveAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
RevolveAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new RevolveAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: RevolveAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the RevolveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
RevolveAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new RevolveAttributes(*this);
    else
        retval = new RevolveAttributes;

    return retval;
}

// ****************************************************************************
// Method: RevolveAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
RevolveAttributes::SelectAll()
{
    Select(ID_meshType,   (void *)&meshType);
    Select(ID_autoAxis,   (void *)&autoAxis);
    Select(ID_axis,       (void *)axis, 3);
    Select(ID_startAngle, (void *)&startAngle);
    Select(ID_stopAngle,  (void *)&stopAngle);
    Select(ID_steps,      (void *)&steps);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RevolveAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    RevolveAttributes defaultObject;
    bool addToParent = false;
    // Create a node for RevolveAttributes.
    DataNode *node = new DataNode("RevolveAttributes");

    if(completeSave || !FieldsEqual(ID_meshType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("meshType", MeshType_ToString(meshType)));
    }

    if(completeSave || !FieldsEqual(ID_autoAxis, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("autoAxis", autoAxis));
    }

    if(completeSave || !FieldsEqual(ID_axis, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("axis", axis, 3));
    }

    if(completeSave || !FieldsEqual(ID_startAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startAngle", startAngle));
    }

    if(completeSave || !FieldsEqual(ID_stopAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stopAngle", stopAngle));
    }

    if(completeSave || !FieldsEqual(ID_steps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("steps", steps));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: RevolveAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
RevolveAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("RevolveAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("meshType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 4)
                SetMeshType(MeshType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            MeshType value;
            if(MeshType_FromString(node->AsString(), value))
                SetMeshType(value);
        }
    }
    if((node = searchNode->GetNode("autoAxis")) != 0)
        SetAutoAxis(node->AsBool());
    if((node = searchNode->GetNode("axis")) != 0)
        SetAxis(node->AsDoubleArray());
    if((node = searchNode->GetNode("startAngle")) != 0)
        SetStartAngle(node->AsDouble());
    if((node = searchNode->GetNode("stopAngle")) != 0)
        SetStopAngle(node->AsDouble());
    if((node = searchNode->GetNode("steps")) != 0)
        SetSteps(node->AsInt());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
RevolveAttributes::SetMeshType(RevolveAttributes::MeshType meshType_)
{
    meshType = meshType_;
    Select(ID_meshType, (void *)&meshType);
}

void
RevolveAttributes::SetAutoAxis(bool autoAxis_)
{
    autoAxis = autoAxis_;
    Select(ID_autoAxis, (void *)&autoAxis);
}

void
RevolveAttributes::SetAxis(const double *axis_)
{
    axis[0] = axis_[0];
    axis[1] = axis_[1];
    axis[2] = axis_[2];
    Select(ID_axis, (void *)axis, 3);
}

void
RevolveAttributes::SetStartAngle(double startAngle_)
{
    startAngle = startAngle_;
    Select(ID_startAngle, (void *)&startAngle);
}

void
RevolveAttributes::SetStopAngle(double stopAngle_)
{
    stopAngle = stopAngle_;
    Select(ID_stopAngle, (void *)&stopAngle);
}

void
RevolveAttributes::SetSteps(int steps_)
{
    steps = steps_;
    Select(ID_steps, (void *)&steps);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

RevolveAttributes::MeshType
RevolveAttributes::GetMeshType() const
{
    return MeshType(meshType);
}

bool
RevolveAttributes::GetAutoAxis() const
{
    return autoAxis;
}

const double *
RevolveAttributes::GetAxis() const
{
    return axis;
}

double *
RevolveAttributes::GetAxis()
{
    return axis;
}

double
RevolveAttributes::GetStartAngle() const
{
    return startAngle;
}

double
RevolveAttributes::GetStopAngle() const
{
    return stopAngle;
}

int
RevolveAttributes::GetSteps() const
{
    return steps;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
RevolveAttributes::SelectAxis()
{
    Select(ID_axis, (void *)axis, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RevolveAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
RevolveAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_meshType:   return "meshType";
    case ID_autoAxis:   return "autoAxis";
    case ID_axis:       return "axis";
    case ID_startAngle: return "startAngle";
    case ID_stopAngle:  return "stopAngle";
    case ID_steps:      return "steps";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RevolveAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
RevolveAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_meshType:   return FieldType_enum;
    case ID_autoAxis:   return FieldType_bool;
    case ID_axis:       return FieldType_doubleArray;
    case ID_startAngle: return FieldType_double;
    case ID_stopAngle:  return FieldType_double;
    case ID_steps:      return FieldType_int;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: RevolveAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
RevolveAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_meshType:   return "enum";
    case ID_autoAxis:   return "bool";
    case ID_axis:       return "doubleArray";
    case ID_startAngle: return "double";
    case ID_stopAngle:  return "double";
    case ID_steps:      return "int";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RevolveAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
RevolveAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const RevolveAttributes &obj = *((const RevolveAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_meshType:
        {  // new scope
        retval = (meshType == obj.meshType);
        }
        break;
    case ID_autoAxis:
        {  // new scope
        retval = (autoAxis == obj.autoAxis);
        }
        break;
    case ID_axis:
        {  // new scope
        // Compare the axis arrays.
        bool axis_equal = true;
        for(int i = 0; i < 3 && axis_equal; ++i)
            axis_equal = (axis[i] == obj.axis[i]);

        retval = axis_equal;
        }
        break;
    case ID_startAngle:
        {  // new scope
        retval = (startAngle == obj.startAngle);
        }
        break;
    case ID_stopAngle:
        {  // new scope
        retval = (stopAngle == obj.stopAngle);
        }
        break;
    case ID_steps:
        {  // new scope
        retval = (steps == obj.steps);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

