/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyRadialResampleAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyRadialResampleAttributes
//
// Purpose: 
//   
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a RadialResampleAttributes.
//
struct RadialResampleAttributesObject
{
    PyObject_HEAD
    RadialResampleAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewRadialResampleAttributes(int);

std::string
PyRadialResampleAttributes_ToString(const RadialResampleAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetIsFast())
        SNPRINTF(tmpStr, 1000, "%sisFast = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sisFast = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminTheta = %g\n", prefix, atts->GetMinTheta());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxTheta = %g\n", prefix, atts->GetMaxTheta());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdeltaTheta = %g\n", prefix, atts->GetDeltaTheta());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradius = %g\n", prefix, atts->GetRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdeltaRadius = %g\n", prefix, atts->GetDeltaRadius());
    str += tmpStr;
    {   const float *center = atts->GetCenter();
        SNPRINTF(tmpStr, 1000, "%scenter = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", center[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetIs3D())
        SNPRINTF(tmpStr, 1000, "%sis3D = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sis3D = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sminAzimuth = %g\n", prefix, atts->GetMinAzimuth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%smaxAzimuth = %g\n", prefix, atts->GetMaxAzimuth());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sdeltaAzimuth = %g\n", prefix, atts->GetDeltaAzimuth());
    str += tmpStr;
    return str;
}

static PyObject *
RadialResampleAttributes_Notify(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_SetIsFast(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the isFast in the object.
    obj->data->SetIsFast(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetIsFast(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIsFast()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetMinTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the minTheta in the object.
    obj->data->SetMinTheta(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetMinTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMinTheta()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetMaxTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the maxTheta in the object.
    obj->data->SetMaxTheta(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetMaxTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMaxTheta()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetDeltaTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the deltaTheta in the object.
    obj->data->SetDeltaTheta(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetDeltaTheta(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetDeltaTheta()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetRadius(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the radius in the object.
    obj->data->SetRadius(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetRadius(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRadius()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetDeltaRadius(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the deltaRadius in the object.
    obj->data->SetDeltaRadius(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetDeltaRadius(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetDeltaRadius()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetCenter(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float *fvals = obj->data->GetCenter();
    if(!PyArg_ParseTuple(args, "fff", &fvals[0], &fvals[1], &fvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    fvals[i] = float(PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    fvals[i] = float(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    fvals[i] = float(PyLong_AsDouble(item));
                else
                    fvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the center in the object as modified.
    obj->data->SelectCenter();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetCenter(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the center.
    PyObject *retval = PyTuple_New(3);
    const float *center = obj->data->GetCenter();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(center[i])));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetIs3D(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the is3D in the object.
    obj->data->SetIs3D(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetIs3D(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIs3D()?1L:0L);
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetMinAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the minAzimuth in the object.
    obj->data->SetMinAzimuth(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetMinAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMinAzimuth()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetMaxAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the maxAzimuth in the object.
    obj->data->SetMaxAzimuth(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetMaxAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetMaxAzimuth()));
    return retval;
}

/*static*/ PyObject *
RadialResampleAttributes_SetDeltaAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the deltaAzimuth in the object.
    obj->data->SetDeltaAzimuth(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RadialResampleAttributes_GetDeltaAzimuth(PyObject *self, PyObject *args)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetDeltaAzimuth()));
    return retval;
}



PyMethodDef PyRadialResampleAttributes_methods[RADIALRESAMPLEATTRIBUTES_NMETH] = {
    {"Notify", RadialResampleAttributes_Notify, METH_VARARGS},
    {"SetIsFast", RadialResampleAttributes_SetIsFast, METH_VARARGS},
    {"GetIsFast", RadialResampleAttributes_GetIsFast, METH_VARARGS},
    {"SetMinTheta", RadialResampleAttributes_SetMinTheta, METH_VARARGS},
    {"GetMinTheta", RadialResampleAttributes_GetMinTheta, METH_VARARGS},
    {"SetMaxTheta", RadialResampleAttributes_SetMaxTheta, METH_VARARGS},
    {"GetMaxTheta", RadialResampleAttributes_GetMaxTheta, METH_VARARGS},
    {"SetDeltaTheta", RadialResampleAttributes_SetDeltaTheta, METH_VARARGS},
    {"GetDeltaTheta", RadialResampleAttributes_GetDeltaTheta, METH_VARARGS},
    {"SetRadius", RadialResampleAttributes_SetRadius, METH_VARARGS},
    {"GetRadius", RadialResampleAttributes_GetRadius, METH_VARARGS},
    {"SetDeltaRadius", RadialResampleAttributes_SetDeltaRadius, METH_VARARGS},
    {"GetDeltaRadius", RadialResampleAttributes_GetDeltaRadius, METH_VARARGS},
    {"SetCenter", RadialResampleAttributes_SetCenter, METH_VARARGS},
    {"GetCenter", RadialResampleAttributes_GetCenter, METH_VARARGS},
    {"SetIs3D", RadialResampleAttributes_SetIs3D, METH_VARARGS},
    {"GetIs3D", RadialResampleAttributes_GetIs3D, METH_VARARGS},
    {"SetMinAzimuth", RadialResampleAttributes_SetMinAzimuth, METH_VARARGS},
    {"GetMinAzimuth", RadialResampleAttributes_GetMinAzimuth, METH_VARARGS},
    {"SetMaxAzimuth", RadialResampleAttributes_SetMaxAzimuth, METH_VARARGS},
    {"GetMaxAzimuth", RadialResampleAttributes_GetMaxAzimuth, METH_VARARGS},
    {"SetDeltaAzimuth", RadialResampleAttributes_SetDeltaAzimuth, METH_VARARGS},
    {"GetDeltaAzimuth", RadialResampleAttributes_GetDeltaAzimuth, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RadialResampleAttributes_dealloc(PyObject *v)
{
   RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
RadialResampleAttributes_compare(PyObject *v, PyObject *w)
{
    RadialResampleAttributes *a = ((RadialResampleAttributesObject *)v)->data;
    RadialResampleAttributes *b = ((RadialResampleAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyRadialResampleAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "isFast") == 0)
        return RadialResampleAttributes_GetIsFast(self, NULL);
    if(strcmp(name, "minTheta") == 0)
        return RadialResampleAttributes_GetMinTheta(self, NULL);
    if(strcmp(name, "maxTheta") == 0)
        return RadialResampleAttributes_GetMaxTheta(self, NULL);
    if(strcmp(name, "deltaTheta") == 0)
        return RadialResampleAttributes_GetDeltaTheta(self, NULL);
    if(strcmp(name, "radius") == 0)
        return RadialResampleAttributes_GetRadius(self, NULL);
    if(strcmp(name, "deltaRadius") == 0)
        return RadialResampleAttributes_GetDeltaRadius(self, NULL);
    if(strcmp(name, "center") == 0)
        return RadialResampleAttributes_GetCenter(self, NULL);
    if(strcmp(name, "is3D") == 0)
        return RadialResampleAttributes_GetIs3D(self, NULL);
    if(strcmp(name, "minAzimuth") == 0)
        return RadialResampleAttributes_GetMinAzimuth(self, NULL);
    if(strcmp(name, "maxAzimuth") == 0)
        return RadialResampleAttributes_GetMaxAzimuth(self, NULL);
    if(strcmp(name, "deltaAzimuth") == 0)
        return RadialResampleAttributes_GetDeltaAzimuth(self, NULL);

    return Py_FindMethod(PyRadialResampleAttributes_methods, self, name);
}

int
PyRadialResampleAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "isFast") == 0)
        obj = RadialResampleAttributes_SetIsFast(self, tuple);
    else if(strcmp(name, "minTheta") == 0)
        obj = RadialResampleAttributes_SetMinTheta(self, tuple);
    else if(strcmp(name, "maxTheta") == 0)
        obj = RadialResampleAttributes_SetMaxTheta(self, tuple);
    else if(strcmp(name, "deltaTheta") == 0)
        obj = RadialResampleAttributes_SetDeltaTheta(self, tuple);
    else if(strcmp(name, "radius") == 0)
        obj = RadialResampleAttributes_SetRadius(self, tuple);
    else if(strcmp(name, "deltaRadius") == 0)
        obj = RadialResampleAttributes_SetDeltaRadius(self, tuple);
    else if(strcmp(name, "center") == 0)
        obj = RadialResampleAttributes_SetCenter(self, tuple);
    else if(strcmp(name, "is3D") == 0)
        obj = RadialResampleAttributes_SetIs3D(self, tuple);
    else if(strcmp(name, "minAzimuth") == 0)
        obj = RadialResampleAttributes_SetMinAzimuth(self, tuple);
    else if(strcmp(name, "maxAzimuth") == 0)
        obj = RadialResampleAttributes_SetMaxAzimuth(self, tuple);
    else if(strcmp(name, "deltaAzimuth") == 0)
        obj = RadialResampleAttributes_SetDeltaAzimuth(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
RadialResampleAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)v;
    fprintf(fp, "%s", PyRadialResampleAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
RadialResampleAttributes_str(PyObject *v)
{
    RadialResampleAttributesObject *obj = (RadialResampleAttributesObject *)v;
    return PyString_FromString(PyRadialResampleAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *RadialResampleAttributes_Purpose = "";
#else
static char *RadialResampleAttributes_Purpose = "";
#endif

//
// The type description structure
//
static PyTypeObject RadialResampleAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RadialResampleAttributes",                    // tp_name
    sizeof(RadialResampleAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RadialResampleAttributes_dealloc,  // tp_dealloc
    (printfunc)RadialResampleAttributes_print,     // tp_print
    (getattrfunc)PyRadialResampleAttributes_getattr, // tp_getattr
    (setattrfunc)PyRadialResampleAttributes_setattr, // tp_setattr
    (cmpfunc)RadialResampleAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RadialResampleAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RadialResampleAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RadialResampleAttributes *defaultAtts = 0;
static RadialResampleAttributes *currentAtts = 0;

static PyObject *
NewRadialResampleAttributes(int useCurrent)
{
    RadialResampleAttributesObject *newObject;
    newObject = PyObject_NEW(RadialResampleAttributesObject, &RadialResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new RadialResampleAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new RadialResampleAttributes(*defaultAtts);
    else
        newObject->data = new RadialResampleAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapRadialResampleAttributes(const RadialResampleAttributes *attr)
{
    RadialResampleAttributesObject *newObject;
    newObject = PyObject_NEW(RadialResampleAttributesObject, &RadialResampleAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RadialResampleAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RadialResampleAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewRadialResampleAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RadialResampleAttributesMethods[] = {
    {"RadialResampleAttributes", RadialResampleAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RadialResampleAttributesObserver = 0;

std::string
PyRadialResampleAttributes_GetLogString()
{
    std::string s("RadialResampleAtts = RadialResampleAttributes()\n");
    if(currentAtts != 0)
        s += PyRadialResampleAttributes_ToString(currentAtts, "RadialResampleAtts.");
    return s;
}

static void
PyRadialResampleAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("RadialResampleAtts = RadialResampleAttributes()\n");
        s += PyRadialResampleAttributes_ToString(currentAtts, "RadialResampleAtts.");
        cb(s);
    }
}

void
PyRadialResampleAttributes_StartUp(RadialResampleAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyRadialResampleAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RadialResampleAttributesObserver == 0)
    {
        RadialResampleAttributesObserver = new ObserverToCallback(subj,
            PyRadialResampleAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyRadialResampleAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RadialResampleAttributesObserver;
    RadialResampleAttributesObserver = 0;
}

PyMethodDef *
PyRadialResampleAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RadialResampleAttributesMethods;
}

bool
PyRadialResampleAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RadialResampleAttributesType);
}

RadialResampleAttributes *
PyRadialResampleAttributes_FromPyObject(PyObject *obj)
{
    RadialResampleAttributesObject *obj2 = (RadialResampleAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRadialResampleAttributes_New()
{
    return NewRadialResampleAttributes(0);
}

PyObject *
PyRadialResampleAttributes_Wrap(const RadialResampleAttributes *attr)
{
    return WrapRadialResampleAttributes(attr);
}

void
PyRadialResampleAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    RadialResampleAttributesObject *obj2 = (RadialResampleAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyRadialResampleAttributes_SetDefaults(const RadialResampleAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RadialResampleAttributes(*atts);
}

