/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <MultiresControlAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Init utility for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MultiresControlAttributes::Init()
{
    resolution = 0;
    maxResolution = 1;

    MultiresControlAttributes::SelectAll();
}

// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Copy utility for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MultiresControlAttributes::Copy(const MultiresControlAttributes &obj)
{
    resolution = obj.resolution;
    maxResolution = obj.maxResolution;
    info = obj.info;

    MultiresControlAttributes::SelectAll();
}

// Type map format string
const char *MultiresControlAttributes::TypeMapFormatString = MULTIRESCONTROLATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t MultiresControlAttributes::TmfsStruct = {MULTIRESCONTROLATTRIBUTES_TMFS};


// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Default constructor for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes::MultiresControlAttributes() : 
    AttributeSubject(MultiresControlAttributes::TypeMapFormatString)
{
    MultiresControlAttributes::Init();
}

// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Constructor for the derived classes of MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes::MultiresControlAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    MultiresControlAttributes::Init();
}

// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Copy constructor for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes::MultiresControlAttributes(const MultiresControlAttributes &obj) : 
    AttributeSubject(MultiresControlAttributes::TypeMapFormatString)
{
    MultiresControlAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MultiresControlAttributes::MultiresControlAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes::MultiresControlAttributes(const MultiresControlAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    MultiresControlAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MultiresControlAttributes::~MultiresControlAttributes
//
// Purpose: 
//   Destructor for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes::~MultiresControlAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MultiresControlAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiresControlAttributes& 
MultiresControlAttributes::operator = (const MultiresControlAttributes &obj)
{
    if (this == &obj) return *this;

    MultiresControlAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: MultiresControlAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiresControlAttributes::operator == (const MultiresControlAttributes &obj) const
{
    // Create the return value
    return ((resolution == obj.resolution) &&
            (maxResolution == obj.maxResolution) &&
            (info == obj.info));
}

// ****************************************************************************
// Method: MultiresControlAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiresControlAttributes::operator != (const MultiresControlAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MultiresControlAttributes::TypeName
//
// Purpose: 
//   Type name method for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
MultiresControlAttributes::TypeName() const
{
    return "MultiresControlAttributes";
}

// ****************************************************************************
// Method: MultiresControlAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiresControlAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MultiresControlAttributes *tmp = (const MultiresControlAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MultiresControlAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MultiresControlAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MultiresControlAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MultiresControlAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MultiresControlAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MultiresControlAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MultiresControlAttributes(*this);
    else
        retval = new MultiresControlAttributes;

    return retval;
}

// ****************************************************************************
// Method: MultiresControlAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MultiresControlAttributes::SelectAll()
{
    Select(ID_resolution,    (void *)&resolution);
    Select(ID_maxResolution, (void *)&maxResolution);
    Select(ID_info,          (void *)&info);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MultiresControlAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiresControlAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MultiresControlAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MultiresControlAttributes.
    DataNode *node = new DataNode("MultiresControlAttributes");

    if(completeSave || !FieldsEqual(ID_resolution, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("resolution", resolution));
    }

    if(completeSave || !FieldsEqual(ID_maxResolution, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxResolution", maxResolution));
    }

    if(completeSave || !FieldsEqual(ID_info, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("info", info));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MultiresControlAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MultiresControlAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MultiresControlAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("resolution")) != 0)
        SetResolution(node->AsInt());
    if((node = searchNode->GetNode("maxResolution")) != 0)
        SetMaxResolution(node->AsInt());
    if((node = searchNode->GetNode("info")) != 0)
        SetInfo(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MultiresControlAttributes::SetResolution(int resolution_)
{
    resolution = resolution_;
    Select(ID_resolution, (void *)&resolution);
}

void
MultiresControlAttributes::SetMaxResolution(int maxResolution_)
{
    maxResolution = maxResolution_;
    Select(ID_maxResolution, (void *)&maxResolution);
}

void
MultiresControlAttributes::SetInfo(const std::string &info_)
{
    info = info_;
    Select(ID_info, (void *)&info);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
MultiresControlAttributes::GetResolution() const
{
    return resolution;
}

int
MultiresControlAttributes::GetMaxResolution() const
{
    return maxResolution;
}

const std::string &
MultiresControlAttributes::GetInfo() const
{
    return info;
}

std::string &
MultiresControlAttributes::GetInfo()
{
    return info;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MultiresControlAttributes::SelectInfo()
{
    Select(ID_info, (void *)&info);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MultiresControlAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MultiresControlAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_resolution:    return "resolution";
    case ID_maxResolution: return "maxResolution";
    case ID_info:          return "info";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MultiresControlAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MultiresControlAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_resolution:    return FieldType_int;
    case ID_maxResolution: return FieldType_int;
    case ID_info:          return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MultiresControlAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MultiresControlAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_resolution:    return "int";
    case ID_maxResolution: return "int";
    case ID_info:          return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MultiresControlAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiresControlAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MultiresControlAttributes &obj = *((const MultiresControlAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_resolution:
        {  // new scope
        retval = (resolution == obj.resolution);
        }
        break;
    case ID_maxResolution:
        {  // new scope
        retval = (maxResolution == obj.maxResolution);
        }
        break;
    case ID_info:
        {  // new scope
        retval = (info == obj.info);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

