/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMergeOperatorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyMergeOperatorAttributes
//
// Purpose: 
//   Attributes for Merge operaetor
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MergeOperatorAttributes.
//
struct MergeOperatorAttributesObject
{
    PyObject_HEAD
    MergeOperatorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMergeOperatorAttributes(int);

std::string
PyMergeOperatorAttributes_ToString(const MergeOperatorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetParallelMerge())
        SNPRINTF(tmpStr, 1000, "%sparallelMerge = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sparallelMerge = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stolerance = %g\n", prefix, atts->GetTolerance());
    str += tmpStr;
    return str;
}

static PyObject *
MergeOperatorAttributes_Notify(PyObject *self, PyObject *args)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MergeOperatorAttributes_SetParallelMerge(PyObject *self, PyObject *args)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallelMerge in the object.
    obj->data->SetParallelMerge(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MergeOperatorAttributes_GetParallelMerge(PyObject *self, PyObject *args)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetParallelMerge()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MergeOperatorAttributes_SetTolerance(PyObject *self, PyObject *args)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the tolerance in the object.
    obj->data->SetTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MergeOperatorAttributes_GetTolerance(PyObject *self, PyObject *args)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTolerance());
    return retval;
}



PyMethodDef PyMergeOperatorAttributes_methods[MERGEOPERATORATTRIBUTES_NMETH] = {
    {"Notify", MergeOperatorAttributes_Notify, METH_VARARGS},
    {"SetParallelMerge", MergeOperatorAttributes_SetParallelMerge, METH_VARARGS},
    {"GetParallelMerge", MergeOperatorAttributes_GetParallelMerge, METH_VARARGS},
    {"SetTolerance", MergeOperatorAttributes_SetTolerance, METH_VARARGS},
    {"GetTolerance", MergeOperatorAttributes_GetTolerance, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MergeOperatorAttributes_dealloc(PyObject *v)
{
   MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MergeOperatorAttributes_compare(PyObject *v, PyObject *w)
{
    MergeOperatorAttributes *a = ((MergeOperatorAttributesObject *)v)->data;
    MergeOperatorAttributes *b = ((MergeOperatorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMergeOperatorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "parallelMerge") == 0)
        return MergeOperatorAttributes_GetParallelMerge(self, NULL);
    if(strcmp(name, "tolerance") == 0)
        return MergeOperatorAttributes_GetTolerance(self, NULL);

    return Py_FindMethod(PyMergeOperatorAttributes_methods, self, name);
}

int
PyMergeOperatorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "parallelMerge") == 0)
        obj = MergeOperatorAttributes_SetParallelMerge(self, tuple);
    else if(strcmp(name, "tolerance") == 0)
        obj = MergeOperatorAttributes_SetTolerance(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MergeOperatorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)v;
    fprintf(fp, "%s", PyMergeOperatorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MergeOperatorAttributes_str(PyObject *v)
{
    MergeOperatorAttributesObject *obj = (MergeOperatorAttributesObject *)v;
    return PyString_FromString(PyMergeOperatorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MergeOperatorAttributes_Purpose = "Attributes for Merge operaetor";
#else
static char *MergeOperatorAttributes_Purpose = "Attributes for Merge operaetor";
#endif

//
// The type description structure
//
static PyTypeObject MergeOperatorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MergeOperatorAttributes",                    // tp_name
    sizeof(MergeOperatorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MergeOperatorAttributes_dealloc,  // tp_dealloc
    (printfunc)MergeOperatorAttributes_print,     // tp_print
    (getattrfunc)PyMergeOperatorAttributes_getattr, // tp_getattr
    (setattrfunc)PyMergeOperatorAttributes_setattr, // tp_setattr
    (cmpfunc)MergeOperatorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MergeOperatorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MergeOperatorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MergeOperatorAttributes *defaultAtts = 0;
static MergeOperatorAttributes *currentAtts = 0;

static PyObject *
NewMergeOperatorAttributes(int useCurrent)
{
    MergeOperatorAttributesObject *newObject;
    newObject = PyObject_NEW(MergeOperatorAttributesObject, &MergeOperatorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MergeOperatorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MergeOperatorAttributes(*defaultAtts);
    else
        newObject->data = new MergeOperatorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMergeOperatorAttributes(const MergeOperatorAttributes *attr)
{
    MergeOperatorAttributesObject *newObject;
    newObject = PyObject_NEW(MergeOperatorAttributesObject, &MergeOperatorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MergeOperatorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MergeOperatorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMergeOperatorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MergeOperatorAttributesMethods[] = {
    {"MergeOperatorAttributes", MergeOperatorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MergeOperatorAttributesObserver = 0;

std::string
PyMergeOperatorAttributes_GetLogString()
{
    std::string s("MergeOperatorAtts = MergeOperatorAttributes()\n");
    if(currentAtts != 0)
        s += PyMergeOperatorAttributes_ToString(currentAtts, "MergeOperatorAtts.");
    return s;
}

static void
PyMergeOperatorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MergeOperatorAtts = MergeOperatorAttributes()\n");
        s += PyMergeOperatorAttributes_ToString(currentAtts, "MergeOperatorAtts.");
        cb(s);
    }
}

void
PyMergeOperatorAttributes_StartUp(MergeOperatorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMergeOperatorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MergeOperatorAttributesObserver == 0)
    {
        MergeOperatorAttributesObserver = new ObserverToCallback(subj,
            PyMergeOperatorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMergeOperatorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MergeOperatorAttributesObserver;
    MergeOperatorAttributesObserver = 0;
}

PyMethodDef *
PyMergeOperatorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MergeOperatorAttributesMethods;
}

bool
PyMergeOperatorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MergeOperatorAttributesType);
}

MergeOperatorAttributes *
PyMergeOperatorAttributes_FromPyObject(PyObject *obj)
{
    MergeOperatorAttributesObject *obj2 = (MergeOperatorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMergeOperatorAttributes_New()
{
    return NewMergeOperatorAttributes(0);
}

PyObject *
PyMergeOperatorAttributes_Wrap(const MergeOperatorAttributes *attr)
{
    return WrapMergeOperatorAttributes(attr);
}

void
PyMergeOperatorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MergeOperatorAttributesObject *obj2 = (MergeOperatorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMergeOperatorAttributes_SetDefaults(const MergeOperatorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MergeOperatorAttributes(*atts);
}

