/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtIsosurfaceFilter.C
// ************************************************************************* //

#include <avtIsosurfaceFilter.h>

#include <ContourOpAttributes.h>

#include <avtContourFilter.h>


// ****************************************************************************
//  Method: avtIsosurfaceFilter constructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

avtIsosurfaceFilter::avtIsosurfaceFilter()
{
    cf = NULL;
}


// ****************************************************************************
//  Method: avtIsosurfaceFilter destructor
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
//  Modifications:
//
// ****************************************************************************

avtIsosurfaceFilter::~avtIsosurfaceFilter()
{
    if (cf != NULL)
    {
        delete cf;
        cf = NULL;
    }
}


// ****************************************************************************
//  Method:  avtIsosurfaceFilter::Create
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

avtFilter *
avtIsosurfaceFilter::Create()
{
    return new avtIsosurfaceFilter();
}


// ****************************************************************************
//  Method:      avtIsosurfaceFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
//  Modifications:
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtIsosurfaceFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const IsosurfaceAttributes*)a;

    //
    // Construct a new contour filter based on these attributes.
    //
    if (cf != NULL)
    {
        delete cf;
    }
    ContourOpAttributes coa;
    coa.SetContourNLevels(atts.GetContourNLevels());
    coa.SetContourValue(atts.GetContourValue());
    coa.SetContourPercent(atts.GetContourPercent());
    coa.SetContourMethod(ContourOpAttributes::ContourMethod(
        atts.GetContourMethod()));
    coa.SetMinFlag(atts.GetMinFlag());
    coa.SetMaxFlag(atts.GetMaxFlag());
    coa.SetMin(atts.GetMin());
    coa.SetMax(atts.GetMax());
    coa.SetScaling(ContourOpAttributes::ContourScaling(atts.GetScaling()));
    coa.SetVariable(atts.GetVariable());
    cf = new avtContourFilter(coa);
    cf->ShouldCreateLabels(false);
    cf->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
}


// ****************************************************************************
//  Method: avtIsosurfaceFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtIsosurfaceFilter with the given
//      parameters would result in an equivalent avtIsosurfaceFilter.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Tue Apr 16 10:37:31 PDT 2002
//
// ****************************************************************************

bool
avtIsosurfaceFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(IsosurfaceAttributes*)a);
}

// ****************************************************************************
//  Method: avtIsosurfaceFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   April 16, 2002
//
// ****************************************************************************

avtFilter *
avtIsosurfaceFilter::GetFacadedFilter(void)
{
    return cf;
}

// ****************************************************************************
//  Method: avtIsosurfaceFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtIsosurfaceFilter::GetFacadedFilter(void) const
{
    return cf;
}

// ****************************************************************************
// Method: avtIsosurfaceFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//    Brad Whitlock, Mon Apr  7 15:55:02 PDT 2014
//    Add filter metadata used in export.
//    Work partially supported by DOE Grant SC0007548.
//
// ****************************************************************************

void
avtIsosurfaceFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    const IsosurfaceAttributes &iso = ((const avtIsosurfaceFilter *)This)->atts;

    char tmp[200];
    std::string params;
    if(iso.GetContourMethod() == IsosurfaceAttributes::Level)
    {
        SNPRINTF(tmp, 200, "contourNLevels=%d", iso.GetContourNLevels());
        params = tmp;
    }
    else if(iso.GetContourMethod() == IsosurfaceAttributes::Value)
    {
        params = "contourValue=";
        for(size_t i = 0; i < iso.GetContourValue().size(); ++i)
        {
            SNPRINTF(tmp, 200, "%lg", iso.GetContourValue()[i]);
            params += tmp;
            if(i < iso.GetContourValue().size()-1)
                params += ", ";
        }
    }
    else if(iso.GetContourMethod() == IsosurfaceAttributes::Percent)
    {
        params = "contourPercent=";
        for(size_t i = 0; i < iso.GetContourPercent().size(); ++i)
        {
            SNPRINTF(tmp, 200, "%lg", iso.GetContourPercent()[i]);
            params += tmp;
            if(i < iso.GetContourValue().size()-1)
                params += ", ";
        }
    }
    outAtts.AddFilterMetaData("Isosurface", params);
}
