/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisFiveFoldTetSubdivisionWindow.h"

#include <FiveFoldTetSubdivisionAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisFiveFoldTetSubdivisionWindow::QvisFiveFoldTetSubdivisionWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFiveFoldTetSubdivisionWindow::QvisFiveFoldTetSubdivisionWindow(const int type,
                         FiveFoldTetSubdivisionAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisFiveFoldTetSubdivisionWindow::~QvisFiveFoldTetSubdivisionWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisFiveFoldTetSubdivisionWindow::~QvisFiveFoldTetSubdivisionWindow()
{
}


// ****************************************************************************
// Method: QvisFiveFoldTetSubdivisionWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFiveFoldTetSubdivisionWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    oddParityHasSixNeighborhood = new QCheckBox(tr("Vertices with odd parity have six neighborhood "), central);
    connect(oddParityHasSixNeighborhood, SIGNAL(toggled(bool)),
            this, SLOT(oddParityHasSixNeighborhoodChanged(bool)));
    mainLayout->addWidget(oddParityHasSixNeighborhood, 0,0);

    addComponentInformation = new QCheckBox(tr("Add component information from contour tree"), central);
    connect(addComponentInformation, SIGNAL(toggled(bool)),
            this, SLOT(addComponentInformationChanged(bool)));
    mainLayout->addWidget(addComponentInformation, 1,0);

    idVarLabel = new QLabel(tr("ID variable"), central);
    mainLayout->addWidget(idVarLabel,2,0);
    int idVarMask = QvisVariableButton::Scalars;
    idVar = new QvisVariableButton(true, true, true, idVarMask, central);
    connect(idVar, SIGNAL(activated(const QString&)),
            this, SLOT(idVarChanged(const QString&)));
    mainLayout->addWidget(idVar, 2,1);

    valueVarLabel = new QLabel(tr("Value variable"), central);
    mainLayout->addWidget(valueVarLabel,3,0);
    int valueVarMask = QvisVariableButton::Scalars;
    valueVar = new QvisVariableButton(true, true, true, valueVarMask, central);
    connect(valueVar, SIGNAL(activated(const QString&)),
            this, SLOT(valueVarChanged(const QString&)));
    mainLayout->addWidget(valueVar, 3,1);

    contourTreeFilenameLabel = new QLabel(tr("Contour Tree Filename"), central);
    mainLayout->addWidget(contourTreeFilenameLabel,4,0);
    contourTreeFilename = new QLineEdit(central);
    connect(contourTreeFilename, SIGNAL(returnPressed()),
            this, SLOT(contourTreeFilenameProcessText()));
    mainLayout->addWidget(contourTreeFilename, 4,1);

    isovalueLabel = new QLabel(tr("Isovalue"), central);
    mainLayout->addWidget(isovalueLabel,5,0);
    isovalue = new QLineEdit(central);
    connect(isovalue, SIGNAL(returnPressed()),
            this, SLOT(isovalueProcessText()));
    mainLayout->addWidget(isovalue, 5,1);

    selectedIdsLabel = new QLabel(tr("Selected IDs"), central);
    mainLayout->addWidget(selectedIdsLabel,6,0);
    selectedIds = new QLineEdit(central);
    connect(selectedIds, SIGNAL(returnPressed()),
            this, SLOT(selectedIdsProcessText()));
    mainLayout->addWidget(selectedIds, 6,1);

    highlightedIdsLabel = new QLabel(tr("Highlighted IDs"), central);
    mainLayout->addWidget(highlightedIdsLabel,7,0);
    highlightedIds = new QLineEdit(central);
    connect(highlightedIds, SIGNAL(returnPressed()),
            this, SLOT(highlightedIdsProcessText()));
    mainLayout->addWidget(highlightedIds, 7,1);

}


// ****************************************************************************
// Method: QvisFiveFoldTetSubdivisionWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFiveFoldTetSubdivisionWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case FiveFoldTetSubdivisionAttributes::ID_oddParityHasSixNeighborhood:
            oddParityHasSixNeighborhood->blockSignals(true);
            oddParityHasSixNeighborhood->setChecked(atts->GetOddParityHasSixNeighborhood());
            oddParityHasSixNeighborhood->blockSignals(false);
            break;
          case FiveFoldTetSubdivisionAttributes::ID_addComponentInformation:
            if (atts->GetAddComponentInformation() == true)
            {
                idVar->setEnabled(true);
                if(idVarLabel)
                    idVarLabel->setEnabled(true);
            }
            else
            {
                idVar->setEnabled(false);
                if(idVarLabel)
                    idVarLabel->setEnabled(false);
            }
            if (atts->GetAddComponentInformation() == true)
            {
                valueVar->setEnabled(true);
                if(valueVarLabel)
                    valueVarLabel->setEnabled(true);
            }
            else
            {
                valueVar->setEnabled(false);
                if(valueVarLabel)
                    valueVarLabel->setEnabled(false);
            }
            if (atts->GetAddComponentInformation() == true)
            {
                contourTreeFilename->setEnabled(true);
                if(contourTreeFilenameLabel)
                    contourTreeFilenameLabel->setEnabled(true);
            }
            else
            {
                contourTreeFilename->setEnabled(false);
                if(contourTreeFilenameLabel)
                    contourTreeFilenameLabel->setEnabled(false);
            }
            if (atts->GetAddComponentInformation() == true)
            {
                isovalue->setEnabled(true);
                if(isovalueLabel)
                    isovalueLabel->setEnabled(true);
            }
            else
            {
                isovalue->setEnabled(false);
                if(isovalueLabel)
                    isovalueLabel->setEnabled(false);
            }
            if (atts->GetAddComponentInformation() == true)
            {
                selectedIds->setEnabled(true);
                if(selectedIdsLabel)
                    selectedIdsLabel->setEnabled(true);
            }
            else
            {
                selectedIds->setEnabled(false);
                if(selectedIdsLabel)
                    selectedIdsLabel->setEnabled(false);
            }
            addComponentInformation->blockSignals(true);
            addComponentInformation->setChecked(atts->GetAddComponentInformation());
            addComponentInformation->blockSignals(false);
            break;
          case FiveFoldTetSubdivisionAttributes::ID_idVar:
            idVar->blockSignals(true);
            idVar->setText(QString(atts->GetIdVar().c_str()));
            idVar->blockSignals(false);
            break;
          case FiveFoldTetSubdivisionAttributes::ID_valueVar:
            valueVar->blockSignals(true);
            valueVar->setText(QString(atts->GetValueVar().c_str()));
            valueVar->blockSignals(false);
            break;
          case FiveFoldTetSubdivisionAttributes::ID_contourTreeFilename:
            contourTreeFilename->setText(QString(atts->GetContourTreeFilename().c_str()));
            break;
          case FiveFoldTetSubdivisionAttributes::ID_isovalue:
            isovalue->setText(DoubleToQString(atts->GetIsovalue()));
            break;
          case FiveFoldTetSubdivisionAttributes::ID_selectedIds:
            selectedIds->setText(IntsToQString(atts->GetSelectedIds()));
            break;
          case FiveFoldTetSubdivisionAttributes::ID_highlightedIds:
            highlightedIds->setText(IntsToQString(atts->GetHighlightedIds()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisFiveFoldTetSubdivisionWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisFiveFoldTetSubdivisionWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do contourTreeFilename
    if(which_widget == FiveFoldTetSubdivisionAttributes::ID_contourTreeFilename || doAll)
    {
        QString temp = contourTreeFilename->displayText();
        if(!temp.isEmpty())
            atts->SetContourTreeFilename(temp.toStdString());
        else
        {
            ResettingError(tr("Contour Tree Filename"),
                QString(atts->GetContourTreeFilename().c_str()));
            atts->SetContourTreeFilename(atts->GetContourTreeFilename());
        }
    }

    // Do isovalue
    if(which_widget == FiveFoldTetSubdivisionAttributes::ID_isovalue || doAll)
    {
        double val;
        if(LineEditGetDouble(isovalue, val))
            atts->SetIsovalue(val);
        else
        {
            ResettingError(tr("Isovalue"),
                DoubleToQString(atts->GetIsovalue()));
            atts->SetIsovalue(atts->GetIsovalue());
        }
    }

    // Do selectedIds
    if(which_widget == FiveFoldTetSubdivisionAttributes::ID_selectedIds || doAll)
    {
        intVector val;
        if(LineEditGetInts(selectedIds, val))
            atts->SetSelectedIds(val);
        else
        {
            ResettingError(tr("Selected IDs"),
                IntsToQString(atts->GetSelectedIds()));
            atts->SetSelectedIds(atts->GetSelectedIds());
        }
    }

    // Do highlightedIds
    if(which_widget == FiveFoldTetSubdivisionAttributes::ID_highlightedIds || doAll)
    {
        intVector val;
        if(LineEditGetInts(highlightedIds, val))
            atts->SetHighlightedIds(val);
        else
        {
            ResettingError(tr("Highlighted IDs"),
                IntsToQString(atts->GetHighlightedIds()));
            atts->SetHighlightedIds(atts->GetHighlightedIds());
        }
    }

}


//
// Qt Slot functions
//


void
QvisFiveFoldTetSubdivisionWindow::oddParityHasSixNeighborhoodChanged(bool val)
{
    atts->SetOddParityHasSixNeighborhood(val);
    SetUpdate(false);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::addComponentInformationChanged(bool val)
{
    atts->SetAddComponentInformation(val);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::idVarChanged(const QString &varName)
{
    atts->SetIdVar(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::valueVarChanged(const QString &varName)
{
    atts->SetValueVar(varName.toStdString());
    SetUpdate(false);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::contourTreeFilenameProcessText()
{
    GetCurrentValues(FiveFoldTetSubdivisionAttributes::ID_contourTreeFilename);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::isovalueProcessText()
{
    GetCurrentValues(FiveFoldTetSubdivisionAttributes::ID_isovalue);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::selectedIdsProcessText()
{
    GetCurrentValues(FiveFoldTetSubdivisionAttributes::ID_selectedIds);
    Apply();
}


void
QvisFiveFoldTetSubdivisionWindow::highlightedIdsProcessText()
{
    GetCurrentValues(FiveFoldTetSubdivisionAttributes::ID_highlightedIds);
    Apply();
}


