/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyCoordSwapAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyCoordSwapAttributes
//
// Purpose: 
//   This class contains attributes for the coord swap operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a CoordSwapAttributes.
//
struct CoordSwapAttributesObject
{
    PyObject_HEAD
    CoordSwapAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewCoordSwapAttributes(int);

std::string
PyCoordSwapAttributes_ToString(const CoordSwapAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *newCoord1_names = "Coord1, Coord2, Coord3";
    switch (atts->GetNewCoord1())
    {
      case CoordSwapAttributes::Coord1:
          SNPRINTF(tmpStr, 1000, "%snewCoord1 = %sCoord1  # %s\n", prefix, prefix, newCoord1_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord2:
          SNPRINTF(tmpStr, 1000, "%snewCoord1 = %sCoord2  # %s\n", prefix, prefix, newCoord1_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord3:
          SNPRINTF(tmpStr, 1000, "%snewCoord1 = %sCoord3  # %s\n", prefix, prefix, newCoord1_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *newCoord2_names = "Coord1, Coord2, Coord3";
    switch (atts->GetNewCoord2())
    {
      case CoordSwapAttributes::Coord1:
          SNPRINTF(tmpStr, 1000, "%snewCoord2 = %sCoord1  # %s\n", prefix, prefix, newCoord2_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord2:
          SNPRINTF(tmpStr, 1000, "%snewCoord2 = %sCoord2  # %s\n", prefix, prefix, newCoord2_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord3:
          SNPRINTF(tmpStr, 1000, "%snewCoord2 = %sCoord3  # %s\n", prefix, prefix, newCoord2_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *newCoord3_names = "Coord1, Coord2, Coord3";
    switch (atts->GetNewCoord3())
    {
      case CoordSwapAttributes::Coord1:
          SNPRINTF(tmpStr, 1000, "%snewCoord3 = %sCoord1  # %s\n", prefix, prefix, newCoord3_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord2:
          SNPRINTF(tmpStr, 1000, "%snewCoord3 = %sCoord2  # %s\n", prefix, prefix, newCoord3_names);
          str += tmpStr;
          break;
      case CoordSwapAttributes::Coord3:
          SNPRINTF(tmpStr, 1000, "%snewCoord3 = %sCoord3  # %s\n", prefix, prefix, newCoord3_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
CoordSwapAttributes_Notify(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CoordSwapAttributes_SetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord1 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord1(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord1 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CoordSwapAttributes_GetNewCoord1(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord1()));
    return retval;
}

/*static*/ PyObject *
CoordSwapAttributes_SetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord2 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord2(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord2 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CoordSwapAttributes_GetNewCoord2(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord2()));
    return retval;
}

/*static*/ PyObject *
CoordSwapAttributes_SetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the newCoord3 in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetNewCoord3(CoordSwapAttributes::Coord(ival));
    else
    {
        fprintf(stderr, "An invalid newCoord3 value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Coord1, Coord2, Coord3.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
CoordSwapAttributes_GetNewCoord3(PyObject *self, PyObject *args)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNewCoord3()));
    return retval;
}



PyMethodDef PyCoordSwapAttributes_methods[COORDSWAPATTRIBUTES_NMETH] = {
    {"Notify", CoordSwapAttributes_Notify, METH_VARARGS},
    {"SetNewCoord1", CoordSwapAttributes_SetNewCoord1, METH_VARARGS},
    {"GetNewCoord1", CoordSwapAttributes_GetNewCoord1, METH_VARARGS},
    {"SetNewCoord2", CoordSwapAttributes_SetNewCoord2, METH_VARARGS},
    {"GetNewCoord2", CoordSwapAttributes_GetNewCoord2, METH_VARARGS},
    {"SetNewCoord3", CoordSwapAttributes_SetNewCoord3, METH_VARARGS},
    {"GetNewCoord3", CoordSwapAttributes_GetNewCoord3, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
CoordSwapAttributes_dealloc(PyObject *v)
{
   CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
CoordSwapAttributes_compare(PyObject *v, PyObject *w)
{
    CoordSwapAttributes *a = ((CoordSwapAttributesObject *)v)->data;
    CoordSwapAttributes *b = ((CoordSwapAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyCoordSwapAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "newCoord1") == 0)
        return CoordSwapAttributes_GetNewCoord1(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));

    if(strcmp(name, "newCoord2") == 0)
        return CoordSwapAttributes_GetNewCoord2(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));

    if(strcmp(name, "newCoord3") == 0)
        return CoordSwapAttributes_GetNewCoord3(self, NULL);
    if(strcmp(name, "Coord1") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord1));
    if(strcmp(name, "Coord2") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord2));
    if(strcmp(name, "Coord3") == 0)
        return PyInt_FromLong(long(CoordSwapAttributes::Coord3));


    return Py_FindMethod(PyCoordSwapAttributes_methods, self, name);
}

int
PyCoordSwapAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "newCoord1") == 0)
        obj = CoordSwapAttributes_SetNewCoord1(self, tuple);
    else if(strcmp(name, "newCoord2") == 0)
        obj = CoordSwapAttributes_SetNewCoord2(self, tuple);
    else if(strcmp(name, "newCoord3") == 0)
        obj = CoordSwapAttributes_SetNewCoord3(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
CoordSwapAttributes_print(PyObject *v, FILE *fp, int flags)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;
    fprintf(fp, "%s", PyCoordSwapAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
CoordSwapAttributes_str(PyObject *v)
{
    CoordSwapAttributesObject *obj = (CoordSwapAttributesObject *)v;
    return PyString_FromString(PyCoordSwapAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *CoordSwapAttributes_Purpose = "This class contains attributes for the coord swap operator.";
#else
static char *CoordSwapAttributes_Purpose = "This class contains attributes for the coord swap operator.";
#endif

//
// The type description structure
//
static PyTypeObject CoordSwapAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "CoordSwapAttributes",                    // tp_name
    sizeof(CoordSwapAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)CoordSwapAttributes_dealloc,  // tp_dealloc
    (printfunc)CoordSwapAttributes_print,     // tp_print
    (getattrfunc)PyCoordSwapAttributes_getattr, // tp_getattr
    (setattrfunc)PyCoordSwapAttributes_setattr, // tp_setattr
    (cmpfunc)CoordSwapAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)CoordSwapAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    CoordSwapAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static CoordSwapAttributes *defaultAtts = 0;
static CoordSwapAttributes *currentAtts = 0;

static PyObject *
NewCoordSwapAttributes(int useCurrent)
{
    CoordSwapAttributesObject *newObject;
    newObject = PyObject_NEW(CoordSwapAttributesObject, &CoordSwapAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new CoordSwapAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new CoordSwapAttributes(*defaultAtts);
    else
        newObject->data = new CoordSwapAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapCoordSwapAttributes(const CoordSwapAttributes *attr)
{
    CoordSwapAttributesObject *newObject;
    newObject = PyObject_NEW(CoordSwapAttributesObject, &CoordSwapAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (CoordSwapAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
CoordSwapAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewCoordSwapAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef CoordSwapAttributesMethods[] = {
    {"CoordSwapAttributes", CoordSwapAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *CoordSwapAttributesObserver = 0;

std::string
PyCoordSwapAttributes_GetLogString()
{
    std::string s("CoordSwapAtts = CoordSwapAttributes()\n");
    if(currentAtts != 0)
        s += PyCoordSwapAttributes_ToString(currentAtts, "CoordSwapAtts.");
    return s;
}

static void
PyCoordSwapAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("CoordSwapAtts = CoordSwapAttributes()\n");
        s += PyCoordSwapAttributes_ToString(currentAtts, "CoordSwapAtts.");
        cb(s);
    }
}

void
PyCoordSwapAttributes_StartUp(CoordSwapAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyCoordSwapAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(CoordSwapAttributesObserver == 0)
    {
        CoordSwapAttributesObserver = new ObserverToCallback(subj,
            PyCoordSwapAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyCoordSwapAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete CoordSwapAttributesObserver;
    CoordSwapAttributesObserver = 0;
}

PyMethodDef *
PyCoordSwapAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return CoordSwapAttributesMethods;
}

bool
PyCoordSwapAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &CoordSwapAttributesType);
}

CoordSwapAttributes *
PyCoordSwapAttributes_FromPyObject(PyObject *obj)
{
    CoordSwapAttributesObject *obj2 = (CoordSwapAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyCoordSwapAttributes_New()
{
    return NewCoordSwapAttributes(0);
}

PyObject *
PyCoordSwapAttributes_Wrap(const CoordSwapAttributes *attr)
{
    return WrapCoordSwapAttributes(attr);
}

void
PyCoordSwapAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    CoordSwapAttributesObject *obj2 = (CoordSwapAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyCoordSwapAttributes_SetDefaults(const CoordSwapAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new CoordSwapAttributes(*atts);
}

