/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ChannelCommAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Init utility for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ChannelCommAttributes::Init()
{
    numInX = 10;
    numInY = 10;

    ChannelCommAttributes::SelectAll();
}

// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Copy utility for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ChannelCommAttributes::Copy(const ChannelCommAttributes &obj)
{
    numInX = obj.numInX;
    numInY = obj.numInY;
    velocity = obj.velocity;

    ChannelCommAttributes::SelectAll();
}

// Type map format string
const char *ChannelCommAttributes::TypeMapFormatString = CHANNELCOMMATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ChannelCommAttributes::TmfsStruct = {CHANNELCOMMATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Default constructor for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes::ChannelCommAttributes() : 
    AttributeSubject(ChannelCommAttributes::TypeMapFormatString),
    velocity("default")
{
    ChannelCommAttributes::Init();
}

// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Constructor for the derived classes of ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes::ChannelCommAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    velocity("default")
{
    ChannelCommAttributes::Init();
}

// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Copy constructor for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes::ChannelCommAttributes(const ChannelCommAttributes &obj) : 
    AttributeSubject(ChannelCommAttributes::TypeMapFormatString)
{
    ChannelCommAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ChannelCommAttributes::ChannelCommAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes::ChannelCommAttributes(const ChannelCommAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ChannelCommAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ChannelCommAttributes::~ChannelCommAttributes
//
// Purpose: 
//   Destructor for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes::~ChannelCommAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ChannelCommAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ChannelCommAttributes& 
ChannelCommAttributes::operator = (const ChannelCommAttributes &obj)
{
    if (this == &obj) return *this;

    ChannelCommAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ChannelCommAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ChannelCommAttributes::operator == (const ChannelCommAttributes &obj) const
{
    // Create the return value
    return ((numInX == obj.numInX) &&
            (numInY == obj.numInY) &&
            (velocity == obj.velocity));
}

// ****************************************************************************
// Method: ChannelCommAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ChannelCommAttributes::operator != (const ChannelCommAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ChannelCommAttributes::TypeName
//
// Purpose: 
//   Type name method for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ChannelCommAttributes::TypeName() const
{
    return "ChannelCommAttributes";
}

// ****************************************************************************
// Method: ChannelCommAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ChannelCommAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ChannelCommAttributes *tmp = (const ChannelCommAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ChannelCommAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ChannelCommAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ChannelCommAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ChannelCommAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ChannelCommAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ChannelCommAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ChannelCommAttributes(*this);
    else
        retval = new ChannelCommAttributes;

    return retval;
}

// ****************************************************************************
// Method: ChannelCommAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ChannelCommAttributes::SelectAll()
{
    Select(ID_numInX,   (void *)&numInX);
    Select(ID_numInY,   (void *)&numInY);
    Select(ID_velocity, (void *)&velocity);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ChannelCommAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ChannelCommAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ChannelCommAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ChannelCommAttributes.
    DataNode *node = new DataNode("ChannelCommAttributes");

    if(completeSave || !FieldsEqual(ID_numInX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numInX", numInX));
    }

    if(completeSave || !FieldsEqual(ID_numInY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numInY", numInY));
    }

    if(completeSave || !FieldsEqual(ID_velocity, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("velocity", velocity));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ChannelCommAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ChannelCommAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ChannelCommAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("numInX")) != 0)
        SetNumInX(node->AsInt());
    if((node = searchNode->GetNode("numInY")) != 0)
        SetNumInY(node->AsInt());
    if((node = searchNode->GetNode("velocity")) != 0)
        SetVelocity(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ChannelCommAttributes::SetNumInX(int numInX_)
{
    numInX = numInX_;
    Select(ID_numInX, (void *)&numInX);
}

void
ChannelCommAttributes::SetNumInY(int numInY_)
{
    numInY = numInY_;
    Select(ID_numInY, (void *)&numInY);
}

void
ChannelCommAttributes::SetVelocity(const std::string &velocity_)
{
    velocity = velocity_;
    Select(ID_velocity, (void *)&velocity);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
ChannelCommAttributes::GetNumInX() const
{
    return numInX;
}

int
ChannelCommAttributes::GetNumInY() const
{
    return numInY;
}

const std::string &
ChannelCommAttributes::GetVelocity() const
{
    return velocity;
}

std::string &
ChannelCommAttributes::GetVelocity()
{
    return velocity;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ChannelCommAttributes::SelectVelocity()
{
    Select(ID_velocity, (void *)&velocity);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ChannelCommAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ChannelCommAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_numInX:   return "numInX";
    case ID_numInY:   return "numInY";
    case ID_velocity: return "velocity";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ChannelCommAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ChannelCommAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_numInX:   return FieldType_int;
    case ID_numInY:   return FieldType_int;
    case ID_velocity: return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ChannelCommAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ChannelCommAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_numInX:   return "int";
    case ID_numInY:   return "int";
    case ID_velocity: return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ChannelCommAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ChannelCommAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ChannelCommAttributes &obj = *((const ChannelCommAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_numInX:
        {  // new scope
        retval = (numInX == obj.numInX);
        }
        break;
    case ID_numInY:
        {  // new scope
        retval = (numInY == obj.numInY);
        }
        break;
    case ID_velocity:
        {  // new scope
        retval = (velocity == obj.velocity);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

