// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit;

import java.util.Vector;
import java.lang.Integer;
import java.lang.Double;

// ****************************************************************************
// Class: avtDatabaseMetaData
//
// Purpose:
//    Contains database metadata attributes
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class avtDatabaseMetaData extends AttributeSubject
{
    private static int avtDatabaseMetaData_numAdditionalAtts = 36;

    public avtDatabaseMetaData()
    {
        super(avtDatabaseMetaData_numAdditionalAtts);

        hasTemporalExtents = false;
        minTemporalExtents = 0;
        maxTemporalExtents = 0;
        numStates = 0;
        isVirtualDatabase = false;
        mustRepopulateOnStateChange = false;
        mustAlphabetizeVariables = true;
        formatCanDoDomainDecomposition = false;
        formatCanDoMultires = false;
        useCatchAllMesh = false;
        timeStepPath = new String("");
        timeStepNames = new Vector();
        cycles = new Vector();
        cyclesAreAccurate = new Vector();
        times = new Vector();
        timesAreAccurate = new Vector();
        databaseName = new String("");
        fileFormat = new String("");
        databaseComment = new String("");
        exprList = new ExpressionList();
        meshes = new Vector();
        subsets = new Vector();
        scalars = new Vector();
        vectors = new Vector();
        tensors = new Vector();
        symmTensors = new Vector();
        arrays = new Vector();
        materials = new Vector();
        species = new Vector();
        curves = new Vector();
        labels = new Vector();
        defaultPlots = new Vector();
        isSimulation = false;
        simInfo = new avtSimulationInformation();
        suggestedDefaultSILRestriction = new Vector();
        replacementMask = -65;
    }

    public avtDatabaseMetaData(int nMoreFields)
    {
        super(avtDatabaseMetaData_numAdditionalAtts + nMoreFields);

        hasTemporalExtents = false;
        minTemporalExtents = 0;
        maxTemporalExtents = 0;
        numStates = 0;
        isVirtualDatabase = false;
        mustRepopulateOnStateChange = false;
        mustAlphabetizeVariables = true;
        formatCanDoDomainDecomposition = false;
        formatCanDoMultires = false;
        useCatchAllMesh = false;
        timeStepPath = new String("");
        timeStepNames = new Vector();
        cycles = new Vector();
        cyclesAreAccurate = new Vector();
        times = new Vector();
        timesAreAccurate = new Vector();
        databaseName = new String("");
        fileFormat = new String("");
        databaseComment = new String("");
        exprList = new ExpressionList();
        meshes = new Vector();
        subsets = new Vector();
        scalars = new Vector();
        vectors = new Vector();
        tensors = new Vector();
        symmTensors = new Vector();
        arrays = new Vector();
        materials = new Vector();
        species = new Vector();
        curves = new Vector();
        labels = new Vector();
        defaultPlots = new Vector();
        isSimulation = false;
        simInfo = new avtSimulationInformation();
        suggestedDefaultSILRestriction = new Vector();
        replacementMask = -65;
    }

    public avtDatabaseMetaData(avtDatabaseMetaData obj)
    {
        super(obj);

        int i;

        hasTemporalExtents = obj.hasTemporalExtents;
        minTemporalExtents = obj.minTemporalExtents;
        maxTemporalExtents = obj.maxTemporalExtents;
        numStates = obj.numStates;
        isVirtualDatabase = obj.isVirtualDatabase;
        mustRepopulateOnStateChange = obj.mustRepopulateOnStateChange;
        mustAlphabetizeVariables = obj.mustAlphabetizeVariables;
        formatCanDoDomainDecomposition = obj.formatCanDoDomainDecomposition;
        formatCanDoMultires = obj.formatCanDoMultires;
        useCatchAllMesh = obj.useCatchAllMesh;
        timeStepPath = new String(obj.timeStepPath);
        timeStepNames = new Vector(obj.timeStepNames.size());
        for(i = 0; i < obj.timeStepNames.size(); ++i)
            timeStepNames.addElement(new String((String)obj.timeStepNames.elementAt(i)));

        cycles = new Vector();
        for(i = 0; i < obj.cycles.size(); ++i)
        {
            Integer iv = (Integer)obj.cycles.elementAt(i);
            cycles.addElement(new Integer(iv.intValue()));
        }
        cyclesAreAccurate = new Vector();
        for(i = 0; i < obj.cyclesAreAccurate.size(); ++i)
        {
            Integer iv = (Integer)obj.cyclesAreAccurate.elementAt(i);
            cyclesAreAccurate.addElement(new Integer(iv.intValue()));
        }
        times = new Vector(obj.times.size());
        for(i = 0; i < obj.times.size(); ++i)
        {
            Double dv = (Double)obj.times.elementAt(i);
            times.addElement(new Double(dv.doubleValue()));
        }

        timesAreAccurate = new Vector();
        for(i = 0; i < obj.timesAreAccurate.size(); ++i)
        {
            Integer iv = (Integer)obj.timesAreAccurate.elementAt(i);
            timesAreAccurate.addElement(new Integer(iv.intValue()));
        }
        databaseName = new String(obj.databaseName);
        fileFormat = new String(obj.fileFormat);
        databaseComment = new String(obj.databaseComment);
        exprList = new ExpressionList(obj.exprList);
        // *** Copy the meshes field ***
        meshes = new Vector(obj.meshes.size());
        for(i = 0; i < obj.meshes.size(); ++i)
        {
            avtMeshMetaData oldObj = (avtMeshMetaData)obj.meshes.elementAt(i);
            meshes.addElement(new avtMeshMetaData(oldObj));
        }

        // *** Copy the subsets field ***
        subsets = new Vector(obj.subsets.size());
        for(i = 0; i < obj.subsets.size(); ++i)
        {
            avtSubsetsMetaData oldObj = (avtSubsetsMetaData)obj.subsets.elementAt(i);
            subsets.addElement(new avtSubsetsMetaData(oldObj));
        }

        // *** Copy the scalars field ***
        scalars = new Vector(obj.scalars.size());
        for(i = 0; i < obj.scalars.size(); ++i)
        {
            avtScalarMetaData oldObj = (avtScalarMetaData)obj.scalars.elementAt(i);
            scalars.addElement(new avtScalarMetaData(oldObj));
        }

        // *** Copy the vectors field ***
        vectors = new Vector(obj.vectors.size());
        for(i = 0; i < obj.vectors.size(); ++i)
        {
            avtVectorMetaData oldObj = (avtVectorMetaData)obj.vectors.elementAt(i);
            vectors.addElement(new avtVectorMetaData(oldObj));
        }

        // *** Copy the tensors field ***
        tensors = new Vector(obj.tensors.size());
        for(i = 0; i < obj.tensors.size(); ++i)
        {
            avtTensorMetaData oldObj = (avtTensorMetaData)obj.tensors.elementAt(i);
            tensors.addElement(new avtTensorMetaData(oldObj));
        }

        // *** Copy the symmTensors field ***
        symmTensors = new Vector(obj.symmTensors.size());
        for(i = 0; i < obj.symmTensors.size(); ++i)
        {
            avtSymmetricTensorMetaData oldObj = (avtSymmetricTensorMetaData)obj.symmTensors.elementAt(i);
            symmTensors.addElement(new avtSymmetricTensorMetaData(oldObj));
        }

        // *** Copy the arrays field ***
        arrays = new Vector(obj.arrays.size());
        for(i = 0; i < obj.arrays.size(); ++i)
        {
            avtArrayMetaData oldObj = (avtArrayMetaData)obj.arrays.elementAt(i);
            arrays.addElement(new avtArrayMetaData(oldObj));
        }

        // *** Copy the materials field ***
        materials = new Vector(obj.materials.size());
        for(i = 0; i < obj.materials.size(); ++i)
        {
            avtMaterialMetaData oldObj = (avtMaterialMetaData)obj.materials.elementAt(i);
            materials.addElement(new avtMaterialMetaData(oldObj));
        }

        // *** Copy the species field ***
        species = new Vector(obj.species.size());
        for(i = 0; i < obj.species.size(); ++i)
        {
            avtSpeciesMetaData oldObj = (avtSpeciesMetaData)obj.species.elementAt(i);
            species.addElement(new avtSpeciesMetaData(oldObj));
        }

        // *** Copy the curves field ***
        curves = new Vector(obj.curves.size());
        for(i = 0; i < obj.curves.size(); ++i)
        {
            avtCurveMetaData oldObj = (avtCurveMetaData)obj.curves.elementAt(i);
            curves.addElement(new avtCurveMetaData(oldObj));
        }

        // *** Copy the labels field ***
        labels = new Vector(obj.labels.size());
        for(i = 0; i < obj.labels.size(); ++i)
        {
            avtLabelMetaData oldObj = (avtLabelMetaData)obj.labels.elementAt(i);
            labels.addElement(new avtLabelMetaData(oldObj));
        }

        // *** Copy the defaultPlots field ***
        defaultPlots = new Vector(obj.defaultPlots.size());
        for(i = 0; i < obj.defaultPlots.size(); ++i)
        {
            avtDefaultPlotMetaData oldObj = (avtDefaultPlotMetaData)obj.defaultPlots.elementAt(i);
            defaultPlots.addElement(new avtDefaultPlotMetaData(oldObj));
        }

        isSimulation = obj.isSimulation;
        simInfo = new avtSimulationInformation(obj.simInfo);
        suggestedDefaultSILRestriction = new Vector(obj.suggestedDefaultSILRestriction.size());
        for(i = 0; i < obj.suggestedDefaultSILRestriction.size(); ++i)
            suggestedDefaultSILRestriction.addElement(new String((String)obj.suggestedDefaultSILRestriction.elementAt(i)));

        replacementMask = obj.replacementMask;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return avtDatabaseMetaData_numAdditionalAtts;
    }

    public boolean equals(avtDatabaseMetaData obj)
    {
        int i;

        // Compare the elements in the timeStepNames vector.
        boolean timeStepNames_equal = (obj.timeStepNames.size() == timeStepNames.size());
        for(i = 0; (i < timeStepNames.size()) && timeStepNames_equal; ++i)
        {
            // Make references to String from Object.
            String timeStepNames1 = (String)timeStepNames.elementAt(i);
            String timeStepNames2 = (String)obj.timeStepNames.elementAt(i);
            timeStepNames_equal = timeStepNames1.equals(timeStepNames2);
        }
        // Compare the elements in the cycles vector.
        boolean cycles_equal = (obj.cycles.size() == cycles.size());
        for(i = 0; (i < cycles.size()) && cycles_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer cycles1 = (Integer)cycles.elementAt(i);
            Integer cycles2 = (Integer)obj.cycles.elementAt(i);
            cycles_equal = cycles1.equals(cycles2);
        }
        // Compare the elements in the cyclesAreAccurate vector.
        boolean cyclesAreAccurate_equal = (obj.cyclesAreAccurate.size() == cyclesAreAccurate.size());
        for(i = 0; (i < cyclesAreAccurate.size()) && cyclesAreAccurate_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer cyclesAreAccurate1 = (Integer)cyclesAreAccurate.elementAt(i);
            Integer cyclesAreAccurate2 = (Integer)obj.cyclesAreAccurate.elementAt(i);
            cyclesAreAccurate_equal = cyclesAreAccurate1.equals(cyclesAreAccurate2);
        }
        // Compare the elements in the times vector.
        boolean times_equal = (obj.times.size() == times.size());
        for(i = 0; (i < times.size()) && times_equal; ++i)
        {
            // Make references to Double from Object.
            Double times1 = (Double)times.elementAt(i);
            Double times2 = (Double)obj.times.elementAt(i);
            times_equal = times1.equals(times2);
        }
        // Compare the elements in the timesAreAccurate vector.
        boolean timesAreAccurate_equal = (obj.timesAreAccurate.size() == timesAreAccurate.size());
        for(i = 0; (i < timesAreAccurate.size()) && timesAreAccurate_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer timesAreAccurate1 = (Integer)timesAreAccurate.elementAt(i);
            Integer timesAreAccurate2 = (Integer)obj.timesAreAccurate.elementAt(i);
            timesAreAccurate_equal = timesAreAccurate1.equals(timesAreAccurate2);
        }
        // Compare the elements in the meshes vector.
        boolean meshes_equal = (obj.meshes.size() == meshes.size());
        for(i = 0; (i < meshes.size()) && meshes_equal; ++i)
        {
            // Make references to avtMeshMetaData from Object.
            avtMeshMetaData meshes1 = (avtMeshMetaData)meshes.elementAt(i);
            avtMeshMetaData meshes2 = (avtMeshMetaData)obj.meshes.elementAt(i);
            meshes_equal = meshes1.equals(meshes2);
        }
        // Compare the elements in the subsets vector.
        boolean subsets_equal = (obj.subsets.size() == subsets.size());
        for(i = 0; (i < subsets.size()) && subsets_equal; ++i)
        {
            // Make references to avtSubsetsMetaData from Object.
            avtSubsetsMetaData subsets1 = (avtSubsetsMetaData)subsets.elementAt(i);
            avtSubsetsMetaData subsets2 = (avtSubsetsMetaData)obj.subsets.elementAt(i);
            subsets_equal = subsets1.equals(subsets2);
        }
        // Compare the elements in the scalars vector.
        boolean scalars_equal = (obj.scalars.size() == scalars.size());
        for(i = 0; (i < scalars.size()) && scalars_equal; ++i)
        {
            // Make references to avtScalarMetaData from Object.
            avtScalarMetaData scalars1 = (avtScalarMetaData)scalars.elementAt(i);
            avtScalarMetaData scalars2 = (avtScalarMetaData)obj.scalars.elementAt(i);
            scalars_equal = scalars1.equals(scalars2);
        }
        // Compare the elements in the vectors vector.
        boolean vectors_equal = (obj.vectors.size() == vectors.size());
        for(i = 0; (i < vectors.size()) && vectors_equal; ++i)
        {
            // Make references to avtVectorMetaData from Object.
            avtVectorMetaData vectors1 = (avtVectorMetaData)vectors.elementAt(i);
            avtVectorMetaData vectors2 = (avtVectorMetaData)obj.vectors.elementAt(i);
            vectors_equal = vectors1.equals(vectors2);
        }
        // Compare the elements in the tensors vector.
        boolean tensors_equal = (obj.tensors.size() == tensors.size());
        for(i = 0; (i < tensors.size()) && tensors_equal; ++i)
        {
            // Make references to avtTensorMetaData from Object.
            avtTensorMetaData tensors1 = (avtTensorMetaData)tensors.elementAt(i);
            avtTensorMetaData tensors2 = (avtTensorMetaData)obj.tensors.elementAt(i);
            tensors_equal = tensors1.equals(tensors2);
        }
        // Compare the elements in the symmTensors vector.
        boolean symmTensors_equal = (obj.symmTensors.size() == symmTensors.size());
        for(i = 0; (i < symmTensors.size()) && symmTensors_equal; ++i)
        {
            // Make references to avtSymmetricTensorMetaData from Object.
            avtSymmetricTensorMetaData symmTensors1 = (avtSymmetricTensorMetaData)symmTensors.elementAt(i);
            avtSymmetricTensorMetaData symmTensors2 = (avtSymmetricTensorMetaData)obj.symmTensors.elementAt(i);
            symmTensors_equal = symmTensors1.equals(symmTensors2);
        }
        // Compare the elements in the arrays vector.
        boolean arrays_equal = (obj.arrays.size() == arrays.size());
        for(i = 0; (i < arrays.size()) && arrays_equal; ++i)
        {
            // Make references to avtArrayMetaData from Object.
            avtArrayMetaData arrays1 = (avtArrayMetaData)arrays.elementAt(i);
            avtArrayMetaData arrays2 = (avtArrayMetaData)obj.arrays.elementAt(i);
            arrays_equal = arrays1.equals(arrays2);
        }
        // Compare the elements in the materials vector.
        boolean materials_equal = (obj.materials.size() == materials.size());
        for(i = 0; (i < materials.size()) && materials_equal; ++i)
        {
            // Make references to avtMaterialMetaData from Object.
            avtMaterialMetaData materials1 = (avtMaterialMetaData)materials.elementAt(i);
            avtMaterialMetaData materials2 = (avtMaterialMetaData)obj.materials.elementAt(i);
            materials_equal = materials1.equals(materials2);
        }
        // Compare the elements in the species vector.
        boolean species_equal = (obj.species.size() == species.size());
        for(i = 0; (i < species.size()) && species_equal; ++i)
        {
            // Make references to avtSpeciesMetaData from Object.
            avtSpeciesMetaData species1 = (avtSpeciesMetaData)species.elementAt(i);
            avtSpeciesMetaData species2 = (avtSpeciesMetaData)obj.species.elementAt(i);
            species_equal = species1.equals(species2);
        }
        // Compare the elements in the curves vector.
        boolean curves_equal = (obj.curves.size() == curves.size());
        for(i = 0; (i < curves.size()) && curves_equal; ++i)
        {
            // Make references to avtCurveMetaData from Object.
            avtCurveMetaData curves1 = (avtCurveMetaData)curves.elementAt(i);
            avtCurveMetaData curves2 = (avtCurveMetaData)obj.curves.elementAt(i);
            curves_equal = curves1.equals(curves2);
        }
        // Compare the elements in the labels vector.
        boolean labels_equal = (obj.labels.size() == labels.size());
        for(i = 0; (i < labels.size()) && labels_equal; ++i)
        {
            // Make references to avtLabelMetaData from Object.
            avtLabelMetaData labels1 = (avtLabelMetaData)labels.elementAt(i);
            avtLabelMetaData labels2 = (avtLabelMetaData)obj.labels.elementAt(i);
            labels_equal = labels1.equals(labels2);
        }
        // Compare the elements in the defaultPlots vector.
        boolean defaultPlots_equal = (obj.defaultPlots.size() == defaultPlots.size());
        for(i = 0; (i < defaultPlots.size()) && defaultPlots_equal; ++i)
        {
            // Make references to avtDefaultPlotMetaData from Object.
            avtDefaultPlotMetaData defaultPlots1 = (avtDefaultPlotMetaData)defaultPlots.elementAt(i);
            avtDefaultPlotMetaData defaultPlots2 = (avtDefaultPlotMetaData)obj.defaultPlots.elementAt(i);
            defaultPlots_equal = defaultPlots1.equals(defaultPlots2);
        }
        // Compare the elements in the suggestedDefaultSILRestriction vector.
        boolean suggestedDefaultSILRestriction_equal = (obj.suggestedDefaultSILRestriction.size() == suggestedDefaultSILRestriction.size());
        for(i = 0; (i < suggestedDefaultSILRestriction.size()) && suggestedDefaultSILRestriction_equal; ++i)
        {
            // Make references to String from Object.
            String suggestedDefaultSILRestriction1 = (String)suggestedDefaultSILRestriction.elementAt(i);
            String suggestedDefaultSILRestriction2 = (String)obj.suggestedDefaultSILRestriction.elementAt(i);
            suggestedDefaultSILRestriction_equal = suggestedDefaultSILRestriction1.equals(suggestedDefaultSILRestriction2);
        }
        // Create the return value
        return ((hasTemporalExtents == obj.hasTemporalExtents) &&
                (minTemporalExtents == obj.minTemporalExtents) &&
                (maxTemporalExtents == obj.maxTemporalExtents) &&
                (numStates == obj.numStates) &&
                (isVirtualDatabase == obj.isVirtualDatabase) &&
                (mustRepopulateOnStateChange == obj.mustRepopulateOnStateChange) &&
                (mustAlphabetizeVariables == obj.mustAlphabetizeVariables) &&
                (formatCanDoDomainDecomposition == obj.formatCanDoDomainDecomposition) &&
                (formatCanDoMultires == obj.formatCanDoMultires) &&
                (useCatchAllMesh == obj.useCatchAllMesh) &&
                (timeStepPath.equals(obj.timeStepPath)) &&
                timeStepNames_equal &&
                cycles_equal &&
                cyclesAreAccurate_equal &&
                times_equal &&
                timesAreAccurate_equal &&
                (databaseName.equals(obj.databaseName)) &&
                (fileFormat.equals(obj.fileFormat)) &&
                (databaseComment.equals(obj.databaseComment)) &&
                (exprList.equals(obj.exprList)) &&
                meshes_equal &&
                subsets_equal &&
                scalars_equal &&
                vectors_equal &&
                tensors_equal &&
                symmTensors_equal &&
                arrays_equal &&
                materials_equal &&
                species_equal &&
                curves_equal &&
                labels_equal &&
                defaultPlots_equal &&
                (isSimulation == obj.isSimulation) &&
                (simInfo.equals(obj.simInfo)) &&
                suggestedDefaultSILRestriction_equal &&
                (replacementMask == obj.replacementMask));
    }

    // Property setting methods
    public void SetHasTemporalExtents(boolean hasTemporalExtents_)
    {
        hasTemporalExtents = hasTemporalExtents_;
        Select(0);
    }

    public void SetMinTemporalExtents(double minTemporalExtents_)
    {
        minTemporalExtents = minTemporalExtents_;
        Select(1);
    }

    public void SetMaxTemporalExtents(double maxTemporalExtents_)
    {
        maxTemporalExtents = maxTemporalExtents_;
        Select(2);
    }

    public void SetNumStates(int numStates_)
    {
        numStates = numStates_;
        Select(3);
    }

    public void SetIsVirtualDatabase(boolean isVirtualDatabase_)
    {
        isVirtualDatabase = isVirtualDatabase_;
        Select(4);
    }

    public void SetMustRepopulateOnStateChange(boolean mustRepopulateOnStateChange_)
    {
        mustRepopulateOnStateChange = mustRepopulateOnStateChange_;
        Select(5);
    }

    public void SetMustAlphabetizeVariables(boolean mustAlphabetizeVariables_)
    {
        mustAlphabetizeVariables = mustAlphabetizeVariables_;
        Select(6);
    }

    public void SetFormatCanDoDomainDecomposition(boolean formatCanDoDomainDecomposition_)
    {
        formatCanDoDomainDecomposition = formatCanDoDomainDecomposition_;
        Select(7);
    }

    public void SetFormatCanDoMultires(boolean formatCanDoMultires_)
    {
        formatCanDoMultires = formatCanDoMultires_;
        Select(8);
    }

    public void SetUseCatchAllMesh(boolean useCatchAllMesh_)
    {
        useCatchAllMesh = useCatchAllMesh_;
        Select(9);
    }

    public void SetTimeStepPath(String timeStepPath_)
    {
        timeStepPath = timeStepPath_;
        Select(10);
    }

    public void SetTimeStepNames(Vector timeStepNames_)
    {
        timeStepNames = timeStepNames_;
        Select(11);
    }

    public void SetCycles(Vector cycles_)
    {
        cycles = cycles_;
        Select(12);
    }

    public void SetCyclesAreAccurate(Vector cyclesAreAccurate_)
    {
        cyclesAreAccurate = cyclesAreAccurate_;
        Select(13);
    }

    public void SetTimes(Vector times_)
    {
        times = times_;
        Select(14);
    }

    public void SetTimesAreAccurate(Vector timesAreAccurate_)
    {
        timesAreAccurate = timesAreAccurate_;
        Select(15);
    }

    public void SetDatabaseName(String databaseName_)
    {
        databaseName = databaseName_;
        Select(16);
    }

    public void SetFileFormat(String fileFormat_)
    {
        fileFormat = fileFormat_;
        Select(17);
    }

    public void SetDatabaseComment(String databaseComment_)
    {
        databaseComment = databaseComment_;
        Select(18);
    }

    public void SetExprList(ExpressionList exprList_)
    {
        exprList = exprList_;
        Select(19);
    }

    public void SetIsSimulation(boolean isSimulation_)
    {
        isSimulation = isSimulation_;
        Select(32);
    }

    public void SetSimInfo(avtSimulationInformation simInfo_)
    {
        simInfo = simInfo_;
        Select(33);
    }

    public void SetSuggestedDefaultSILRestriction(Vector suggestedDefaultSILRestriction_)
    {
        suggestedDefaultSILRestriction = suggestedDefaultSILRestriction_;
        Select(34);
    }

    public void SetReplacementMask(int replacementMask_)
    {
        replacementMask = replacementMask_;
        Select(35);
    }

    // Property getting methods
    public boolean                  GetHasTemporalExtents() { return hasTemporalExtents; }
    public double                   GetMinTemporalExtents() { return minTemporalExtents; }
    public double                   GetMaxTemporalExtents() { return maxTemporalExtents; }
    public int                      GetNumStates() { return numStates; }
    public boolean                  GetIsVirtualDatabase() { return isVirtualDatabase; }
    public boolean                  GetMustRepopulateOnStateChange() { return mustRepopulateOnStateChange; }
    public boolean                  GetMustAlphabetizeVariables() { return mustAlphabetizeVariables; }
    public boolean                  GetFormatCanDoDomainDecomposition() { return formatCanDoDomainDecomposition; }
    public boolean                  GetFormatCanDoMultires() { return formatCanDoMultires; }
    public boolean                  GetUseCatchAllMesh() { return useCatchAllMesh; }
    public String                   GetTimeStepPath() { return timeStepPath; }
    public Vector                   GetTimeStepNames() { return timeStepNames; }
    public Vector                   GetCycles() { return cycles; }
    public Vector                   GetCyclesAreAccurate() { return cyclesAreAccurate; }
    public Vector                   GetTimes() { return times; }
    public Vector                   GetTimesAreAccurate() { return timesAreAccurate; }
    public String                   GetDatabaseName() { return databaseName; }
    public String                   GetFileFormat() { return fileFormat; }
    public String                   GetDatabaseComment() { return databaseComment; }
    public ExpressionList           GetExprList() { return exprList; }
    public Vector                   GetMeshes() { return meshes; }
    public Vector                   GetSubsets() { return subsets; }
    public Vector                   GetScalars() { return scalars; }
    public Vector                   GetVectors() { return vectors; }
    public Vector                   GetTensors() { return tensors; }
    public Vector                   GetSymmTensors() { return symmTensors; }
    public Vector                   GetArrays() { return arrays; }
    public Vector                   GetMaterials() { return materials; }
    public Vector                   GetSpecies() { return species; }
    public Vector                   GetCurves() { return curves; }
    public Vector                   GetLabels() { return labels; }
    public Vector                   GetDefaultPlots() { return defaultPlots; }
    public boolean                  GetIsSimulation() { return isSimulation; }
    public avtSimulationInformation GetSimInfo() { return simInfo; }
    public Vector                   GetSuggestedDefaultSILRestriction() { return suggestedDefaultSILRestriction; }
    public int                      GetReplacementMask() { return replacementMask; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(hasTemporalExtents);
        if(WriteSelect(1, buf))
            buf.WriteDouble(minTemporalExtents);
        if(WriteSelect(2, buf))
            buf.WriteDouble(maxTemporalExtents);
        if(WriteSelect(3, buf))
            buf.WriteInt(numStates);
        if(WriteSelect(4, buf))
            buf.WriteBool(isVirtualDatabase);
        if(WriteSelect(5, buf))
            buf.WriteBool(mustRepopulateOnStateChange);
        if(WriteSelect(6, buf))
            buf.WriteBool(mustAlphabetizeVariables);
        if(WriteSelect(7, buf))
            buf.WriteBool(formatCanDoDomainDecomposition);
        if(WriteSelect(8, buf))
            buf.WriteBool(formatCanDoMultires);
        if(WriteSelect(9, buf))
            buf.WriteBool(useCatchAllMesh);
        if(WriteSelect(10, buf))
            buf.WriteString(timeStepPath);
        if(WriteSelect(11, buf))
            buf.WriteStringVector(timeStepNames);
        if(WriteSelect(12, buf))
            buf.WriteIntVector(cycles);
        if(WriteSelect(13, buf))
            buf.WriteIntVector(cyclesAreAccurate);
        if(WriteSelect(14, buf))
            buf.WriteDoubleVector(times);
        if(WriteSelect(15, buf))
            buf.WriteIntVector(timesAreAccurate);
        if(WriteSelect(16, buf))
            buf.WriteString(databaseName);
        if(WriteSelect(17, buf))
            buf.WriteString(fileFormat);
        if(WriteSelect(18, buf))
            buf.WriteString(databaseComment);
        if(WriteSelect(19, buf))
            exprList.Write(buf);
        if(WriteSelect(20, buf))
        {
            buf.WriteInt(meshes.size());
            for(int i = 0; i < meshes.size(); ++i)
            {
                avtMeshMetaData tmp = (avtMeshMetaData)meshes.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(21, buf))
        {
            buf.WriteInt(subsets.size());
            for(int i = 0; i < subsets.size(); ++i)
            {
                avtSubsetsMetaData tmp = (avtSubsetsMetaData)subsets.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(22, buf))
        {
            buf.WriteInt(scalars.size());
            for(int i = 0; i < scalars.size(); ++i)
            {
                avtScalarMetaData tmp = (avtScalarMetaData)scalars.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(23, buf))
        {
            buf.WriteInt(vectors.size());
            for(int i = 0; i < vectors.size(); ++i)
            {
                avtVectorMetaData tmp = (avtVectorMetaData)vectors.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(24, buf))
        {
            buf.WriteInt(tensors.size());
            for(int i = 0; i < tensors.size(); ++i)
            {
                avtTensorMetaData tmp = (avtTensorMetaData)tensors.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(25, buf))
        {
            buf.WriteInt(symmTensors.size());
            for(int i = 0; i < symmTensors.size(); ++i)
            {
                avtSymmetricTensorMetaData tmp = (avtSymmetricTensorMetaData)symmTensors.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(26, buf))
        {
            buf.WriteInt(arrays.size());
            for(int i = 0; i < arrays.size(); ++i)
            {
                avtArrayMetaData tmp = (avtArrayMetaData)arrays.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(27, buf))
        {
            buf.WriteInt(materials.size());
            for(int i = 0; i < materials.size(); ++i)
            {
                avtMaterialMetaData tmp = (avtMaterialMetaData)materials.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(28, buf))
        {
            buf.WriteInt(species.size());
            for(int i = 0; i < species.size(); ++i)
            {
                avtSpeciesMetaData tmp = (avtSpeciesMetaData)species.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(29, buf))
        {
            buf.WriteInt(curves.size());
            for(int i = 0; i < curves.size(); ++i)
            {
                avtCurveMetaData tmp = (avtCurveMetaData)curves.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(30, buf))
        {
            buf.WriteInt(labels.size());
            for(int i = 0; i < labels.size(); ++i)
            {
                avtLabelMetaData tmp = (avtLabelMetaData)labels.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(31, buf))
        {
            buf.WriteInt(defaultPlots.size());
            for(int i = 0; i < defaultPlots.size(); ++i)
            {
                avtDefaultPlotMetaData tmp = (avtDefaultPlotMetaData)defaultPlots.elementAt(i);
                tmp.Write(buf);
            }
        }
        if(WriteSelect(32, buf))
            buf.WriteBool(isSimulation);
        if(WriteSelect(33, buf))
            simInfo.Write(buf);
        if(WriteSelect(34, buf))
            buf.WriteStringVector(suggestedDefaultSILRestriction);
        if(WriteSelect(35, buf))
            buf.WriteInt(replacementMask);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetHasTemporalExtents(buf.ReadBool());
            break;
        case 1:
            SetMinTemporalExtents(buf.ReadDouble());
            break;
        case 2:
            SetMaxTemporalExtents(buf.ReadDouble());
            break;
        case 3:
            SetNumStates(buf.ReadInt());
            break;
        case 4:
            SetIsVirtualDatabase(buf.ReadBool());
            break;
        case 5:
            SetMustRepopulateOnStateChange(buf.ReadBool());
            break;
        case 6:
            SetMustAlphabetizeVariables(buf.ReadBool());
            break;
        case 7:
            SetFormatCanDoDomainDecomposition(buf.ReadBool());
            break;
        case 8:
            SetFormatCanDoMultires(buf.ReadBool());
            break;
        case 9:
            SetUseCatchAllMesh(buf.ReadBool());
            break;
        case 10:
            SetTimeStepPath(buf.ReadString());
            break;
        case 11:
            SetTimeStepNames(buf.ReadStringVector());
            break;
        case 12:
            SetCycles(buf.ReadIntVector());
            break;
        case 13:
            SetCyclesAreAccurate(buf.ReadIntVector());
            break;
        case 14:
            SetTimes(buf.ReadDoubleVector());
            break;
        case 15:
            SetTimesAreAccurate(buf.ReadIntVector());
            break;
        case 16:
            SetDatabaseName(buf.ReadString());
            break;
        case 17:
            SetFileFormat(buf.ReadString());
            break;
        case 18:
            SetDatabaseComment(buf.ReadString());
            break;
        case 19:
            exprList.Read(buf);
            Select(19);
            break;
        case 20:
            {
                int len = buf.ReadInt();
                meshes.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtMeshMetaData tmp = new avtMeshMetaData();
                    tmp.Read(buf);
                    meshes.addElement(tmp);
                }
            }
            Select(20);
            break;
        case 21:
            {
                int len = buf.ReadInt();
                subsets.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtSubsetsMetaData tmp = new avtSubsetsMetaData();
                    tmp.Read(buf);
                    subsets.addElement(tmp);
                }
            }
            Select(21);
            break;
        case 22:
            {
                int len = buf.ReadInt();
                scalars.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtScalarMetaData tmp = new avtScalarMetaData();
                    tmp.Read(buf);
                    scalars.addElement(tmp);
                }
            }
            Select(22);
            break;
        case 23:
            {
                int len = buf.ReadInt();
                vectors.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtVectorMetaData tmp = new avtVectorMetaData();
                    tmp.Read(buf);
                    vectors.addElement(tmp);
                }
            }
            Select(23);
            break;
        case 24:
            {
                int len = buf.ReadInt();
                tensors.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtTensorMetaData tmp = new avtTensorMetaData();
                    tmp.Read(buf);
                    tensors.addElement(tmp);
                }
            }
            Select(24);
            break;
        case 25:
            {
                int len = buf.ReadInt();
                symmTensors.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtSymmetricTensorMetaData tmp = new avtSymmetricTensorMetaData();
                    tmp.Read(buf);
                    symmTensors.addElement(tmp);
                }
            }
            Select(25);
            break;
        case 26:
            {
                int len = buf.ReadInt();
                arrays.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtArrayMetaData tmp = new avtArrayMetaData();
                    tmp.Read(buf);
                    arrays.addElement(tmp);
                }
            }
            Select(26);
            break;
        case 27:
            {
                int len = buf.ReadInt();
                materials.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtMaterialMetaData tmp = new avtMaterialMetaData();
                    tmp.Read(buf);
                    materials.addElement(tmp);
                }
            }
            Select(27);
            break;
        case 28:
            {
                int len = buf.ReadInt();
                species.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtSpeciesMetaData tmp = new avtSpeciesMetaData();
                    tmp.Read(buf);
                    species.addElement(tmp);
                }
            }
            Select(28);
            break;
        case 29:
            {
                int len = buf.ReadInt();
                curves.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtCurveMetaData tmp = new avtCurveMetaData();
                    tmp.Read(buf);
                    curves.addElement(tmp);
                }
            }
            Select(29);
            break;
        case 30:
            {
                int len = buf.ReadInt();
                labels.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtLabelMetaData tmp = new avtLabelMetaData();
                    tmp.Read(buf);
                    labels.addElement(tmp);
                }
            }
            Select(30);
            break;
        case 31:
            {
                int len = buf.ReadInt();
                defaultPlots.clear();
                for(int j = 0; j < len; ++j)
                {
                    avtDefaultPlotMetaData tmp = new avtDefaultPlotMetaData();
                    tmp.Read(buf);
                    defaultPlots.addElement(tmp);
                }
            }
            Select(31);
            break;
        case 32:
            SetIsSimulation(buf.ReadBool());
            break;
        case 33:
            simInfo.Read(buf);
            Select(33);
            break;
        case 34:
            SetSuggestedDefaultSILRestriction(buf.ReadStringVector());
            break;
        case 35:
            SetReplacementMask(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("hasTemporalExtents", hasTemporalExtents, indent) + "\n";
        str = str + doubleToString("minTemporalExtents", minTemporalExtents, indent) + "\n";
        str = str + doubleToString("maxTemporalExtents", maxTemporalExtents, indent) + "\n";
        str = str + intToString("numStates", numStates, indent) + "\n";
        str = str + boolToString("isVirtualDatabase", isVirtualDatabase, indent) + "\n";
        str = str + boolToString("mustRepopulateOnStateChange", mustRepopulateOnStateChange, indent) + "\n";
        str = str + boolToString("mustAlphabetizeVariables", mustAlphabetizeVariables, indent) + "\n";
        str = str + boolToString("formatCanDoDomainDecomposition", formatCanDoDomainDecomposition, indent) + "\n";
        str = str + boolToString("formatCanDoMultires", formatCanDoMultires, indent) + "\n";
        str = str + boolToString("useCatchAllMesh", useCatchAllMesh, indent) + "\n";
        str = str + stringToString("timeStepPath", timeStepPath, indent) + "\n";
        str = str + stringVectorToString("timeStepNames", timeStepNames, indent) + "\n";
        str = str + intVectorToString("cycles", cycles, indent) + "\n";
        str = str + intVectorToString("cyclesAreAccurate", cyclesAreAccurate, indent) + "\n";
        str = str + doubleVectorToString("times", times, indent) + "\n";
        str = str + intVectorToString("timesAreAccurate", timesAreAccurate, indent) + "\n";
        str = str + stringToString("databaseName", databaseName, indent) + "\n";
        str = str + stringToString("fileFormat", fileFormat, indent) + "\n";
        str = str + stringToString("databaseComment", databaseComment, indent) + "\n";
        str = str + indent + "exprList = {\n" + exprList.toString(indent + "    ") + indent + "}\n";
        str = str + indent + "meshes = {\n";
        for(int i = 0; i < meshes.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)meshes.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < meshes.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "subsets = {\n";
        for(int i = 0; i < subsets.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)subsets.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < subsets.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "scalars = {\n";
        for(int i = 0; i < scalars.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)scalars.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < scalars.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "vectors = {\n";
        for(int i = 0; i < vectors.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)vectors.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < vectors.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "tensors = {\n";
        for(int i = 0; i < tensors.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)tensors.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < tensors.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "symmTensors = {\n";
        for(int i = 0; i < symmTensors.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)symmTensors.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < symmTensors.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "arrays = {\n";
        for(int i = 0; i < arrays.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)arrays.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < arrays.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "materials = {\n";
        for(int i = 0; i < materials.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)materials.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < materials.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "species = {\n";
        for(int i = 0; i < species.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)species.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < species.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "curves = {\n";
        for(int i = 0; i < curves.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)curves.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < curves.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "labels = {\n";
        for(int i = 0; i < labels.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)labels.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < labels.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + indent + "defaultPlots = {\n";
        for(int i = 0; i < defaultPlots.size(); ++i)
        {
            AttributeSubject s = (AttributeSubject)defaultPlots.elementAt(i);
            str = str + s.toString(indent + "    ");
            if(i < defaultPlots.size()-1)
                str = str + ", ";
            str = str + "\n";
        }
        str = str + "}\n";
        str = str + boolToString("isSimulation", isSimulation, indent) + "\n";
        str = str + indent + "simInfo = {\n" + simInfo.toString(indent + "    ") + indent + "}\n";
        str = str + stringVectorToString("suggestedDefaultSILRestriction", suggestedDefaultSILRestriction, indent) + "\n";
        str = str + intToString("replacementMask", replacementMask, indent) + "\n";
        return str;
    }

    // Attributegroup convenience methods
    public void AddMeshes(avtMeshMetaData obj)
    {
        meshes.addElement(new avtMeshMetaData(obj));
        Select(20);
    }

    public void ClearMeshes()
    {
        meshes.clear();
        Select(20);
    }

    public void RemoveMeshes(int index)
    {
        if(index >= 0 && index < meshes.size())
        {
            meshes.remove(index);
            Select(20);
        }
    }

    public int GetNumMeshes()
    {
        return meshes.size();
    }

    public avtMeshMetaData GetMeshes(int i)
    {
        avtMeshMetaData tmp = (avtMeshMetaData)meshes.elementAt(i);
        return tmp;
    }

    public void AddSubsets(avtSubsetsMetaData obj)
    {
        subsets.addElement(new avtSubsetsMetaData(obj));
        Select(21);
    }

    public void ClearSubsets()
    {
        subsets.clear();
        Select(21);
    }

    public void RemoveSubsets(int index)
    {
        if(index >= 0 && index < subsets.size())
        {
            subsets.remove(index);
            Select(21);
        }
    }

    public int GetNumSubsets()
    {
        return subsets.size();
    }

    public avtSubsetsMetaData GetSubsets(int i)
    {
        avtSubsetsMetaData tmp = (avtSubsetsMetaData)subsets.elementAt(i);
        return tmp;
    }

    public void AddScalars(avtScalarMetaData obj)
    {
        scalars.addElement(new avtScalarMetaData(obj));
        Select(22);
    }

    public void ClearScalars()
    {
        scalars.clear();
        Select(22);
    }

    public void RemoveScalars(int index)
    {
        if(index >= 0 && index < scalars.size())
        {
            scalars.remove(index);
            Select(22);
        }
    }

    public int GetNumScalars()
    {
        return scalars.size();
    }

    public avtScalarMetaData GetScalars(int i)
    {
        avtScalarMetaData tmp = (avtScalarMetaData)scalars.elementAt(i);
        return tmp;
    }

    public void AddVectors(avtVectorMetaData obj)
    {
        vectors.addElement(new avtVectorMetaData(obj));
        Select(23);
    }

    public void ClearVectors()
    {
        vectors.clear();
        Select(23);
    }

    public void RemoveVectors(int index)
    {
        if(index >= 0 && index < vectors.size())
        {
            vectors.remove(index);
            Select(23);
        }
    }

    public int GetNumVectors()
    {
        return vectors.size();
    }

    public avtVectorMetaData GetVectors(int i)
    {
        avtVectorMetaData tmp = (avtVectorMetaData)vectors.elementAt(i);
        return tmp;
    }

    public void AddTensors(avtTensorMetaData obj)
    {
        tensors.addElement(new avtTensorMetaData(obj));
        Select(24);
    }

    public void ClearTensors()
    {
        tensors.clear();
        Select(24);
    }

    public void RemoveTensors(int index)
    {
        if(index >= 0 && index < tensors.size())
        {
            tensors.remove(index);
            Select(24);
        }
    }

    public int GetNumTensors()
    {
        return tensors.size();
    }

    public avtTensorMetaData GetTensors(int i)
    {
        avtTensorMetaData tmp = (avtTensorMetaData)tensors.elementAt(i);
        return tmp;
    }

    public void AddSymmTensors(avtSymmetricTensorMetaData obj)
    {
        symmTensors.addElement(new avtSymmetricTensorMetaData(obj));
        Select(25);
    }

    public void ClearSymmTensors()
    {
        symmTensors.clear();
        Select(25);
    }

    public void RemoveSymmTensors(int index)
    {
        if(index >= 0 && index < symmTensors.size())
        {
            symmTensors.remove(index);
            Select(25);
        }
    }

    public int GetNumSymmTensors()
    {
        return symmTensors.size();
    }

    public avtSymmetricTensorMetaData GetSymmTensors(int i)
    {
        avtSymmetricTensorMetaData tmp = (avtSymmetricTensorMetaData)symmTensors.elementAt(i);
        return tmp;
    }

    public void AddArrays(avtArrayMetaData obj)
    {
        arrays.addElement(new avtArrayMetaData(obj));
        Select(26);
    }

    public void ClearArrays()
    {
        arrays.clear();
        Select(26);
    }

    public void RemoveArrays(int index)
    {
        if(index >= 0 && index < arrays.size())
        {
            arrays.remove(index);
            Select(26);
        }
    }

    public int GetNumArrays()
    {
        return arrays.size();
    }

    public avtArrayMetaData GetArrays(int i)
    {
        avtArrayMetaData tmp = (avtArrayMetaData)arrays.elementAt(i);
        return tmp;
    }

    public void AddMaterials(avtMaterialMetaData obj)
    {
        materials.addElement(new avtMaterialMetaData(obj));
        Select(27);
    }

    public void ClearMaterials()
    {
        materials.clear();
        Select(27);
    }

    public void RemoveMaterials(int index)
    {
        if(index >= 0 && index < materials.size())
        {
            materials.remove(index);
            Select(27);
        }
    }

    public int GetNumMaterials()
    {
        return materials.size();
    }

    public avtMaterialMetaData GetMaterials(int i)
    {
        avtMaterialMetaData tmp = (avtMaterialMetaData)materials.elementAt(i);
        return tmp;
    }

    public void AddSpecies(avtSpeciesMetaData obj)
    {
        species.addElement(new avtSpeciesMetaData(obj));
        Select(28);
    }

    public void ClearSpecies()
    {
        species.clear();
        Select(28);
    }

    public void RemoveSpecies(int index)
    {
        if(index >= 0 && index < species.size())
        {
            species.remove(index);
            Select(28);
        }
    }

    public int GetNumSpecies()
    {
        return species.size();
    }

    public avtSpeciesMetaData GetSpecies(int i)
    {
        avtSpeciesMetaData tmp = (avtSpeciesMetaData)species.elementAt(i);
        return tmp;
    }

    public void AddCurves(avtCurveMetaData obj)
    {
        curves.addElement(new avtCurveMetaData(obj));
        Select(29);
    }

    public void ClearCurves()
    {
        curves.clear();
        Select(29);
    }

    public void RemoveCurves(int index)
    {
        if(index >= 0 && index < curves.size())
        {
            curves.remove(index);
            Select(29);
        }
    }

    public int GetNumCurves()
    {
        return curves.size();
    }

    public avtCurveMetaData GetCurves(int i)
    {
        avtCurveMetaData tmp = (avtCurveMetaData)curves.elementAt(i);
        return tmp;
    }

    public void AddLabels(avtLabelMetaData obj)
    {
        labels.addElement(new avtLabelMetaData(obj));
        Select(30);
    }

    public void ClearLabels()
    {
        labels.clear();
        Select(30);
    }

    public void RemoveLabels(int index)
    {
        if(index >= 0 && index < labels.size())
        {
            labels.remove(index);
            Select(30);
        }
    }

    public int GetNumLabels()
    {
        return labels.size();
    }

    public avtLabelMetaData GetLabels(int i)
    {
        avtLabelMetaData tmp = (avtLabelMetaData)labels.elementAt(i);
        return tmp;
    }

    public void AddDefaultPlots(avtDefaultPlotMetaData obj)
    {
        defaultPlots.addElement(new avtDefaultPlotMetaData(obj));
        Select(31);
    }

    public void ClearDefaultPlots()
    {
        defaultPlots.clear();
        Select(31);
    }

    public void RemoveDefaultPlots(int index)
    {
        if(index >= 0 && index < defaultPlots.size())
        {
            defaultPlots.remove(index);
            Select(31);
        }
    }

    public int GetNumDefaultPlots()
    {
        return defaultPlots.size();
    }

    public avtDefaultPlotMetaData GetDefaultPlots(int i)
    {
        avtDefaultPlotMetaData tmp = (avtDefaultPlotMetaData)defaultPlots.elementAt(i);
        return tmp;
    }


    // Attributes
    private boolean                  hasTemporalExtents;
    private double                   minTemporalExtents;
    private double                   maxTemporalExtents;
    private int                      numStates;
    private boolean                  isVirtualDatabase;
    private boolean                  mustRepopulateOnStateChange;
    private boolean                  mustAlphabetizeVariables;
    private boolean                  formatCanDoDomainDecomposition;
    private boolean                  formatCanDoMultires;
    private boolean                  useCatchAllMesh;
    private String                   timeStepPath;
    private Vector                   timeStepNames; // vector of String objects
    private Vector                   cycles; // vector of Integer objects
    private Vector                   cyclesAreAccurate; // vector of Integer objects
    private Vector                   times; // vector of Double objects
    private Vector                   timesAreAccurate; // vector of Integer objects
    private String                   databaseName;
    private String                   fileFormat;
    private String                   databaseComment;
    private ExpressionList           exprList;
    private Vector                   meshes; // vector of avtMeshMetaData objects
    private Vector                   subsets; // vector of avtSubsetsMetaData objects
    private Vector                   scalars; // vector of avtScalarMetaData objects
    private Vector                   vectors; // vector of avtVectorMetaData objects
    private Vector                   tensors; // vector of avtTensorMetaData objects
    private Vector                   symmTensors; // vector of avtSymmetricTensorMetaData objects
    private Vector                   arrays; // vector of avtArrayMetaData objects
    private Vector                   materials; // vector of avtMaterialMetaData objects
    private Vector                   species; // vector of avtSpeciesMetaData objects
    private Vector                   curves; // vector of avtCurveMetaData objects
    private Vector                   labels; // vector of avtLabelMetaData objects
    private Vector                   defaultPlots; // vector of avtDefaultPlotMetaData objects
    private boolean                  isSimulation;
    private avtSimulationInformation simInfo;
    private Vector                   suggestedDefaultSILRestriction; // vector of String objects
    private int                      replacementMask;
}

