/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* All rights reserved.
*
* This file is part of VisIt. For details, see http://www.llnl.gov/visit/. The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or materials provided with the distribution.
*  - Neither the name of the UC/LLNL nor  the names of its contributors may be
*    used to  endorse or  promote products derived from  this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED.  IN  NO  EVENT  SHALL  THE  REGENTS  OF  THE  UNIVERSITY OF
* CALIFORNIA, THE U.S.  DEPARTMENT  OF  ENERGY OR CONTRIBUTORS BE  LIABLE  FOR
* ANY  DIRECT,  INDIRECT,  INCIDENTAL,  SPECIAL,  EXEMPLARY,  OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                              avtlataWriter.C                             //
// ************************************************************************* //

#include <avtlataWriter.h>

#include <vector>

#include <vtkDataSetWriter.h>
#include <vtkDataSet.h>
#include <vtkCellData.h>
#include <vtkPointData.h>

#include <avtDatabaseMetaData.h>

#include <vtkUnstructuredGrid.h>


using     std::string;
using     std::vector;


// ****************************************************************************
//  Method: avtlataWriter constructor
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************

avtlataWriter::avtlataWriter(void)
{
  md_=0;
  cout<<"ici constructeur" << __FILE__<<endl;
}

// ****************************************************************************
//  Method: avtlataWriter::OpenFile
//
//  Purpose:
//      Does no actual work.  Just records the stem name for the files.
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************


#include <DBPluginInfoAttributes.h>
#include <ViewerProxy.h>
void
avtlataWriter::OpenFile(const string &stemname)
{
    stem = stemname;
    cout<<"\n openfile  "<<__FILE__<<" "<<stem<<endl;
    /*
    DBPluginInfoAttributes *dbplugininfo =
      GetViewerState()->GetDBPluginInfoAttributes();
   
    const stringVector &types = dbplugininfo->GetTypes();
    for (int i = 0 ; i < types.size() ; i++)
    {
      cout<<types[i]<<endl;
    }
    */
}

void
avtlataWriter::OpenFile(const string &stemname, int nb)
{
  cout<<"\n "<<__FILE__<<"openfile  nb "<<nb<<endl;
  if (nb!=1) return; //exit(-1);
        OpenFile(stemname);
}
// ****************************************************************************
//  Method: avtlataWriter::WriteHeaders
//
//  Purpose:
//      Writes out a VisIt file to tie the lata files together.
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************

void
avtlataWriter::WriteHeaders(const avtDatabaseMetaData *md,
                            const vector<string> &scalars,
                            const vector<string> &vectors,
                            const vector<string> &materials)
{
  cout<<"\n headers "<<__FILE__<<" "<<__LINE__<<" "<<stem<<endl;
  // WRITE OUT HEADER INFO
  cout<<"la "<<scalars.size()<<" "<<vectors.size()<<" "<<materials.size()<<endl;
  for (int i=0;i<scalars.size();i++)
    cout <<scalars[i]<<endl;
  avtDataAttributes &atts = GetInput()->GetInfo().GetAttributes();
  cout<<atts.GetMeshname()<<endl;
  ftime = atts.GetTime();
  cout<<"time "<<ftime<<endl;
  // on devrait ecrire le fichier .lata ...
  cout<<" c'ext faux .. a coorig copie de avtSiloWriter -> faux aussi !!"<<endl;
  md_=md;
 
  // dimensionne filenames_var
  filenames_var=scalars;
  cout<<"ici tailles " <<filenames_var.size()<<" "<<scalars.size()<<endl;
}


// ****************************************************************************
//  Method: avtlataWriter::WriteChunk
//
//  Purpose:
//      This writes out one chunk of an avtDataset.
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************
void avtlataWriter::write_data(vtkDataArray *arr,const string& pos, string& filename)
{
  cout <<" avtlataWriter::write_data "<< filename<<" pos " << pos<<endl;
  cout <<"arr getname  " <<arr->GetName()<<endl;
  const  avtScalarMetaData* scalardata=      md_->GetScalar(arr->GetName()) ;
  const string& meshname=scalardata->meshName;
  cout <<"meshname  " <<meshname<<endl;
 int npts = arr->GetNumberOfTuples();
  int ncomps = arr->GetNumberOfComponents();
  if (ncomps == 1)
    {
      float* val=(float *) arr->GetVoidPointer(0);
      filename=stem;
      filename+=".";
      filename+=arr->GetName();
      //filename+=".ELEM.";
      filename+=pos;
      filename+=meshname+".";
      char tmp[1024];
      sprintf(tmp, "%f",ftime);
      filename+=tmp;
      cout<<npts<< " filename "<<filename<<endl;
      for (int pt=0;pt<npts*0+5;pt++) 
        cout<<pt<<" "<<val[pt]<<endl;
    }
  else 
    {
      cout<<" export multi var non cod "<<endl;
      EXCEPTION0(ImproperUseException);
    }
}
void
avtlataWriter::WriteChunk(vtkDataSet *ds, int chunk)
{
  /*  
  vtkUnstructuredGrid* ug;
  switch (ds->GetDataObjectType())
    {
    case VTK_UNSTRUCTURED_GRID:
      ug=(vtkUnstructuredGrid *) ds;
      cout<<ug->GetName()<<endl;
      cout<<ug->GetMeshName()<<endl;
      break;
    default:
      EXCEPTION0(ImproperUseException);
    }
  
  cout<<ds->GetName()<<endl;
  cout<<ds->GetMeshName()<<endl;
  */

   vtkPointData* pd=ds->GetPointData();
  vtkCellData* cd=ds->GetCellData();
  int cpt=0;
  for (int i = 0 ; i < cd->GetNumberOfArrays() ; i++)
    {
      vtkDataArray *arr = cd->GetArray(i);
      string filename;
      write_data(arr,string(".ELEM."),filename);
      filenames_var[cpt++]=filename;
    }
  for (int i = 0 ; i < pd->GetNumberOfArrays() ; i++)
    {
      vtkDataArray *arr = pd->GetArray(i);
      string filename;
      write_data(arr,string(".SOM."),filename);
      filenames_var[cpt++]=filename;
    }

  /*
 cout<<ds->GetNumberOfPoints()<<endl;
  cout<<ds->GetNumberOfCells()<<endl;
  vtkCellData* data=ds->GetCellData();
  cout<<data->GetNumberOfTuples()<<endl;
  vtkPointData* datas=ds->GetPointData();
  cout<<datas->GetNumberOfTuples()<<endl;
  int nval_elem=data->GetNumberOfTuples();
  int nval_som=datas->GetNumberOfTuples();
  vtkDataArray* datar=data->GetArray(0);
  for( int i=0;i<12;i++)
    cout<<"test "<<i<<" "<<(datar->GetTuple1(i))<<endl;
  cout<<" GF pas encore code" <<endl;
  // exit(-1);
  */
    // WRITE OUT THIS ONE CHUNK
}


// ****************************************************************************
//  Method: avtlataWriter::CloseFile
//
//  Purpose:
//      Closes the file.  This does nothing in this case.
//
//  Programmer: fauchet -- generated by xml2avt
//
// ****************************************************************************

void
avtlataWriter::CloseFile(void)
{
    // CLOSE FILES
  cout<<stem<< " a ferme "<<endl;
  cout<<"TIME "<<ftime<<endl;
  cout<<filenames_var.size()<<endl;
  for (int  i=0;i<filenames_var.size();i++)
    cout<<"file "<<filenames_var[i]<<endl;
}
