/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <VisualCueList.h>
#include <DataNode.h>
#include <VisualCueInfo.h>

// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Init utility for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void VisualCueList::Init()
{

    VisualCueList::SelectAll();
}

// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Copy utility for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void VisualCueList::Copy(const VisualCueList &obj)
{
    AttributeGroupVector::const_iterator pos;

    // *** Copy the cues field ***
    // Delete the AttributeGroup objects and clear the vector.
    for(pos = cues.begin(); pos != cues.end(); ++pos)
        delete *pos;
    cues.clear();
    if(obj.cues.size() > 0)
        cues.reserve(obj.cues.size());
    // Duplicate the cues from obj.
    for(pos = obj.cues.begin(); pos != obj.cues.end(); ++pos)
    {
        VisualCueInfo *oldVisualCueInfo = (VisualCueInfo *)(*pos);
        VisualCueInfo *newVisualCueInfo = new VisualCueInfo(*oldVisualCueInfo);
        cues.push_back(newVisualCueInfo);
    }


    VisualCueList::SelectAll();
}

// Type map format string
const char *VisualCueList::TypeMapFormatString = VISUALCUELIST_TMFS;
const AttributeGroup::private_tmfs_t VisualCueList::TmfsStruct = {VISUALCUELIST_TMFS};


// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Default constructor for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList::VisualCueList() : 
    AttributeSubject(VisualCueList::TypeMapFormatString)
{
    VisualCueList::Init();
}

// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Constructor for the derived classes of VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList::VisualCueList(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    VisualCueList::Init();
}

// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Copy constructor for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList::VisualCueList(const VisualCueList &obj) : 
    AttributeSubject(VisualCueList::TypeMapFormatString)
{
    VisualCueList::Copy(obj);
}

// ****************************************************************************
// Method: VisualCueList::VisualCueList
//
// Purpose: 
//   Copy constructor for derived classes of the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList::VisualCueList(const VisualCueList &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    VisualCueList::Copy(obj);
}

// ****************************************************************************
// Method: VisualCueList::~VisualCueList
//
// Purpose: 
//   Destructor for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList::~VisualCueList()
{
    AttributeGroupVector::iterator pos;

    // Destroy the cues field.
    for(pos = cues.begin(); pos != cues.end(); ++pos)
        delete *pos;
}

// ****************************************************************************
// Method: VisualCueList::operator = 
//
// Purpose: 
//   Assignment operator for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueList& 
VisualCueList::operator = (const VisualCueList &obj)
{
    if (this == &obj) return *this;

    VisualCueList::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: VisualCueList::operator == 
//
// Purpose: 
//   Comparison operator == for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueList::operator == (const VisualCueList &obj) const
{
    bool cues_equal = (obj.cues.size() == cues.size());
    for(size_t i = 0; (i < cues.size()) && cues_equal; ++i)
    {
        // Make references to VisualCueInfo from AttributeGroup *.
        const VisualCueInfo &cues1 = *((const VisualCueInfo *)(cues[i]));
        const VisualCueInfo &cues2 = *((const VisualCueInfo *)(obj.cues[i]));
        cues_equal = (cues1 == cues2);
    }

    // Create the return value
    return (cues_equal);
}

// ****************************************************************************
// Method: VisualCueList::operator != 
//
// Purpose: 
//   Comparison operator != for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueList::operator != (const VisualCueList &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: VisualCueList::TypeName
//
// Purpose: 
//   Type name method for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
VisualCueList::TypeName() const
{
    return "VisualCueList";
}

// ****************************************************************************
// Method: VisualCueList::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueList::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const VisualCueList *tmp = (const VisualCueList *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: VisualCueList::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VisualCueList::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new VisualCueList(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: VisualCueList::NewInstance
//
// Purpose: 
//   NewInstance method for the VisualCueList class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
VisualCueList::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new VisualCueList(*this);
    else
        retval = new VisualCueList;

    return retval;
}

// ****************************************************************************
// Method: VisualCueList::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueList::SelectAll()
{
    Select(ID_cues, (void *)&cues);
}

// ****************************************************************************
// Method: VisualCueList::CreateSubAttributeGroup
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup *
VisualCueList::CreateSubAttributeGroup(int)
{
    return new VisualCueInfo;
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const AttributeGroupVector &
VisualCueList::GetCues() const
{
    return cues;
}

AttributeGroupVector &
VisualCueList::GetCues()
{
    return cues;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
VisualCueList::SelectCues()
{
    Select(ID_cues, (void *)&cues);
}

///////////////////////////////////////////////////////////////////////////////
// AttributeGroupVector convenience methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VisualCueList::AddCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueList::AddCues(const VisualCueInfo &obj)
{
    VisualCueInfo *newVisualCueInfo = new VisualCueInfo(obj);
    cues.push_back(newVisualCueInfo);

    // Indicate that things have changed by selecting it.
    Select(ID_cues, (void *)&cues);
}

// ****************************************************************************
// Method: VisualCueList::ClearCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueList::ClearCues()
{
    AttributeGroupVector::iterator pos;

    for(pos = cues.begin(); pos != cues.end(); ++pos)
        delete *pos;
    cues.clear();

    // Indicate that things have changed by selecting the list.
    Select(ID_cues, (void *)&cues);
}

// ****************************************************************************
// Method: VisualCueList::RemoveCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
VisualCueList::RemoveCues(int index)
{
    AttributeGroupVector::iterator pos = cues.begin();

    // Iterate through the vector "index" times. 
    for(int i = 0; i < index; ++i)
        if(pos != cues.end()) ++pos;

    // If pos is still a valid iterator, remove that element.
    if(pos != cues.end())
    {
        delete *pos;
        cues.erase(pos);
    }

    // Indicate that things have changed by selecting the list.
    Select(ID_cues, (void *)&cues);
}

// ****************************************************************************
// Method: VisualCueList::GetNumCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

int
VisualCueList::GetNumCues() const
{
    return (int)cues.size();
}

// ****************************************************************************
// Method: VisualCueList::GetCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueInfo &
VisualCueList::GetCues(int i)
{
    return *((VisualCueInfo *)cues[i]);
}

// ****************************************************************************
// Method: VisualCueList::GetCues
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const VisualCueInfo &
VisualCueList::GetCues(int i) const
{
    return *((VisualCueInfo *)cues[i]);
}

// ****************************************************************************
// Method: VisualCueList::operator []
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

VisualCueInfo &
VisualCueList::operator [] (int i)
{
    return *((VisualCueInfo *)cues[i]);
}

// ****************************************************************************
// Method: VisualCueList::operator []
//
// Purpose: 
//   container object for shipping vectors of visual cues
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const VisualCueInfo &
VisualCueList::operator [] (int i) const
{
    return *((VisualCueInfo *)cues[i]);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VisualCueList::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
VisualCueList::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_cues: return "cues";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VisualCueList::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
VisualCueList::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_cues: return FieldType_attVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: VisualCueList::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
VisualCueList::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_cues: return "attVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: VisualCueList::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
VisualCueList::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const VisualCueList &obj = *((const VisualCueList*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_cues:
        {  // new scope
        bool cues_equal = (obj.cues.size() == cues.size());
        for(size_t i = 0; (i < cues.size()) && cues_equal; ++i)
        {
            // Make references to VisualCueInfo from AttributeGroup *.
            const VisualCueInfo &cues1 = *((const VisualCueInfo *)(cues[i]));
            const VisualCueInfo &cues2 = *((const VisualCueInfo *)(obj.cues[i]));
            cues_equal = (cues1 == cues2);
        }

        retval = cues_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: VisualCueList::SetFrom
//
// Purpose: Build the VisualCueList AttributeGroupVector directly from
//          a vector of VisualCueInfo pointers
//
// ****************************************************************************
void
VisualCueList::SetFrom(const std::vector<const VisualCueInfo*>& cueVec)
{
    ClearCues();
    for (size_t i = 0; i < cueVec.size(); i++)
        AddCues(*(cueVec[i]));
}

