/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <KeyframeAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Init utility for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void KeyframeAttributes::Init()
{
    enabled = false;
    nFrames = 20;
    nFramesWasUserSet = false;

    KeyframeAttributes::SelectAll();
}

// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Copy utility for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void KeyframeAttributes::Copy(const KeyframeAttributes &obj)
{
    enabled = obj.enabled;
    nFrames = obj.nFrames;
    nFramesWasUserSet = obj.nFramesWasUserSet;

    KeyframeAttributes::SelectAll();
}

// Type map format string
const char *KeyframeAttributes::TypeMapFormatString = KEYFRAMEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t KeyframeAttributes::TmfsStruct = {KEYFRAMEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Default constructor for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes::KeyframeAttributes() : 
    AttributeSubject(KeyframeAttributes::TypeMapFormatString)
{
    KeyframeAttributes::Init();
}

// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Constructor for the derived classes of KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes::KeyframeAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    KeyframeAttributes::Init();
}

// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Copy constructor for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes::KeyframeAttributes(const KeyframeAttributes &obj) : 
    AttributeSubject(KeyframeAttributes::TypeMapFormatString)
{
    KeyframeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: KeyframeAttributes::KeyframeAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes::KeyframeAttributes(const KeyframeAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    KeyframeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: KeyframeAttributes::~KeyframeAttributes
//
// Purpose: 
//   Destructor for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes::~KeyframeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: KeyframeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

KeyframeAttributes& 
KeyframeAttributes::operator = (const KeyframeAttributes &obj)
{
    if (this == &obj) return *this;

    KeyframeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: KeyframeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
KeyframeAttributes::operator == (const KeyframeAttributes &obj) const
{
    // Create the return value
    return ((enabled == obj.enabled) &&
            (nFrames == obj.nFrames) &&
            (nFramesWasUserSet == obj.nFramesWasUserSet));
}

// ****************************************************************************
// Method: KeyframeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
KeyframeAttributes::operator != (const KeyframeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: KeyframeAttributes::TypeName
//
// Purpose: 
//   Type name method for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
KeyframeAttributes::TypeName() const
{
    return "KeyframeAttributes";
}

// ****************************************************************************
// Method: KeyframeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
KeyframeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const KeyframeAttributes *tmp = (const KeyframeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: KeyframeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
KeyframeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new KeyframeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: KeyframeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the KeyframeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
KeyframeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new KeyframeAttributes(*this);
    else
        retval = new KeyframeAttributes;

    return retval;
}

// ****************************************************************************
// Method: KeyframeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
KeyframeAttributes::SelectAll()
{
    Select(ID_enabled,           (void *)&enabled);
    Select(ID_nFrames,           (void *)&nFrames);
    Select(ID_nFramesWasUserSet, (void *)&nFramesWasUserSet);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: KeyframeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
KeyframeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    KeyframeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for KeyframeAttributes.
    DataNode *node = new DataNode("KeyframeAttributes");

    if(completeSave || !FieldsEqual(ID_enabled, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enabled", enabled));
    }

    if(completeSave || !FieldsEqual(ID_nFrames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nFrames", nFrames));
    }

    if(completeSave || !FieldsEqual(ID_nFramesWasUserSet, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nFramesWasUserSet", nFramesWasUserSet));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: KeyframeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
KeyframeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("KeyframeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("enabled")) != 0)
        SetEnabled(node->AsBool());
    if((node = searchNode->GetNode("nFrames")) != 0)
        SetNFrames(node->AsInt());
    if((node = searchNode->GetNode("nFramesWasUserSet")) != 0)
        SetNFramesWasUserSet(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
KeyframeAttributes::SetEnabled(bool enabled_)
{
    enabled = enabled_;
    Select(ID_enabled, (void *)&enabled);
}

void
KeyframeAttributes::SetNFrames(int nFrames_)
{
    nFrames = nFrames_;
    Select(ID_nFrames, (void *)&nFrames);
}

void
KeyframeAttributes::SetNFramesWasUserSet(bool nFramesWasUserSet_)
{
    nFramesWasUserSet = nFramesWasUserSet_;
    Select(ID_nFramesWasUserSet, (void *)&nFramesWasUserSet);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
KeyframeAttributes::GetEnabled() const
{
    return enabled;
}

int
KeyframeAttributes::GetNFrames() const
{
    return nFrames;
}

bool
KeyframeAttributes::GetNFramesWasUserSet() const
{
    return nFramesWasUserSet;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: KeyframeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
KeyframeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_enabled:           return "enabled";
    case ID_nFrames:           return "nFrames";
    case ID_nFramesWasUserSet: return "nFramesWasUserSet";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: KeyframeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
KeyframeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_enabled:           return FieldType_bool;
    case ID_nFrames:           return FieldType_int;
    case ID_nFramesWasUserSet: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: KeyframeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
KeyframeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_enabled:           return "bool";
    case ID_nFrames:           return "int";
    case ID_nFramesWasUserSet: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: KeyframeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
KeyframeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const KeyframeAttributes &obj = *((const KeyframeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_enabled:
        {  // new scope
        retval = (enabled == obj.enabled);
        }
        break;
    case ID_nFrames:
        {  // new scope
        retval = (nFrames == obj.nFrames);
        }
        break;
    case ID_nFramesWasUserSet:
        {  // new scope
        retval = (nFramesWasUserSet == obj.nFramesWasUserSet);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

