/*=========================================================================

   Program: ParaView
   Module:    pqAutoGeneratedObjectPanel.cxx

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.1. 

   See License_v1.1.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

// this include
#include "pqAutoGeneratedObjectPanel.h"

// Qt includes
#include <QCheckBox>
#include <QComboBox>
#include <QDoubleSpinBox>
#include <QDoubleValidator>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QIntValidator>
#include <QLabel>
#include <QLineEdit>
#include <QTextEdit>
#include <QPushButton>
#include <QScrollArea>
#include <QSlider>
#include <QToolButton>
#include <QTreeWidget>
#include <QVBoxLayout>

// Qt widgets includes
#include "pqDoubleRangeWidget.h"

// VTK includes

// ParaView Server Manager includes
#include "vtkCollection.h"
#include "vtkPVXMLElement.h"
#include "vtkSmartPointer.h"
#include "vtkSMDomain.h"
#include "vtkSMDomainIterator.h"
#include "vtkSMOrderedPropertyIterator.h"
#include "vtkSMProperty.h"
#include "vtkSMStringVectorProperty.h"

// ParaView includes
#include "pqApplicationCore.h"
#include "pqFileChooserWidget.h"
#include "pqFileDialog.h"
#include "pqPipelineSource.h"
#include "pqPropertyManager.h"
#include "pqProxy.h"
#include "pqReaderFactory.h"
#include "pqSMAdaptor.h"
#include "pqTreeWidgetCheckHelper.h"
#include "pqTreeWidgetItemObject.h"
#include "pqSelectionTreeWidget.h"
#include "pqXMLUtil.h"
#include "pq3DWidget.h"
#include "pqCollapsedGroup.h"
#include "pqProxySelectionWidget.h"

static QLabel* createPanelLabel(QWidget* parent, QString text)
{
  QLabel* label = new QLabel(parent);
  label->setText(text);
  label->setWordWrap(true);
  return label;
}

//-----------------------------------------------------------------------------
/// constructor
pqAutoGeneratedObjectPanel::pqAutoGeneratedObjectPanel(pqProxy* object_proxy, QWidget* p) :
  pqNamedObjectPanel(object_proxy, p)
{
  this->PanelLayout = new QGridLayout(this);
  this->createWidgets(this->PanelLayout, object_proxy, object_proxy->getProxy());
  this->linkServerManagerProperties();
}

//-----------------------------------------------------------------------------
/// destructor
pqAutoGeneratedObjectPanel::~pqAutoGeneratedObjectPanel()
{
}

//-----------------------------------------------------------------------------
void pqAutoGeneratedObjectPanel::setupValidator(QLineEdit* lineEdit, 
  QVariant::Type type)
{
  switch (type)
    {
  case QVariant::Double:
    lineEdit->setValidator(new QDoubleValidator(lineEdit));
    break;

  case QVariant::Int:
    lineEdit->setValidator(new QIntValidator(lineEdit));
    break;

  default:
    break;
    }
}

//-----------------------------------------------------------------------------
void pqAutoGeneratedObjectPanel::linkServerManagerProperties()
{
  pqNamedObjectPanel::linkServerManagerProperties();
  
  QPixmap cellPixmap(":/pqWidgets/Icons/pqCellData16.png");
  QPixmap pointPixmap(":/pqWidgets/Icons/pqPointData16.png");

  // link point/cell array status widget
  QTreeWidget* treeWidget;
  vtkSMProperty* cellArrayStatus;
  vtkSMProperty* pointArrayStatus;
  treeWidget = this->findChild<QTreeWidget*>("CellAndPointArrayStatus");
  cellArrayStatus = this->proxy()->GetProperty("CellArrayStatus");
  pointArrayStatus = this->proxy()->GetProperty("PointArrayStatus");

  if(treeWidget && cellArrayStatus && pointArrayStatus)
    {
    QList<QVariant> sel_domain;
    sel_domain = pqSMAdaptor::getSelectionPropertyDomain(cellArrayStatus);
    for(int j=0; j<sel_domain.size(); j++)
      {
      QList<QString> str;
      str.append(sel_domain[j].toString());
      pqTreeWidgetItemObject* item;
      item = new pqTreeWidgetItemObject(treeWidget, str);
      item->setData(0, Qt::DecorationRole, cellPixmap);
      this->propertyManager()->registerLink(item, 
                                        "checked", 
                                        SIGNAL(checkedStateChanged(bool)),
                                        this->proxy(), 
                                        cellArrayStatus, j);
      }
    sel_domain = pqSMAdaptor::getSelectionPropertyDomain(pointArrayStatus);
    for(int j=0; j<sel_domain.size(); j++)
      {
      QList<QString> str;
      str.append(sel_domain[j].toString());
      pqTreeWidgetItemObject* item;
      item = new pqTreeWidgetItemObject(treeWidget, str);
      item->setData(0, Qt::DecorationRole, pointPixmap);
      this->propertyManager()->registerLink(item,
                                        "checked", 
                                        SIGNAL(checkedStateChanged(bool)),
                                        this->proxy(), 
                                        pointArrayStatus, j);
      }
    }
}

void pqAutoGeneratedObjectPanel::createWidgets(QGridLayout* panelLayout,
                                               pqProxy* refProxy,
                                               vtkSMProxy* pxy)
{
  int rowCount = 0;
  int skippedFirstFileProperty = 0;
  bool isCompoundProxy = pxy->IsA("vtkSMCompoundProxy");

  // query for proxy properties, and create widgets
  vtkSMOrderedPropertyIterator *iter = vtkSMOrderedPropertyIterator::New();
  iter->SetProxy(pxy);

  int hasCellArrayStatus = 0;
  int hasPointArrayStatus = 0;

  // check for both CellArrayStatus & PointArrayStatus
  for(iter->Begin(); !iter->IsAtEnd(); iter->Next())
    {
    if(QString(iter->GetKey()) == QString("CellArrayStatus"))
      {
      hasCellArrayStatus = 1;
      }
    if(QString(iter->GetKey()) == QString("PointArrayStatus"))
      {
      hasPointArrayStatus = 1;
      }
    }

  int hasCellPointArrayStatus = 0;
  if(hasPointArrayStatus && hasCellArrayStatus)
    {
    hasCellPointArrayStatus = 1;
    }
  int cellPointArrayStatusWidgetAdded = 0;

  QStringList propertiesToHide;
  QStringList propertiesToShow;
  pqAutoGeneratedObjectPanel::processHints(panelLayout, refProxy, pxy, 
                                           propertiesToHide, propertiesToShow);
  rowCount = panelLayout->rowCount();
  for(iter->Begin(); !iter->IsAtEnd(); iter->Next())
    {
    vtkSMProperty* SMProperty = iter->GetProperty();
    QString propertyName = iter->GetKey();
    if (propertiesToHide.contains(propertyName))
      {
      continue;
      }
    propertyName.replace(':', '_');
    propertyName.replace(' ', '_');

    // When this proxy represents a custom filter, we want to use the property 
    //  names the user provided rather than the built in property labels:
    QString propertyLabel;
    if(isCompoundProxy)
      {
      propertyLabel = iter->GetKey();
      }
    else
      {
      propertyLabel = SMProperty->GetXMLLabel();
      }

    // skip information properties
    if(SMProperty->GetInformationOnly() || SMProperty->GetIsInternal())
      {
      continue;
      }

    if (!propertiesToShow.contains(propertyName))
      {
      if (SMProperty->IsA("vtkSMStringVectorProperty") && !skippedFirstFileProperty)
        {
        // Do not show the first file property. We do not allow changing of
        // the main filename from the gui. The user has to create another
        // instance of the reader and reconnect the pipeline.
        vtkSmartPointer<vtkSMDomainIterator> diter;
        diter.TakeReference(SMProperty->NewDomainIterator());
        diter->Begin();
        while(!diter->IsAtEnd())
          {
          if (diter->GetDomain()->IsA("vtkSMFileListDomain"))
            {
            break;
            }
          diter->Next();
          }
        if (!diter->IsAtEnd())
          {
          skippedFirstFileProperty = 1;
          continue;
          }
        }
      }

    // update domains we might ask for
    SMProperty->UpdateDependentDomains();

    pqSMAdaptor::PropertyType pt = pqSMAdaptor::getPropertyType(SMProperty);
    QList<QString> domainsTypes = pqSMAdaptor::getDomainTypes(SMProperty);

    // skip input properties
    if(pt == pqSMAdaptor::PROXY || pt == pqSMAdaptor::PROXYLIST)
      {
      if(SMProperty == pxy->GetProperty("Input"))
        {
        continue;
        }
      }

    if(pt == pqSMAdaptor::PROXY)
      {
      // create a combo box with list of proxies
      QComboBox* combo = new QComboBox(panelLayout->parentWidget());
      combo->setObjectName(propertyName);
      QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                       propertyLabel);
      panelLayout->addWidget(label, rowCount, 0, 1, 1);
      panelLayout->addWidget(combo, rowCount, 1, 1, 1);
      rowCount++;
      }
    else if(pt == pqSMAdaptor::PROXYLIST)
      {
      // create a list of selections of proxies
      }
    else if (pt==pqSMAdaptor::PROXYSELECTION && refProxy->getProxy() == pxy)
      {
      // for now, support only one level deep of proxy selections
      pqProxySelectionWidget* w = 
        new pqProxySelectionWidget(refProxy, iter->GetKey(),
                                   propertyLabel,
                                   panelLayout->parentWidget());
      w->setObjectName(propertyName);
      panelLayout->addWidget(w, rowCount, 0, 1, 2);
      rowCount++;
      }
    else if(pt == pqSMAdaptor::ENUMERATION)
      {
      QVariant enum_property = pqSMAdaptor::getEnumerationProperty(SMProperty);
      if(enum_property.type() == QVariant::Bool)
        {
        // check box for true/false
        QCheckBox* check;
        check = new QCheckBox(propertyLabel, 
                              panelLayout->parentWidget());
        check->setObjectName(propertyName);
        panelLayout->addWidget(check, rowCount, 0, 1, 2);
        rowCount++;
        }
      else
        {
        vtkSMVectorProperty* vp = vtkSMVectorProperty::SafeDownCast(SMProperty);
        // Some enumeration properties, we add
        // ability to select mutliple elements. This is the case if the
        // SM property has repeat command flag set.
        if (vp && vp->GetRepeatCommand())
          {
          QTreeWidget* tw = new pqSelectionTreeWidget(panelLayout->parentWidget());
          tw->setColumnCount(1);
          tw->setRootIsDecorated(false);
          QTreeWidgetItem* h = new QTreeWidgetItem();
          h->setData(0, Qt::DisplayRole, propertyLabel);
          tw->setHeaderItem(h);
          tw->setObjectName(propertyName);
          new pqTreeWidgetCheckHelper(tw, 0, tw);
          panelLayout->addWidget(tw, rowCount, 0, 1, 2);
          rowCount++;
          }
        else
          {
          // combo box with strings
          QComboBox* combo = new QComboBox(panelLayout->parentWidget());
          combo->setObjectName(propertyName);
          QLabel* label = createPanelLabel(panelLayout->parentWidget(),
            propertyLabel);
          panelLayout->addWidget(label, rowCount, 0, 1, 1);
          panelLayout->addWidget(combo, rowCount, 1, 1, 1);
          }
        rowCount++;
        }
      }
    else if(pt == pqSMAdaptor::SELECTION)
      {
      int doIt = 1;
      QString name = propertyName;
      QString header = propertyLabel;

      if((propertyName == QString("CellArrayStatus") ||
         propertyName == QString("PointArrayStatus")) &&
         hasCellPointArrayStatus == 1)
        {
        if(cellPointArrayStatusWidgetAdded == 1)
          {
          doIt = 0;
          }
        else
          {
          cellPointArrayStatusWidgetAdded = 1;
          name = "CellAndPointArrayStatus";
          header = "Cell/Point Array Status";
          }
        }
      if(doIt)
        {
        QList<QList<QVariant> > items;
        items = pqSMAdaptor::getSelectionProperty(SMProperty);
        QTreeWidget* tw = new pqSelectionTreeWidget(panelLayout->parentWidget());
        tw->setColumnCount(1);
        tw->setRootIsDecorated(false);
        QTreeWidgetItem* h = new QTreeWidgetItem();
        h->setData(0, Qt::DisplayRole, header);
        tw->setHeaderItem(h);
        tw->setObjectName(name);
        new pqTreeWidgetCheckHelper(tw, 0, tw);
        panelLayout->addWidget(tw, rowCount, 0, 1, 2);
        rowCount++;
        }
      }
    else if(pt == pqSMAdaptor::SINGLE_ELEMENT)
      {
      QVariant elem_property = pqSMAdaptor::getElementProperty(SMProperty);
      QList<QVariant> propertyDomain;
      propertyDomain = pqSMAdaptor::getElementPropertyDomain(SMProperty);
      if(elem_property.type() == QVariant::String && propertyDomain.size())
        {
        // combo box with strings
        QComboBox* combo = new QComboBox(panelLayout->parentWidget());
        combo->setObjectName(propertyName);
        QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                         propertyLabel);
        
        panelLayout->addWidget(label, rowCount, 0, 1, 1);
        panelLayout->addWidget(combo, rowCount, 1, 1, 1);
        rowCount++;
        }
      else if(elem_property.type() == QVariant::Int && 
              propertyDomain.size() == 2)
        {
        QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                         propertyLabel);
        QSlider* slider;
        slider = new QSlider(Qt::Horizontal, panelLayout->parentWidget());
        slider->setObjectName(QString(propertyName) + "_Slider");
        slider->setRange(propertyDomain[0].toInt(), propertyDomain[1].toInt());

        QLineEdit* lineEdit = new QLineEdit(panelLayout->parentWidget());
        lineEdit->setObjectName(propertyName);
        pqAutoGeneratedObjectPanel::setupValidator(lineEdit, elem_property.type()); 
        panelLayout->addWidget(label, rowCount, 0, 1, 1);
        QHBoxLayout* hlayout = new QHBoxLayout;
        hlayout->addWidget(slider);
        hlayout->addWidget(lineEdit);
        panelLayout->addLayout(hlayout, rowCount, 1, 1, 1);
        slider->show();
        lineEdit->show();
        rowCount++;
        }
      else if(elem_property.type() == QVariant::Double && 
              propertyDomain.size() == 2 && 
              domainsTypes.contains("vtkSMDoubleRangeDomain"))
        {
        /*
        double range[2];
        range[0] = propertyDomain[0].toDouble();
        range[1] = propertyDomain[1].toDouble();
        */
        QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                         propertyLabel);
        /*
        QDoubleSpinBox* spinBox;
        spinBox = new QDoubleSpinBox(panelLayout->parentWidget());
        spinBox->setObjectName(propertyName);
        spinBox->setRange(range[0], range[1]);
        spinBox->setSingleStep((range[1] - range[0]) / 20.0);
        */
        pqDoubleRangeWidget* range;
        range = new pqDoubleRangeWidget(panelLayout->parentWidget());
        range->setObjectName(propertyName);
        range->setMinimum(propertyDomain[0].toDouble());
        range->setMaximum(propertyDomain[1].toDouble());

        panelLayout->addWidget(label, rowCount, 0, 1, 1);
        panelLayout->addWidget(range, rowCount, 1, 1, 1);
        rowCount++;
        }
      else
        {
        //  what entry widget we should use for a stringvectorproperty
        bool multiLineString = false;
        vtkPVXMLElement* hints = SMProperty->GetHints();
        if (hints)
          {
          vtkPVXMLElement* widgetHint = hints->FindNestedElementByName("Widget");
          if (widgetHint)
            {
            if (widgetHint->GetAttribute("type") &&
                strcmp(widgetHint->GetAttribute("type"), "multi_line") == 0)
              {
              multiLineString = true;
              }
            }
          }

        if (!multiLineString)
          {
          QLineEdit* lineEdit = new QLineEdit(panelLayout->parentWidget());
          lineEdit->setObjectName(propertyName);
          pqAutoGeneratedObjectPanel::setupValidator(lineEdit, elem_property.type()); 
          
          QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                           propertyLabel);
          
          panelLayout->addWidget(label, rowCount, 0, 1, 1);
          panelLayout->addWidget(lineEdit, rowCount, 1, 1, 1);
          rowCount++;
          }
        else
          {
          QTextEdit *textEdit = new QTextEdit(panelLayout->parentWidget());
          textEdit->setObjectName(propertyName);
          textEdit->setAcceptRichText(false);
          // The default tab stop is too big
          textEdit->setTabStopWidth(textEdit->tabStopWidth()/4);
          // We don't want line wrap when editing, for example, a python script
          textEdit->setLineWrapMode(QTextEdit::NoWrap);
          
          QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                           QString(propertyLabel)+":");
          
          panelLayout->addWidget(label, rowCount, 0, 1, 2);
          rowCount++;

          panelLayout->addWidget(textEdit, rowCount, 0, 1, 2);
          panelLayout->setRowStretch(rowCount, 1);
          rowCount++;
          }
        }
      }
    else if(pt == pqSMAdaptor::MULTIPLE_ELEMENTS)
      {
      QList<QVariant> list_property;
      list_property = pqSMAdaptor::getMultipleElementProperty(SMProperty);
      QList<QList<QVariant> > domain;
      domain = pqSMAdaptor::getMultipleElementPropertyDomain(SMProperty);
      
      QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                       propertyLabel);
      panelLayout->addWidget(label, rowCount, 0, 1, 1);
      QGridLayout* glayout = new QGridLayout;
      glayout->setObjectName(propertyName);
      panelLayout->addLayout(glayout, rowCount, 1, 1, 1);

      // we have a few different layouts
      static const int LayoutThreeByTwo = 0;
      static const int LayoutRow = 1;
      static const int LayoutColumn = 2;

      // let's peek at what property types and domains we have to determine
      // which layout to use
      int layoutMethod = LayoutRow;
      if(list_property.size() == 6)
        {
        layoutMethod = LayoutThreeByTwo;
        }
      else if(list_property.size() > 3)  // that many won't fit in a row
        {
        layoutMethod = LayoutColumn;
        }

      int i=0;
      foreach(QVariant v, list_property)
        {
        QLayoutItem* item = NULL;

        // create the widget(s)
        if( 0 /*v.type() == QVariant::String && 
           domain.size() && domain[i].size() */)  // link not supported yet
          {
          QComboBox* combo = new QComboBox(panelLayout->parentWidget());
          combo->setObjectName(QString("%1_%2").arg(propertyName).arg(i));
          item = new QWidgetItem(combo);
          }
        else if(v.type() == QVariant::Int && 
           domain.size() && domain[i].size() == 2)
          {
          int range[2];
          range[0] = domain[i][0].toInt();
          range[1] = domain[i][1].toInt();
          QSpinBox* spinBox;
          spinBox = new QSpinBox(panelLayout->parentWidget());
          spinBox->setObjectName(QString("%1_%2").arg(propertyName).arg(i));
          spinBox->setRange(range[0], range[1]);
          item = new QWidgetItem(spinBox);
          }
        else if(v.type() == QVariant::Double && 
                domain.size() && domain[i].size() == 2)
          {
          /*
          double range[2];
          range[0] = domain[i][0].toDouble();
          range[1] = domain[i][1].toDouble();
          QDoubleSpinBox* spinBox;
          spinBox = new QDoubleSpinBox(panelLayout->parentWidget());
          spinBox->setObjectName(QString("%1_%2").arg(propertyName).arg(i));
          spinBox->setRange(range[0], range[1]);
          spinBox->setSingleStep((range[1] - range[0]) / 20.0);
          */
          pqDoubleRangeWidget* range;
          range = new pqDoubleRangeWidget(panelLayout->parentWidget());
          range->setObjectName(QString("%1_%2").arg(propertyName).arg(i));
          range->setMinimum(domain[i][0].toDouble());
          range->setMaximum(domain[i][1].toDouble());
          item = new QWidgetItem(range);
          }
        else
          {
          QLineEdit* lineEdit = new QLineEdit(panelLayout->parentWidget());
          lineEdit->setObjectName(QString("%1_%2").arg(propertyName).arg(i));
          pqAutoGeneratedObjectPanel::setupValidator(lineEdit, v.type()); 
          item = new QWidgetItem(lineEdit);
          }

        // insert the widget(s) in the layout
        if(layoutMethod == LayoutThreeByTwo)
          {
          glayout->addItem(item, i/2, i%2, 1, 1);
          }
        else if(layoutMethod == LayoutRow)
          {
          glayout->addItem(item, 0, i, 1, 1);
          }
        else if(layoutMethod == LayoutColumn)
          {
          glayout->addItem(item, i, 0, 1, 1);
          }


        // widgets in sub-layouts need help being shown
        QLayout* l = item->layout();
        if(l)
          {
          int count = l->count();
          for(int k=0; k<count; k++)
            {
            QLayoutItem* li = l->itemAt(k);
            if(li->widget())
              {
              li->widget()->show();
              }
            }
          }

        i++;
        }
        rowCount++;
      }
    else if(pt == pqSMAdaptor::FILE_LIST)
      {
      pqFileChooserWidget* chooser;
      chooser = new pqFileChooserWidget(panelLayout->parentWidget());
      chooser->setServer(refProxy->getServer());
      chooser->setObjectName(propertyName);
      QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                       propertyLabel);
      
      panelLayout->addWidget(label, rowCount, 0, 1, 1);
      panelLayout->addWidget(chooser, rowCount, 1, 1, 1);
      rowCount++;
      }
    else if(pt == pqSMAdaptor::FIELD_SELECTION)
      {
      QLabel* label = createPanelLabel(panelLayout->parentWidget(),
                                       "Scalars");
      QComboBox* combo = new QComboBox(panelLayout->parentWidget());
      combo->setObjectName(QString(propertyName));
      panelLayout->addWidget(label, rowCount, 0, 1, 1);
      panelLayout->addWidget(combo, rowCount, 1, 1, 1);
      rowCount++;
      }
    }
  iter->Delete();
  panelLayout->addItem(new QSpacerItem(0,0,
                                       QSizePolicy::Expanding,
                                       QSizePolicy::Expanding), 
                       rowCount, 0, 1, 2);
  panelLayout->invalidate();
}

//-----------------------------------------------------------------------------
// Process hints and form complex widgets using hints.

void pqAutoGeneratedObjectPanel::processHints(QGridLayout* panelLayout,
                                              pqProxy* refProxy,
                                              vtkSMProxy* smProxy,
                                              QStringList& propertiesToHide,
                                              QStringList& propertiesToShow)
{
  // Get the hints for this proxy.
  // The hints may contain stuff about property groupping/layout
  // etc etc.
  vtkPVXMLElement* hints = smProxy->GetHints();
  if (!hints)
    {
    return;
    }

  // Check for any hints about whether to show or hide the widget associated
  // with a particular property.
  unsigned int numHints = hints->GetNumberOfNestedElements();
  for (unsigned int i = 0; i < numHints; i++)
    {
    vtkPVXMLElement *element = hints->GetNestedElement(i);
    if (QString("Property") == element->GetName())
      {
      QString propertyName = element->GetAttribute("name");
      int showProperty;
      if (element->GetScalarAttribute("show", &showProperty))
        {
        if (showProperty)
          {
          propertiesToShow.push_back(propertyName);
          }
        else
          {
          propertiesToHide.push_back(propertyName);
          }
        }
      }
    }

  pqObjectPanel* panel =
    qobject_cast<pqObjectPanel*>(panelLayout->parentWidget());

  // See if any properties are grouped into 3D widgets.
  QList<pq3DWidget*> widgets = pq3DWidget::createWidgets(refProxy, smProxy);
  if (widgets.size() == 0)
    {
    return;
    }
  int rowCount = 0;
  foreach (pq3DWidget* widget, widgets)
    {
    pqCollapsedGroup* group = 
      new pqCollapsedGroup(panel);
    group->setLayout(new QVBoxLayout(group));
    group->setTitle(widget->getHints()->GetAttribute("label"));
    widget->setParent(group);
    QObject::connect(panel, SIGNAL(renderModuleChanged(pqRenderViewModule*)),
      widget,SLOT(setRenderModule(pqRenderViewModule*)));
    widget->setRenderModule(panel->renderModule());
    widget->resetBounds();
    widget->reset();
    
    QObject::connect(panel, SIGNAL(onselect()), widget, SLOT(select()));
    QObject::connect(panel, SIGNAL(ondeselect()), widget, SLOT(deselect()));
    QObject::connect(panel, SIGNAL(onaccept()), widget, SLOT(accept()));
    QObject::connect(panel, SIGNAL(onreset()), widget, SLOT(reset()));
    QObject::connect(widget, SIGNAL(modified()),
                     panel, SLOT(setModified()));

    group->layout()->addWidget(widget);
    panelLayout->addWidget(group, rowCount++, 0, 1, 2);

    vtkSmartPointer<vtkCollection> elements = 
      vtkSmartPointer<vtkCollection>::New();
    vtkPVXMLElement* widgetHints = widget->getHints();
    widgetHints->GetElementsByName("Property", elements);
    for (int cc=0; cc < elements->GetNumberOfItems(); ++cc)
      {
      vtkPVXMLElement* child = vtkPVXMLElement::SafeDownCast(
        elements->GetItemAsObject(cc));
      if (!child)
        {
        continue;
        }
      propertiesToHide.push_back(child->GetAttribute("name"));
      }
    }
}

