/*=========================================================================

   Program: ParaView
   Module:    pqPythonStream.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.1. 

   See License_v1.1.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef _pqPythonStream_h
#define _pqPythonStream_h

#include <QObject>
#include "QtPythonExport.h"

/// Helper-class that converts Python stream operations into Qt signals.
class QTPYTHON_EXPORT pqPythonStream :
  public QObject
{
  Q_OBJECT

public:
  pqPythonStream();
  
  void write(const QString&);
  
signals:
  void streamWrite(const QString&);  

private:
  pqPythonStream(const pqPythonStream&);
  pqPythonStream& operator=(const pqPythonStream&);
};

/// Wraps a pqPythonStream in a Python object (the return-type is void* instead of PyObject* due to conflicts between Qt and the Python headers)
void* pqWrap(pqPythonStream&);

#endif // !_pqPythonStream_h

