/*=========================================================================

   Program: ParaView
   Module:    pqElementInspectorWidget.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.1. 

   See License_v1.1.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#ifndef _pqElementInspectorWidget_h
#define _pqElementInspectorWidget_h

#include "pqComponentsExport.h"
#include <QWidget>

class pqPipelineSource;
class pqSelectionManager;
class pqServer;
class pqServerManagerModelItem;
class vtkSMGenericViewDisplayProxy;
class vtkUnstructuredGrid;

/// Displays a collection of data set elements in a spreadsheet form.
/// pqElementInspectorWidget has dual role:
/// \li showing the data from the active selection
/// \li showing the data from a "ExtractCellSelection" 
//      or "ExtractPointSelection" filter.
class PQCOMPONENTS_EXPORT pqElementInspectorWidget :
  public QWidget
{
  Q_OBJECT
  
public:
  pqElementInspectorWidget(QWidget* parent);
  ~pqElementInspectorWidget();

  /// Set the selection manager. The selection manager is used to
  /// obtain the current user defined cell selection.
  void setSelectionManager(pqSelectionManager*);

signals:
  /// Signal emitted whenever the collection of elements changes
  void elementsChanged(vtkUnstructuredGrid*);

  /// Fired before performing non-undoable changes.
  void beginNonUndoableChanges();

  /// Fired after performing non-undoable changes.
  void endNonUndoableChanges();
public slots:
  /// Called when user creates a new surface selection (or old 
  /// surface selection is cleared).
  void onSelectionChanged();

  /// Called to inspect the data generated by any source.
  /// Currently, we only show data from "ExtractPointSelection" or
  /// "ExtractCellSelection" filters.
  void inspect(pqPipelineSource* source);

  /// Refreshes the view.
  void refresh();

  /// Set the current server. This will create a new element inspector
  /// view module is none exists for this server.
  void setServer(pqServer* server);

protected:
  /// Set the data object to display in the panel. 
  /// Currently it only works with unstructured grid,
  /// we may want to extend it to work with
  /// DataObject or DataSet.
  void setDataObject(vtkUnstructuredGrid* ug);

  void onElementsChanged();

  /// Tunrs visibility off for all displays except the one
  /// passed as argument, if any whose visibility is set to 1.
  void showOnly(vtkSMGenericViewDisplayProxy* dislay);

protected slots:
  void onCurrentTypeTextChanged(const QString& text);

  /// Called when the application selection changes.
  void onCurrentChanged(pqServerManagerModelItem*);

  /// Call this to clean all server connection related objects.
  /// Called when server disconnects.
  void cleanServer();

  /// Updates the panel to show the data from the first
  /// visible display in the view, if any.
  /// If none is located, the panel will be cleared.
  void updateGUI();

  /// Called when a source is removed.
  void onSourceRemoved(pqPipelineSource* source);

private:
  struct pqImplementation;
  pqImplementation* const Implementation;
};

#endif
