'\"
'\" Copyright (c) 1993-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) Id
'\" 
.so man.macros
.TH catch n "8.0" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
catch \- Evaluate script and trap exceptional returns
.SH SYNOPSIS
\fBcatch\fI script \fR?\fIvarName\fR?
.BE

.SH DESCRIPTION
.PP
The \fBcatch\fR command may be used to prevent errors from aborting command
interpretation.  The \fBcatch\fR command calls the Tcl interpreter recursively to
execute \fIscript\fR, and always returns without raising an error,
regardless of any errors that might occur while executing \fIscript\fR.
.PP
If \fIscript\fR raises an error, \fBcatch\fR will return a non-zero integer
value corresponding to the exceptional return code returned by evaluation
of \fIscript\fR.  Tcl defines the normal return code from script
evaluation to be zero (0), or \fBTCL_OK\fR.  Tcl also defines four exceptional
return codes: 1 (\fBTCL_ERROR\fR), 2 (\fBTCL_RETURN\fR), 3 (\fBTCL_BREAK\fR),
and 4 (\fBTCL_CONTINUE\fR).  Errors during evaluation of a script are indicated
by a return code of \fBTCL_ERROR\fR.  The other exceptional return codes are
returned by the \fBreturn\fR, \fBbreak\fR, and \fBcontinue\fR commands
and in other special situations as documented.  Tcl packages can define
new commands that return other integer values as return codes as well,
and scripts that make use of the \fBreturn -code\fR command can also
have return codes other than the five defined by Tcl.
.PP
If the \fIvarName\fR argument is given, then the variable it names is
set to the result of the script evaluation.  When the return code from
the script is 1 (\fBTCL_ERROR\fR), the value stored in \fIvarName\fR is an error
message.  When the return code from the script is 0 (\fBTCL_OK\fR), the value
stored in \fIresultVarName\fR is the value returned from \fIscript\fR.
.PP
If \fIscript\fR does not raise an error, \fBcatch\fR will return 0
(\fBTCL_OK\fR) and set the variable to the value returned from \fIscript\fR.
.PP
Note that \fBcatch\fR catches all exceptions, including those
generated by \fBbreak\fR and \fBcontinue\fR as well as errors.  The
only errors that are not caught are syntax errors found when the
script is compiled.  This is because the catch command only catches
errors during runtime.  When the catch statement is compiled, the
script is compiled as well and any syntax errors will generate a Tcl
error. 

.SH EXAMPLES
The \fBcatch\fR command may be used in an \fBif\fR to branch based on
the success of a script.
.CS
if { [\fBcatch\fR {open $someFile w} fid] } {
    puts stderr "Could not open $someFile for writing\\n$fid"
    exit 1
}
.CE
.PP
The \fBcatch\fR command will not catch compiled syntax errors.  The
first time proc \fBfoo\fR is called, the body will be compiled and a
Tcl error will be generated. 
.CS
proc foo {} {
    \fBcatch\fR {expr {1 +- }}
}
.CE

.SH "SEE ALSO" 
break(n), continue(n), error(n), return(n), tclvars(n)

.SH KEYWORDS
catch, error
