# Dashboard is opened for submissions for a 24 hour period starting at
# the specified NIGHLY_START_TIME. Time is specified in 24 hour format.
SET (NIGHTLY_START_TIME "21:00:00 EDT")

# Dart server to submit results (used by client)
IF(DROP_METHOD MATCHES http)
  IF (NOT DEFINED DROP_SITE)
    SET (DROP_SITE "public.kitware.com")
    SET (DROP_LOCATION "/cgi-bin/HTTPUploadDartFile.cgi")
  ENDIF (NOT DEFINED DROP_SITE)
ELSE(DROP_METHOD MATCHES http)
  IF (NOT DEFINED DROP_SITE)
    SET (DROP_SITE "public.kitware.com")
    SET (DROP_LOCATION "/incoming")
    SET (DROP_SITE_USER "ftpuser")
    SET (DROP_SITE_PASSWORD "public")
  ENDIF (NOT DEFINED DROP_SITE)
ENDIF(DROP_METHOD MATCHES http)

SET (TRIGGER_SITE 
       "http://${DROP_SITE}/cgi-bin/Submit-ParaView-TestingResults.pl")

# Project Home Page
SET (PROJECT_URL "http://www.paraview.org")

# Dart server configuration 
SET (ROLLUP_URL "http://${DROP_SITE}/cgi-bin/paraview-rollup-dashboard.sh")
SET (CVS_WEB_URL "http://${DROP_SITE}/cgi-bin/viewcvs.cgi/")
SET (CVS_WEB_CVSROOT "ParaView")
SET (USE_DOXYGEN "On")
SET (DOXYGEN_URL "${PROJECT_URL}/doc" )
SET (GNATS_WEB_URL "${PROJECT_URL}/Bug/query.php?projects=3&status%5B%5D=1&status%5B%5D=2&status%5B%5D=3&status%5B%5D=4&status%5B%5D=6&op=doquery")
SET (USE_GNATS "On")

# Continuous email delivery variables
SET (CONTINUOUS_FROM "paraview-dashboard@public.kitware.com")
SET (SMTP_MAILHOST "public.kitware.com")
SET (CONTINUOUS_MONITOR_LIST "paraview-dashboard@public.kitware.com")
SET (CONTINUOUS_BASE_URL "${PROJECT_URL}/Testing")

SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_TEST_FAILURES ON)
SET (DELIVER_BROKEN_BUILD_EMAIL "Continuous Nightly")
SET (EMAIL_FROM "paraview-dashboard@public.kitware.com")
SET (DARTBOARD_BASE_URL "${PROJECT_URL}/Testing")

SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_CONFIGURE_FAILURES 1)
SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_BUILD_ERRORS 1)
SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_BUILD_WARNINGS 1)
SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_TEST_NOT_RUNS 1)
SET (DELIVER_BROKEN_BUILD_EMAIL_WITH_TEST_FAILURES 1)

