# Getting Started Using Python

## Installation
VTK is available on [PyPi](https://pypi.org/) for Windows,Mac OS and Linux.
```
pip install vtk
```
or in a [virtual environment](https://docs.python.org/3/library/venv.html) if you want to install the package only locally instead of system-wide

For Linux and Mac OS:
```
python -m venv ./env
source ./env/bin/activate
pip install vtk
```
On Windows using `PowerShell`
```
python -m venv env
.\env\Activate.ps1
pip install vtk
```

or using `cmd.exe`
```
python -m venv env
.\env\activate.bat
pip install vtk
```

That's it ! You may now try some of the [tutorials](https://kitware.github.io/vtk-examples/site/Python/#tutorial) or [examples](https://kitware.github.io/vtk-examples/site/Python).
