set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/main.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file\n  ${vcProjectFile}\ndoes not exist.")
  return()
endif()

set(TreatWarningAsError_FOUND FALSE)
file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "^ *<TreatWarningAsError>([^<>]*)</TreatWarningAsError>$")
    set(TreatWarningAsError_FOUND TRUE)
    set(expectedValue "false")
    set(actualValue "${CMAKE_MATCH_1}")
    if(NOT (${actualValue} STREQUAL ${expectedValue}))
      set(RunCMake_TEST_FAILED "TreatWarningAsError \"${actualValue}\" differs from expected value \"${expectedValue}\".")
      return()
    endif()
  endif()
endforeach()

if(NOT TreatWarningAsError_FOUND)
  set(RunCMake_TEST_FAILED "Property TreatWarningAsError not found in project file:\n ${vcProjectFile}.")
  return()
endif()
