/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkOutputStream.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkOutputStream - Wraps a binary output stream with a VTK interface.
// .SECTION Description
// vtkOutputStream provides a VTK-style interface wrapping around a
// standard output stream.  The access methods are virtual so that
// subclasses can transparently provide encoding of the output.  Data
// lengths for Write calls refer to the length of the data in memory.
// The actual length in the stream may differ for subclasses that
// implement an encoding scheme.

#ifndef __vtkOutputStream_h
#define __vtkOutputStream_h

#include "vtkObject.h"

class VTK_IO_EXPORT vtkOutputStream : public vtkObject
{
public:
  vtkTypeRevisionMacro(vtkOutputStream,vtkObject);
  static vtkOutputStream *New();
  void PrintSelf(ostream& os, vtkIndent indent);
  
  //BTX
  // Description:
  // Get/Set the real output stream.
  vtkSetMacro(Stream, ostream*);
  vtkGetMacro(Stream, ostream*);
  //ETX
  
  // Description:  
  // Called after the stream position has been set by the caller, but
  // before any Write calls.  The stream position should not be
  // adjusted by the caller until after an EndWriting call.
  virtual int StartWriting();
  
  // Description:
  // Write output data of the given length.
  virtual int Write(const unsigned char* data, unsigned long length);
  int Write(const char* data, unsigned long length);
  
  // Description:
  // Called after all desired calls to Write have been made.  After
  // this call, the caller is free to change the position of the
  // stream.  Additional writes should not be done until after another
  // call to StartWriting.
  virtual int EndWriting();
  
protected:
  vtkOutputStream();
  ~vtkOutputStream();  
  
  // The real output stream.
  ostream* Stream;
  
private:
  vtkOutputStream(const vtkOutputStream&);  // Not implemented.
  void operator=(const vtkOutputStream&);  // Not implemented.
};

#endif
