#!/bin/sh
set -ex

script_dir="$(cd "$(dirname "$0")"; pwd)"

image_build_tag="$(cat "$script_dir/TAG")"
docker="podman"

$docker image load -i "$script_dir/vtk-wasm-sdk-emscripten.tar"

$docker tag "kitware/vtk-wasm-sdk:$image_build_tag" "kitware/vtk-wasm-sdk:latest"

set +x
echo "Logging into index.docker.io ..."
$docker login --username "$DOCKERHUB_USERNAME" --password "$DOCKERHUB_PASSWORD" index.docker.io
set -x

$docker push "kitware/vtk-wasm-sdk:$image_build_tag"
$docker push "kitware/vtk-wasm-sdk:latest"
