#!/bin/sh
set -ex

script_dir="$(cd "$(dirname "$0")"; pwd)"
: "${VTK_VCS_REF:=master}"
: "${VTK_VCS_URL:=https://gitlab.kitware.com/vtk/vtk.git}"
docker=podman
version=""
short_sha=""

for arch in wasm32 wasm32-threads wasm64 wasm64-threads; do
    v="$(cat "$script_dir/$arch.version")"
    [ -z "$version" ] && version="$v" || [ "$version" = "$v" ] || { echo "Error: Version mismatch for $arch ($v != $version)" >&2; exit 1; }
    ssha="$(cat "$script_dir/$arch.commit")"
    [ -z "$short_sha" ] && short_sha="$ssha" || [ "$short_sha" = "$ssha" ] || { echo "Error: Commit mismatch for $arch ($ssha != $short_sha)" >&2; exit 1; }
    $docker image load -i "$script_dir/vtk-wasm-sdk-emscripten-${arch}.tar"
done

# For stable releases, use just the version as the tag.
# For other builds, append the short SHA to the version.
if [ "$VTK_VCS_REF" = "v$version" ]; then
    tag="$version"
else
    tag="$version-$short_sha"
fi

$docker build --format=docker --cgroup-manager=cgroupfs \
    --build-arg BUILD_DATE="$(date)" \
    --build-arg SOURCE_URL="$VTK_VCS_URL" \
    -t "kitware/vtk-wasm-sdk:$tag" \
    -f "$script_dir/Dockerfile.combine" "$@" | tee "$script_dir/combine.log"

$docker save --format=docker-archive -o "$script_dir/vtk-wasm-sdk-emscripten.tar" "kitware/vtk-wasm-sdk:$tag"
echo "$tag" > "$script_dir/TAG"
