Here’s a summary of how this repository builds and tests the `vtk-wasm-sdk` Docker image:

# Build Process
1. **Build Scripts & CI**

    - The main build script is [build.sh](./.gitlab/ci/docker/build.sh)
    - The build is orchestrated by GitLab CI using [.gitlab-ci.yml](./.gitlab-ci.yml), which defines stages: `build`, `combine`, `test`, and `publish`.
    - The build jobs use the `almalinux:8` image and run on Docker-enabled runners.

2. **Build Steps**

    - The build script clones the VTK source (default: `master` branch, customizable via environment variables).
    - It sets up build tools (CMake, Ninja, Node, Emscripten) and caches with `sccache`.
    - VTK is configured and built for WebAssembly using emcmake cmake, with options for 32/64-bit and threads.
    - The built libraries are installed into architecture-specific folders.

3. **Docker Image Creation**

    - The [combine.sh](./.gitlab/ci/docker/combine.sh) script builds the Docker image using Podman (or Docker), tagging it with the VTK version.
    - The tag is of format `${VTK_MAJOR_VERSION}.${VTK_MINOR_VERSION}.${VTK_BUILD_VERSION}` for releases and `${VTK_MAJOR_VERSION}.${VTK_MINOR_VERSION}.${VTK_BUILD_VERSION}-$(git rev-parse --short HEAD)` for weekly `dev` releases.
    - The image includes VTK built for WebAssembly, CMake, Ninja, Node, and Emscripten.
    - The image is saved as a tarball and tagged.

# Testing

1. **Test Script**

    - The [test.sh](./.gitlab/ci/docker/test.sh) script loads the built image and runs tests for each architecture (`wasm32`, `wasm32-threads`, `wasm64`, `wasm64-threads`).
    - For each architecture, it configures a test CMake project ([basic](.gitlab/ci/docker/tests/basic)), builds it, and runs tests using `ctest` inside the container.

2. **Test Project**

    - The test project is in `basic` and includes a simple C++ program ([main.cpp](./.gitlab/ci/docker/tests/basic/main.cpp)) and a CMake configuration ([CMakeLists.txt](./.gitlab/ci/docker/tests/basic/CMakeLists.txt)).
    - The program checks pointer size correctness and verifies thread count.

# Publishing

- The [push.sh](./.gitlab/ci/docker/push.sh) script loads the image, tags it as `latest`, logs into Docker Hub, and pushes both the versioned and latest tags.

# CI Rules

- The [rules.yml](./.gitlab/rules.yml) file controls when jobs run (manually, automatically, or only on merge).

# Usage

- The image is designed to allow users to build and run VTK-based C++ projects targeting WebAssembly, as described in the [README.md.](./README.md)
