#!/bin/bash
set -ex

script_dir="$(cd "$(dirname "$0")"; pwd)"
image_tag="$(cat "$script_dir/TAG")"
docker=podman

$docker image load -i "$script_dir/vtk-wasm-sdk-emscripten.tar"

run_cmake() {
    $docker run --cgroups=disabled --rm -it -v"$script_dir/tests/basic":/work/basic "localhost/kitware/vtk-wasm-sdk:$image_tag" \
        emcmake cmake -DCMAKE_CROSSCOMPILING_EMULATOR=/opt/node/bin/node "$@"
}

for build_arch in wasm32 wasm32-threads wasm64 wasm64-threads; do
    case "$build_arch" in
        wasm32)           opts=() ;;
        wasm32-threads)   opts=(-DENABLE_THREADS=ON) ;;
        wasm64)           opts=(-DCMAKE_C_FLAGS="-sMEMORY64=1") ;;
        wasm64-threads)   opts=(-DCMAKE_C_FLAGS="-sMEMORY64=1" -DENABLE_THREADS=ON) ;;
        *) echo "Unrecognized build architecture $build_arch"; exit 1 ;;
    esac

    run_cmake "${opts[@]}" -GNinja -S basic -B basic/out/$build_arch -DCMAKE_BUILD_TYPE=Release \
        -DVTK_DIR="/VTK-install/Release/$build_arch/lib/cmake/vtk"

    for cmd in "cmake --build basic/out/$build_arch" "ctest --extra-verbose --test-dir basic/out/$build_arch"; do
        $docker run --cgroups=disabled --rm -it -v"$script_dir/tests/basic":/work/basic "localhost/kitware/vtk-wasm-sdk:$image_tag" /bin/sh -c "$cmd"
    done
done

