# VTK Classes used in the Examples
## CSharp
Out of 2353 available VTK classes, 181 are demonstrated here.  
These classes are excluded since they occur in the majority of the examples:  
- [vtkActor](http://www.vtk.org/doc/nightly/html/classvtkActor)
- [vtkCamera](http://www.vtk.org/doc/nightly/html/classvtkCamera)
- [vtkProperty](http://www.vtk.org/doc/nightly/html/classvtkProperty)
- [vtkRenderer](http://www.vtk.org/doc/nightly/html/classvtkRenderer)
- [vtkRenderWindow](http://www.vtk.org/doc/nightly/html/classvtkRenderWindow)
- [vtkRenderWindowInteractor](http://www.vtk.org/doc/nightly/html/classvtkRenderWindowInteractor)

| VTK Class | Examples |
|--------------|----------------------|
| [vtkActor2D](http://www.vtk.org/doc/nightly/html/classvtkActor2D) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkAppendPolyData](http://www.vtk.org/doc/nightly/html/classvtkAppendPolyData) | [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion)  |
| [vtkArrowSource](http://www.vtk.org/doc/nightly/html/classvtkArrowSource) | [Arrow](/CSharp/GeometricObjects/Arrow) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkAxesActor](http://www.vtk.org/doc/nightly/html/classvtkAxesActor) | [Axes](/CSharp/GeometricObjects/Axes)  |
| [vtkBMPReader](http://www.vtk.org/doc/nightly/html/classvtkBMPReader) | [ReadBMP](/CSharp/IO/ReadBMP) [WriteBMP](/CSharp/IO/WriteBMP)  |
| [vtkBMPWriter](http://www.vtk.org/doc/nightly/html/classvtkBMPWriter) | [WriteBMP](/CSharp/IO/WriteBMP)  |
| [vtkButterflySubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkButterflySubdivisionFilter) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkCell](http://www.vtk.org/doc/nightly/html/classvtkCell) | [CellEdges](/CSharp/Meshes/CellEdges)  |
| [vtkCellArray](http://www.vtk.org/doc/nightly/html/classvtkCellArray) | [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [Point](/CSharp/GeometricObjects/Point) [Polygon](/CSharp/GeometricObjects/Polygon) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Pyramid](/CSharp/GeometricObjects/Pyramid) [Quad](/CSharp/GeometricObjects/Quad) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WriteVTP](/CSharp/IO/WriteVTP) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkCleanPolyData](http://www.vtk.org/doc/nightly/html/classvtkCleanPolyData) | [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours)  |
| [vtkClipPolyData](http://www.vtk.org/doc/nightly/html/classvtkClipPolyData) | [CapClip](/CSharp/Meshes/CapClip) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkConeSource](http://www.vtk.org/doc/nightly/html/classvtkConeSource) | [Cone](/CSharp/GeometricObjects/Cone) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkContourFilter](http://www.vtk.org/doc/nightly/html/classvtkContourFilter) | [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkContourWidget](http://www.vtk.org/doc/nightly/html/classvtkContourWidget) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkCubeSource](http://www.vtk.org/doc/nightly/html/classvtkCubeSource) | [Cube](/CSharp/GeometricObjects/Cube) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkCurvatures](http://www.vtk.org/doc/nightly/html/classvtkCurvatures) | [Curvature](/CSharp/PolyData/Curvature)  |
| [vtkCylinderSource](http://www.vtk.org/doc/nightly/html/classvtkCylinderSource) | [Cylinder](/CSharp/GeometricObjects/Cylinder) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkDataObject](http://www.vtk.org/doc/nightly/html/classvtkDataObject) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkDataSet](http://www.vtk.org/doc/nightly/html/classvtkDataSet) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkDataSetAttributes](http://www.vtk.org/doc/nightly/html/classvtkDataSetAttributes) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkDataSetSurfaceFilter](http://www.vtk.org/doc/nightly/html/classvtkDataSetSurfaceFilter) | [FillHoles](/CSharp/Meshes/FillHoles) [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkDecimatePro](http://www.vtk.org/doc/nightly/html/classvtkDecimatePro) | [Decimate](/CSharp/Meshes/Decimate)  |
| [vtkDelaunay2D](http://www.vtk.org/doc/nightly/html/classvtkDelaunay2D) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkDEMReader](http://www.vtk.org/doc/nightly/html/classvtkDEMReader) | [DEMReader](/CSharp/IO/DEMReader)  |
| [vtkDICOMImageReader](http://www.vtk.org/doc/nightly/html/classvtkDICOMImageReader) | [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries)  |
| [vtkDijkstraGraphGeodesicPath](http://www.vtk.org/doc/nightly/html/classvtkDijkstraGraphGeodesicPath) | [DijkstraGraphGeodesicPath](/CSharp/PolyData/DijkstraGraphGeodesicPath)  |
| [vtkDiskSource](http://www.vtk.org/doc/nightly/html/classvtkDiskSource) | [BoundaryEdges](/CSharp/Meshes/BoundaryEdges) [Disk](/CSharp/GeometricObjects/Disk) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkDoubleArray](http://www.vtk.org/doc/nightly/html/classvtkDoubleArray) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkEarthSource](http://www.vtk.org/doc/nightly/html/classvtkEarthSource) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkElevationFilter](http://www.vtk.org/doc/nightly/html/classvtkElevationFilter) | [ElevationFilter](/CSharp/Meshes/ElevationFilter)  |
| [vtkExtractEdges](http://www.vtk.org/doc/nightly/html/classvtkExtractEdges) | [ExtractEdges](/CSharp/Meshes/ExtractEdges)  |
| [vtkFeatureEdges](http://www.vtk.org/doc/nightly/html/classvtkFeatureEdges) | [BoundaryEdges](/CSharp/Meshes/BoundaryEdges) [CapClip](/CSharp/Meshes/CapClip) [ClosedSurface](/CSharp/PolyData/ClosedSurface)  |
| [vtkFieldData](http://www.vtk.org/doc/nightly/html/classvtkFieldData) | [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkFillHolesFilter](http://www.vtk.org/doc/nightly/html/classvtkFillHolesFilter) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkFloatArray](http://www.vtk.org/doc/nightly/html/classvtkFloatArray) | [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [NullPoint](/CSharp/PolyData/NullPoint) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkFrustumSource](http://www.vtk.org/doc/nightly/html/classvtkFrustumSource) | [Frustum](/CSharp/GeometricObjects/Frustum)  |
| [vtkGlyph3D](http://www.vtk.org/doc/nightly/html/classvtkGlyph3D) | [ReadPDB](/CSharp/IO/ReadPDB) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkGraphLayoutView](http://www.vtk.org/doc/nightly/html/classvtkGraphLayoutView) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkGreedyTerrainDecimation](http://www.vtk.org/doc/nightly/html/classvtkGreedyTerrainDecimation) | [GreedyTerrainDecimation](/CSharp/PolyData/GreedyTerrainDecimation)  |
| [vtkHexahedron](http://www.vtk.org/doc/nightly/html/classvtkHexahedron) | [Hexahedron](/CSharp/GeometricObjects/Hexahedron)  |
| [vtkIdList](http://www.vtk.org/doc/nightly/html/classvtkIdList) | [CellEdges](/CSharp/Meshes/CellEdges) [IterateOverLines](/CSharp/PolyData/IterateOverLines)  |
| [vtkIdTypeArray](http://www.vtk.org/doc/nightly/html/classvtkIdTypeArray) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkImageActor](http://www.vtk.org/doc/nightly/html/classvtkImageActor) | [DEMReader](/CSharp/IO/DEMReader) [ImageReader2Factory](/CSharp/IO/ImageReader2Factory) [MetaImageReader](/CSharp/IO/MetaImageReader) [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkImageCanvasSource2D](http://www.vtk.org/doc/nightly/html/classvtkImageCanvasSource2D) | [JPEGWriter](/CSharp/IO/JPEGWriter) [WriteBMP](/CSharp/IO/WriteBMP) [WritePNG](/CSharp/IO/WritePNG) [WritePNM](/CSharp/IO/WritePNM) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkImageCast](http://www.vtk.org/doc/nightly/html/classvtkImageCast) | [JPEGWriter](/CSharp/IO/JPEGWriter) [MetaImageWriter](/CSharp/IO/MetaImageWriter) [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkImageData](http://www.vtk.org/doc/nightly/html/classvtkImageData) | [GreedyTerrainDecimation](/CSharp/PolyData/GreedyTerrainDecimation) [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkImageDataGeometryFilter](http://www.vtk.org/doc/nightly/html/classvtkImageDataGeometryFilter) | [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkImageMagnitude](http://www.vtk.org/doc/nightly/html/classvtkImageMagnitude) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkImageMandelbrotSource](http://www.vtk.org/doc/nightly/html/classvtkImageMandelbrotSource) | [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkImageMapToColors](http://www.vtk.org/doc/nightly/html/classvtkImageMapToColors) | [DEMReader](/CSharp/IO/DEMReader)  |
| [vtkImageReader2Factory](http://www.vtk.org/doc/nightly/html/classvtkImageReader2Factory) | [ImageReader2Factory](/CSharp/IO/ImageReader2Factory)  |
| [vtkImageViewer2](http://www.vtk.org/doc/nightly/html/classvtkImageViewer2) | [JPEGReader](/CSharp/IO/JPEGReader) [JPEGWriter](/CSharp/IO/JPEGWriter) [PNGReader](/CSharp/IO/PNGReader) [ReadBMP](/CSharp/IO/ReadBMP) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [ReadPNM](/CSharp/IO/ReadPNM) [ReadTIFF](/CSharp/IO/ReadTIFF) [WriteBMP](/CSharp/IO/WriteBMP) [WritePNG](/CSharp/IO/WritePNG) [WritePNM](/CSharp/IO/WritePNM) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkImplicitBoolean](http://www.vtk.org/doc/nightly/html/classvtkImplicitBoolean) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean)  |
| [vtkIntArray](http://www.vtk.org/doc/nightly/html/classvtkIntArray) | [NullPoint](/CSharp/PolyData/NullPoint)  |
| [vtkInteractorStyleImage](http://www.vtk.org/doc/nightly/html/classvtkInteractorStyleImage) | [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries)  |
| [vtkJPEGReader](http://www.vtk.org/doc/nightly/html/classvtkJPEGReader) | [JPEGReader](/CSharp/IO/JPEGReader) [JPEGWriter](/CSharp/IO/JPEGWriter)  |
| [vtkJPEGWriter](http://www.vtk.org/doc/nightly/html/classvtkJPEGWriter) | [JPEGWriter](/CSharp/IO/JPEGWriter)  |
| [vtkLandmarkTransform](http://www.vtk.org/doc/nightly/html/classvtkLandmarkTransform) | [AlignFrames](/CSharp/PolyData/AlignFrames)  |
| [vtkLine](http://www.vtk.org/doc/nightly/html/classvtkLine) | [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [DistancePointToLine](/CSharp/SimpleOperations/DistancePointToLine) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkLinearSubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkLinearSubdivisionFilter) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkLineSource](http://www.vtk.org/doc/nightly/html/classvtkLineSource) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [Line](/CSharp/GeometricObjects/Line)  |
| [vtkLODActor](http://www.vtk.org/doc/nightly/html/classvtkLODActor) | [ReadPDB](/CSharp/IO/ReadPDB) [SelectPolyData](/CSharp/PolyData/SelectPolyData)  |
| [vtkLookupTable](http://www.vtk.org/doc/nightly/html/classvtkLookupTable) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [DEMReader](/CSharp/IO/DEMReader) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [PlatonicSolid](/CSharp/GeometricObjects/PlatonicSolid) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkLoopSubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkLoopSubdivisionFilter) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkMarchingCubes](http://www.vtk.org/doc/nightly/html/classvtkMarchingCubes) | [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface) [MarchingCubes](/CSharp/Modelling/MarchingCubes)  |
| [vtkMarchingSquares](http://www.vtk.org/doc/nightly/html/classvtkMarchingSquares) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkMath](http://www.vtk.org/doc/nightly/html/classvtkMath) | [AlignFrames](/CSharp/PolyData/AlignFrames) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [DistanceBetweenPoints](/CSharp/SimpleOperations/DistanceBetweenPoints) [GaussianRandomNumber](/CSharp/SimpleOperations/GaussianRandomNumber) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [UniformRandomNumber](/CSharp/SimpleOperations/UniformRandomNumber)  |
| [vtkMatrix4x4](http://www.vtk.org/doc/nightly/html/classvtkMatrix4x4) | [AlignFrames](/CSharp/PolyData/AlignFrames) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform)  |
| [vtkMatrixMathFilter](http://www.vtk.org/doc/nightly/html/classvtkMatrixMathFilter) | [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkMergePoints](http://www.vtk.org/doc/nightly/html/classvtkMergePoints) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkMeshQuality](http://www.vtk.org/doc/nightly/html/classvtkMeshQuality) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkMetaImageReader](http://www.vtk.org/doc/nightly/html/classvtkMetaImageReader) | [MetaImageReader](/CSharp/IO/MetaImageReader) [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkMetaImageWriter](http://www.vtk.org/doc/nightly/html/classvtkMetaImageWriter) | [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkMinimalStandardRandomSequence](http://www.vtk.org/doc/nightly/html/classvtkMinimalStandardRandomSequence) | [RandomSequence](/CSharp/SimpleOperations/RandomSequence)  |
| [vtkMultiBlockDataSet](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockDataSet) | [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter)  |
| [vtkMultiBlockMergeFilter](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockMergeFilter) | [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter)  |
| [vtkMultiBlockPLOT3DReader](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockPLOT3DReader) | [ReadPLOT3D](/CSharp/IO/ReadPLOT3D)  |
| [vtkOBBDicer](http://www.vtk.org/doc/nightly/html/classvtkOBBDicer) | [OBBDicer](/CSharp/Meshes/OBBDicer)  |
| [vtkOBJReader](http://www.vtk.org/doc/nightly/html/classvtkOBJReader) | [ReadOBJ](/CSharp/IO/ReadOBJ)  |
| [vtkOrientedGlyphContourRepresentation](http://www.vtk.org/doc/nightly/html/classvtkOrientedGlyphContourRepresentation) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkOutlineCornerFilter](http://www.vtk.org/doc/nightly/html/classvtkOutlineCornerFilter) | [OBBDicer](/CSharp/Meshes/OBBDicer)  |
| [vtkOutlineFilter](http://www.vtk.org/doc/nightly/html/classvtkOutlineFilter) | [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkParametricBoy](http://www.vtk.org/doc/nightly/html/classvtkParametricBoy) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricConicSpiral](http://www.vtk.org/doc/nightly/html/classvtkParametricConicSpiral) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricCrossCap](http://www.vtk.org/doc/nightly/html/classvtkParametricCrossCap) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricDini](http://www.vtk.org/doc/nightly/html/classvtkParametricDini) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricEllipsoid](http://www.vtk.org/doc/nightly/html/classvtkParametricEllipsoid) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricEnneper](http://www.vtk.org/doc/nightly/html/classvtkParametricEnneper) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFigure8Klein](http://www.vtk.org/doc/nightly/html/classvtkParametricFigure8Klein) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFunction](http://www.vtk.org/doc/nightly/html/classvtkParametricFunction) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFunctionSource](http://www.vtk.org/doc/nightly/html/classvtkParametricFunctionSource) | [ParametricObjects](/CSharp/GeometricObjects/ParametricObjects) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricKlein](http://www.vtk.org/doc/nightly/html/classvtkParametricKlein) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricMobius](http://www.vtk.org/doc/nightly/html/classvtkParametricMobius) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricRandomHills](http://www.vtk.org/doc/nightly/html/classvtkParametricRandomHills) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricRoman](http://www.vtk.org/doc/nightly/html/classvtkParametricRoman) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSpline](http://www.vtk.org/doc/nightly/html/classvtkParametricSpline) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSuperEllipsoid](http://www.vtk.org/doc/nightly/html/classvtkParametricSuperEllipsoid) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSuperToroid](http://www.vtk.org/doc/nightly/html/classvtkParametricSuperToroid) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricTorus](http://www.vtk.org/doc/nightly/html/classvtkParametricTorus) | [ParametricObjects](/CSharp/GeometricObjects/ParametricObjects) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParticleReader](http://www.vtk.org/doc/nightly/html/classvtkParticleReader) | [ParticleReader](/CSharp/IO/ParticleReader)  |
| [vtkPDBReader](http://www.vtk.org/doc/nightly/html/classvtkPDBReader) | [ReadPDB](/CSharp/IO/ReadPDB)  |
| [vtkPerspectiveTransform](http://www.vtk.org/doc/nightly/html/classvtkPerspectiveTransform) | [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform)  |
| [vtkPlane](http://www.vtk.org/doc/nightly/html/classvtkPlane) | [CapClip](/CSharp/Meshes/CapClip) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [ProjectPointPlane](/CSharp/SimpleOperations/ProjectPointPlane) [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkPlanes](http://www.vtk.org/doc/nightly/html/classvtkPlanes) | [Frustum](/CSharp/GeometricObjects/Frustum) [Planes](/CSharp/GeometricObjects/Planes)  |
| [vtkPlaneSource](http://www.vtk.org/doc/nightly/html/classvtkPlaneSource) | [Plane](/CSharp/GeometricObjects/Plane)  |
| [vtkPlatonicSolidSource](http://www.vtk.org/doc/nightly/html/classvtkPlatonicSolidSource) | [PlatonicSolid](/CSharp/GeometricObjects/PlatonicSolid)  |
| [vtkPLYReader](http://www.vtk.org/doc/nightly/html/classvtkPLYReader) | [ReadPLY](/CSharp/IO/ReadPLY)  |
| [vtkPLYWriter](http://www.vtk.org/doc/nightly/html/classvtkPLYWriter) | [ConvertFile](/CSharp/IO/ConvertFile)  |
| [vtkPNGReader](http://www.vtk.org/doc/nightly/html/classvtkPNGReader) | [PNGReader](/CSharp/IO/PNGReader) [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkPNGWriter](http://www.vtk.org/doc/nightly/html/classvtkPNGWriter) | [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkPNMReader](http://www.vtk.org/doc/nightly/html/classvtkPNMReader) | [ReadPNM](/CSharp/IO/ReadPNM) [WritePNM](/CSharp/IO/WritePNM)  |
| [vtkPNMWriter](http://www.vtk.org/doc/nightly/html/classvtkPNMWriter) | [WritePNM](/CSharp/IO/WritePNM)  |
| [vtkPoints](http://www.vtk.org/doc/nightly/html/classvtkPoints) | [AlignFrames](/CSharp/PolyData/AlignFrames) [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [NullPoint](/CSharp/PolyData/NullPoint) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [PlanesIntersection](/CSharp/GeometricObjects/PlanesIntersection) [Point](/CSharp/GeometricObjects/Point) [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonIntersection](/CSharp/GeometricObjects/PolygonIntersection) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Pyramid](/CSharp/GeometricObjects/Pyramid) [Quad](/CSharp/GeometricObjects/Quad) [ReadPlainText](/CSharp/IO/ReadPlainText) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WriteVTP](/CSharp/IO/WriteVTP) [WriteVTU](/CSharp/IO/WriteVTU) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkPolyData](http://www.vtk.org/doc/nightly/html/classvtkPolyData) | [AlignFrames](/CSharp/PolyData/AlignFrames) [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [CapClip](/CSharp/Meshes/CapClip) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [Decimate](/CSharp/Meshes/Decimate) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [Frustum](/CSharp/GeometricObjects/Frustum) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [NullPoint](/CSharp/PolyData/NullPoint) [OBBDicer](/CSharp/Meshes/OBBDicer) [Point](/CSharp/GeometricObjects/Point) [PolyDataGetPoint](/CSharp/PolyData/PolyDataGetPoint) [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Quad](/CSharp/GeometricObjects/Quad) [QuadricClustering](/CSharp/Meshes/QuadricClustering) [QuadricDecimation](/CSharp/Meshes/QuadricDecimation) [ReadPlainText](/CSharp/IO/ReadPlainText) [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [Subdivision](/CSharp/Meshes/Subdivision) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkPolyDataAlgorithm](http://www.vtk.org/doc/nightly/html/classvtkPolyDataAlgorithm) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkPolyDataConnectivityFilter](http://www.vtk.org/doc/nightly/html/classvtkPolyDataConnectivityFilter) | [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion)  |
| [vtkPolygon](http://www.vtk.org/doc/nightly/html/classvtkPolygon) | [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonIntersection](/CSharp/GeometricObjects/PolygonIntersection)  |
| [vtkPolygonalSurfaceContourLineInterpolator](http://www.vtk.org/doc/nightly/html/classvtkPolygonalSurfaceContourLineInterpolator) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkPolygonalSurfacePointPlacer](http://www.vtk.org/doc/nightly/html/classvtkPolygonalSurfacePointPlacer) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkPolyLine](http://www.vtk.org/doc/nightly/html/classvtkPolyLine) | [PolyLine](/CSharp/GeometricObjects/PolyLine)  |
| [vtkPyramid](http://www.vtk.org/doc/nightly/html/classvtkPyramid) | [Pyramid](/CSharp/GeometricObjects/Pyramid)  |
| [vtkQuad](http://www.vtk.org/doc/nightly/html/classvtkQuad) | [Quad](/CSharp/GeometricObjects/Quad)  |
| [vtkQuadricClustering](http://www.vtk.org/doc/nightly/html/classvtkQuadricClustering) | [QuadricClustering](/CSharp/Meshes/QuadricClustering)  |
| [vtkQuadricDecimation](http://www.vtk.org/doc/nightly/html/classvtkQuadricDecimation) | [QuadricDecimation](/CSharp/Meshes/QuadricDecimation)  |
| [vtkRegularPolygonSource](http://www.vtk.org/doc/nightly/html/classvtkRegularPolygonSource) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [RegularPolygonSource](/CSharp/GeometricObjects/RegularPolygonSource) [Triangulate](/CSharp/Meshes/Triangulate)  |
| [vtkSampleFunction](http://www.vtk.org/doc/nightly/html/classvtkSampleFunction) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkSelection](http://www.vtk.org/doc/nightly/html/classvtkSelection) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkSelectionNode](http://www.vtk.org/doc/nightly/html/classvtkSelectionNode) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkSelectPolyData](http://www.vtk.org/doc/nightly/html/classvtkSelectPolyData) | [SelectPolyData](/CSharp/PolyData/SelectPolyData)  |
| [vtkShrinkPolyData](http://www.vtk.org/doc/nightly/html/classvtkShrinkPolyData) | [ShrinkPolyData](/CSharp/PolyData/ShrinkPolyData)  |
| [vtkSimpleElevationFilter](http://www.vtk.org/doc/nightly/html/classvtkSimpleElevationFilter) | [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkSimplePointsReader](http://www.vtk.org/doc/nightly/html/classvtkSimplePointsReader) | [SimplePointsReader](/CSharp/IO/SimplePointsReader)  |
| [vtkSphere](http://www.vtk.org/doc/nightly/html/classvtkSphere) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkSphereSource](http://www.vtk.org/doc/nightly/html/classvtkSphereSource) | [Axes](/CSharp/GeometricObjects/Axes) [CapClip](/CSharp/Meshes/CapClip) [ClosedSurface](/CSharp/PolyData/ClosedSurface) [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [Decimate](/CSharp/Meshes/Decimate) [DijkstraGraphGeodesicPath](/CSharp/PolyData/DijkstraGraphGeodesicPath) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [MarchingCubes](/CSharp/Modelling/MarchingCubes) [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter) [OBBDicer](/CSharp/Meshes/OBBDicer) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [Planes](/CSharp/GeometricObjects/Planes) [PlanesIntersection](/CSharp/GeometricObjects/PlanesIntersection) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion) [PolyDataGetPoint](/CSharp/PolyData/PolyDataGetPoint) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [QuadricClustering](/CSharp/Meshes/QuadricClustering) [QuadricDecimation](/CSharp/Meshes/QuadricDecimation) [ReadPDB](/CSharp/IO/ReadPDB) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [ShrinkPolyData](/CSharp/PolyData/ShrinkPolyData) [Sphere](/CSharp/GeometricObjects/Sphere) [Subdivision](/CSharp/Meshes/Subdivision) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter) [WindowedSincPolyDataFilter](/CSharp/Meshes/WindowedSincPolyDataFilter)  |
| [vtkSTLReader](http://www.vtk.org/doc/nightly/html/classvtkSTLReader) | [ReadSTL](/CSharp/IO/ReadSTL)  |
| [vtkStripper](http://www.vtk.org/doc/nightly/html/classvtkStripper) | [CapClip](/CSharp/Meshes/CapClip)  |
| [vtkStructuredGrid](http://www.vtk.org/doc/nightly/html/classvtkStructuredGrid) | [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkStructuredGridGeometryFilter](http://www.vtk.org/doc/nightly/html/classvtkStructuredGridGeometryFilter) | [ReadPLOT3D](/CSharp/IO/ReadPLOT3D) [ReadStructuredGrid](/CSharp/IO/ReadStructuredGrid) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkStructuredPointsReader](http://www.vtk.org/doc/nightly/html/classvtkStructuredPointsReader) | [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface)  |
| [vtkSuperquadricSource](http://www.vtk.org/doc/nightly/html/classvtkSuperquadricSource) | [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkTetra](http://www.vtk.org/doc/nightly/html/classvtkTetra) | [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkTextMapper](http://www.vtk.org/doc/nightly/html/classvtkTextMapper) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkTextProperty](http://www.vtk.org/doc/nightly/html/classvtkTextProperty) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkThreshold](http://www.vtk.org/doc/nightly/html/classvtkThreshold) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkThresholdPoints](http://www.vtk.org/doc/nightly/html/classvtkThresholdPoints) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkTIFFReader](http://www.vtk.org/doc/nightly/html/classvtkTIFFReader) | [ReadTIFF](/CSharp/IO/ReadTIFF) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkTIFFWriter](http://www.vtk.org/doc/nightly/html/classvtkTIFFWriter) | [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkTransform](http://www.vtk.org/doc/nightly/html/classvtkTransform) | [AlignFrames](/CSharp/PolyData/AlignFrames) [Axes](/CSharp/GeometricObjects/Axes) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkTransformFilter](http://www.vtk.org/doc/nightly/html/classvtkTransformFilter) | [AlignFrames](/CSharp/PolyData/AlignFrames) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkTransformPolyDataFilter](http://www.vtk.org/doc/nightly/html/classvtkTransformPolyDataFilter) | [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow)  |
| [vtkTriangle](http://www.vtk.org/doc/nightly/html/classvtkTriangle) | [CellEdges](/CSharp/Meshes/CellEdges) [Triangle](/CSharp/GeometricObjects/Triangle) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkTriangleFilter](http://www.vtk.org/doc/nightly/html/classvtkTriangleFilter) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [Subdivision](/CSharp/Meshes/Subdivision) [Triangulate](/CSharp/Meshes/Triangulate)  |
| [vtkTriangleStrip](http://www.vtk.org/doc/nightly/html/classvtkTriangleStrip) | [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip)  |
| [vtkTubeFilter](http://www.vtk.org/doc/nightly/html/classvtkTubeFilter) | [ReadPDB](/CSharp/IO/ReadPDB)  |
| [vtkUndirectedGraph](http://www.vtk.org/doc/nightly/html/classvtkUndirectedGraph) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkUnsignedCharArray](http://www.vtk.org/doc/nightly/html/classvtkUnsignedCharArray) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkUnstructuredGrid](http://www.vtk.org/doc/nightly/html/classvtkUnstructuredGrid) | [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [Pyramid](/CSharp/GeometricObjects/Pyramid) [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkUnstructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkUnstructuredGridReader) | [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkVertex](http://www.vtk.org/doc/nightly/html/classvtkVertex) | [Vertex](/CSharp/GeometricObjects/Vertex)  |
| [vtkVolume16Reader](http://www.vtk.org/doc/nightly/html/classvtkVolume16Reader) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkVoxelModeller](http://www.vtk.org/doc/nightly/html/classvtkVoxelModeller) | [MarchingCubes](/CSharp/Modelling/MarchingCubes)  |
| [vtkVRMLImporter](http://www.vtk.org/doc/nightly/html/classvtkVRMLImporter) | [VRML](/CSharp/IO/VRML)  |
| [vtkWarpVector](http://www.vtk.org/doc/nightly/html/classvtkWarpVector) | [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkWeightedTransformFilter](http://www.vtk.org/doc/nightly/html/classvtkWeightedTransformFilter) | [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkWindowedSincPolyDataFilter](http://www.vtk.org/doc/nightly/html/classvtkWindowedSincPolyDataFilter) | [WindowedSincPolyDataFilter](/CSharp/Meshes/WindowedSincPolyDataFilter)  |
| [vtkXGMLReader](http://www.vtk.org/doc/nightly/html/classvtkXGMLReader) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkXMLGenericDataObjectReader](http://www.vtk.org/doc/nightly/html/classvtkXMLGenericDataObjectReader) | [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile)  |
| [vtkXMLImageDataReader](http://www.vtk.org/doc/nightly/html/classvtkXMLImageDataReader) | [ReadImageData](/CSharp/IO/ReadImageData) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkXMLImageDataWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLImageDataWriter) | [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkXMLPolyDataReader](http://www.vtk.org/doc/nightly/html/classvtkXMLPolyDataReader) | [CapClip](/CSharp/Meshes/CapClip) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [ConvertFile](/CSharp/IO/ConvertFile) [Curvature](/CSharp/PolyData/Curvature) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [OBBDicer](/CSharp/Meshes/OBBDicer) [ReadPolyData](/CSharp/IO/ReadPolyData) [Subdivision](/CSharp/Meshes/Subdivision) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkXMLPolyDataWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLPolyDataWriter) | [AlignFrames](/CSharp/PolyData/AlignFrames) [Curvature](/CSharp/PolyData/Curvature) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkXMLRectilinearGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLRectilinearGridReader) | [ReadRectilinearGrid](/CSharp/IO/ReadRectilinearGrid)  |
| [vtkXMLStructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLStructuredGridReader) | [ReadStructuredGrid](/CSharp/IO/ReadStructuredGrid) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkXMLStructuredGridWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLStructuredGridWriter) | [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkXMLUnstructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLUnstructuredGridReader) | [ReadUnstructuredGrid](/CSharp/IO/ReadUnstructuredGrid) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkXMLUnstructuredGridWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLUnstructuredGridWriter) | [WriteVTU](/CSharp/IO/WriteVTU)  |
