# VTK Classes used in the Examples

## CSharp

Out of 2800 available VTK classes, 188 are demonstrated here.

### Excluded classes

These classes are excluded since they occur in the majority of the examples:

| VTK Class | VTK Class | VTK Class |
|-----------|-----------|-----------|
| [vtkActor](http://www.vtk.org/doc/nightly/html/classvtkActor.html#details) | [vtkCamera](http://www.vtk.org/doc/nightly/html/classvtkCamera.html#details) | [vtkNamedColors](http://www.vtk.org/doc/nightly/html/classvtkNamedColors.html#details) |
| [vtkPolyDataMapper](http://www.vtk.org/doc/nightly/html/classvtkPolyDataMapper.html#details) | [vtkProperty](http://www.vtk.org/doc/nightly/html/classvtkProperty.html#details) | [vtkRenderer](http://www.vtk.org/doc/nightly/html/classvtkRenderer.html#details) |
| [vtkRenderWindow](http://www.vtk.org/doc/nightly/html/classvtkRenderWindow.html#details) | [vtkRenderWindowInteractor](http://www.vtk.org/doc/nightly/html/classvtkRenderWindowInteractor.html#details) |  |

### Classes used

| VTK Class | Examples |
|--------------|----------------------|
| [vtkActor2D](http://www.vtk.org/doc/nightly/html/classvtkActor2D.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkAppendPolyData](http://www.vtk.org/doc/nightly/html/classvtkAppendPolyData.html#details) | [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion)  |
| [vtkArrowSource](http://www.vtk.org/doc/nightly/html/classvtkArrowSource.html#details) | [Arrow](/CSharp/GeometricObjects/Arrow) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkAxesActor](http://www.vtk.org/doc/nightly/html/classvtkAxesActor.html#details) | [Axes](/CSharp/GeometricObjects/Axes)  |
| [vtkBandedPolyDataContourFilter](http://www.vtk.org/doc/nightly/html/classvtkBandedPolyDataContourFilter.html#details) | [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter)  |
| [vtkBMPReader](http://www.vtk.org/doc/nightly/html/classvtkBMPReader.html#details) | [ReadBMP](/CSharp/IO/ReadBMP) [WriteBMP](/CSharp/IO/WriteBMP)  |
| [vtkBMPWriter](http://www.vtk.org/doc/nightly/html/classvtkBMPWriter.html#details) | [WriteBMP](/CSharp/IO/WriteBMP)  |
| [vtkButterflySubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkButterflySubdivisionFilter.html#details) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkCell](http://www.vtk.org/doc/nightly/html/classvtkCell.html#details) | [CellEdges](/CSharp/Meshes/CellEdges)  |
| [vtkCellArray](http://www.vtk.org/doc/nightly/html/classvtkCellArray.html#details) | [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [Point](/CSharp/GeometricObjects/Point) [Polygon](/CSharp/GeometricObjects/Polygon) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Pyramid](/CSharp/GeometricObjects/Pyramid) [Quad](/CSharp/GeometricObjects/Quad) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WriteVTP](/CSharp/IO/WriteVTP) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkCleanPolyData](http://www.vtk.org/doc/nightly/html/classvtkCleanPolyData.html#details) | [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours)  |
| [vtkClipPolyData](http://www.vtk.org/doc/nightly/html/classvtkClipPolyData.html#details) | [CapClip](/CSharp/Meshes/CapClip) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkConeSource](http://www.vtk.org/doc/nightly/html/classvtkConeSource.html#details) | [Cone](/CSharp/GeometricObjects/Cone) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkContourFilter](http://www.vtk.org/doc/nightly/html/classvtkContourFilter.html#details) | [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkContourWidget](http://www.vtk.org/doc/nightly/html/classvtkContourWidget.html#details) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkCubeSource](http://www.vtk.org/doc/nightly/html/classvtkCubeSource.html#details) | [Cube](/CSharp/GeometricObjects/Cube) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkCurvatures](http://www.vtk.org/doc/nightly/html/classvtkCurvatures.html#details) | [Curvature](/CSharp/PolyData/Curvature)  |
| [vtkCutter](http://www.vtk.org/doc/nightly/html/classvtkCutter.html#details) | [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData)  |
| [vtkCylinderSource](http://www.vtk.org/doc/nightly/html/classvtkCylinderSource.html#details) | [Cylinder](/CSharp/GeometricObjects/Cylinder) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkDataObject](http://www.vtk.org/doc/nightly/html/classvtkDataObject.html#details) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkDataSet](http://www.vtk.org/doc/nightly/html/classvtkDataSet.html#details) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkDataSetAttributes](http://www.vtk.org/doc/nightly/html/classvtkDataSetAttributes.html#details) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkDataSetMapper](http://www.vtk.org/doc/nightly/html/classvtkDataSetMapper.html#details) | [CapClip](/CSharp/Meshes/CapClip) [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [Pyramid](/CSharp/GeometricObjects/Pyramid) [ReadImageData](/CSharp/IO/ReadImageData) [ReadPolyData](/CSharp/IO/ReadPolyData) [ReadRectilinearGrid](/CSharp/IO/ReadRectilinearGrid) [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile) [ReadUnstructuredGrid](/CSharp/IO/ReadUnstructuredGrid) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [WriteVTI](/CSharp/IO/WriteVTI) [WriteVTP](/CSharp/IO/WriteVTP) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkDataSetSurfaceFilter](http://www.vtk.org/doc/nightly/html/classvtkDataSetSurfaceFilter.html#details) | [FillHoles](/CSharp/Meshes/FillHoles) [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkDecimatePro](http://www.vtk.org/doc/nightly/html/classvtkDecimatePro.html#details) | [Decimate](/CSharp/Meshes/Decimate)  |
| [vtkDelaunay2D](http://www.vtk.org/doc/nightly/html/classvtkDelaunay2D.html#details) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkDEMReader](http://www.vtk.org/doc/nightly/html/classvtkDEMReader.html#details) | [DEMReader](/CSharp/IO/DEMReader)  |
| [vtkDICOMImageReader](http://www.vtk.org/doc/nightly/html/classvtkDICOMImageReader.html#details) | [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries)  |
| [vtkDijkstraGraphGeodesicPath](http://www.vtk.org/doc/nightly/html/classvtkDijkstraGraphGeodesicPath.html#details) | [DijkstraGraphGeodesicPath](/CSharp/PolyData/DijkstraGraphGeodesicPath)  |
| [vtkDiskSource](http://www.vtk.org/doc/nightly/html/classvtkDiskSource.html#details) | [BoundaryEdges](/CSharp/Meshes/BoundaryEdges) [Disk](/CSharp/GeometricObjects/Disk) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkDoubleArray](http://www.vtk.org/doc/nightly/html/classvtkDoubleArray.html#details) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkEarthSource](http://www.vtk.org/doc/nightly/html/classvtkEarthSource.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo)  |
| [vtkElevationFilter](http://www.vtk.org/doc/nightly/html/classvtkElevationFilter.html#details) | [ElevationFilter](/CSharp/Meshes/ElevationFilter)  |
| [vtkExtractEdges](http://www.vtk.org/doc/nightly/html/classvtkExtractEdges.html#details) | [ExtractEdges](/CSharp/Meshes/ExtractEdges)  |
| [vtkExtractSelection](http://www.vtk.org/doc/nightly/html/classvtkExtractSelection.html#details) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkFeatureEdges](http://www.vtk.org/doc/nightly/html/classvtkFeatureEdges.html#details) | [BoundaryEdges](/CSharp/Meshes/BoundaryEdges) [CapClip](/CSharp/Meshes/CapClip) [ClosedSurface](/CSharp/PolyData/ClosedSurface)  |
| [vtkFieldData](http://www.vtk.org/doc/nightly/html/classvtkFieldData.html#details) | [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkFillHolesFilter](http://www.vtk.org/doc/nightly/html/classvtkFillHolesFilter.html#details) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkFloatArray](http://www.vtk.org/doc/nightly/html/classvtkFloatArray.html#details) | [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [NullPoint](/CSharp/PolyData/NullPoint) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkFrustumSource](http://www.vtk.org/doc/nightly/html/classvtkFrustumSource.html#details) | [Frustum](/CSharp/GeometricObjects/Frustum)  |
| [vtkGlyph3D](http://www.vtk.org/doc/nightly/html/classvtkGlyph3D.html#details) | [ReadPDB](/CSharp/IO/ReadPDB) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkGraphLayoutView](http://www.vtk.org/doc/nightly/html/classvtkGraphLayoutView.html#details) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkGreedyTerrainDecimation](http://www.vtk.org/doc/nightly/html/classvtkGreedyTerrainDecimation.html#details) | [GreedyTerrainDecimation](/CSharp/PolyData/GreedyTerrainDecimation)  |
| [vtkHexahedron](http://www.vtk.org/doc/nightly/html/classvtkHexahedron.html#details) | [Hexahedron](/CSharp/GeometricObjects/Hexahedron)  |
| [vtkIdList](http://www.vtk.org/doc/nightly/html/classvtkIdList.html#details) | [CellEdges](/CSharp/Meshes/CellEdges) [IterateOverLines](/CSharp/PolyData/IterateOverLines)  |
| [vtkIdTypeArray](http://www.vtk.org/doc/nightly/html/classvtkIdTypeArray.html#details) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkImageActor](http://www.vtk.org/doc/nightly/html/classvtkImageActor.html#details) | [DEMReader](/CSharp/IO/DEMReader) [ImageReader2Factory](/CSharp/IO/ImageReader2Factory) [MetaImageReader](/CSharp/IO/MetaImageReader) [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkImageCanvasSource2D](http://www.vtk.org/doc/nightly/html/classvtkImageCanvasSource2D.html#details) | [JPEGWriter](/CSharp/IO/JPEGWriter) [WriteBMP](/CSharp/IO/WriteBMP) [WritePNG](/CSharp/IO/WritePNG) [WritePNM](/CSharp/IO/WritePNM) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkImageCast](http://www.vtk.org/doc/nightly/html/classvtkImageCast.html#details) | [JPEGWriter](/CSharp/IO/JPEGWriter) [MetaImageWriter](/CSharp/IO/MetaImageWriter) [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkImageData](http://www.vtk.org/doc/nightly/html/classvtkImageData.html#details) | [GreedyTerrainDecimation](/CSharp/PolyData/GreedyTerrainDecimation) [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkImageDataGeometryFilter](http://www.vtk.org/doc/nightly/html/classvtkImageDataGeometryFilter.html#details) | [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkImageMagnitude](http://www.vtk.org/doc/nightly/html/classvtkImageMagnitude.html#details) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkImageMandelbrotSource](http://www.vtk.org/doc/nightly/html/classvtkImageMandelbrotSource.html#details) | [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkImageMapToColors](http://www.vtk.org/doc/nightly/html/classvtkImageMapToColors.html#details) | [DEMReader](/CSharp/IO/DEMReader)  |
| [vtkImageReader2Factory](http://www.vtk.org/doc/nightly/html/classvtkImageReader2Factory.html#details) | [ImageReader2Factory](/CSharp/IO/ImageReader2Factory)  |
| [vtkImageViewer2](http://www.vtk.org/doc/nightly/html/classvtkImageViewer2.html#details) | [JPEGReader](/CSharp/IO/JPEGReader) [JPEGWriter](/CSharp/IO/JPEGWriter) [PNGReader](/CSharp/IO/PNGReader) [ReadBMP](/CSharp/IO/ReadBMP) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [ReadPNM](/CSharp/IO/ReadPNM) [ReadTIFF](/CSharp/IO/ReadTIFF) [WriteBMP](/CSharp/IO/WriteBMP) [WritePNG](/CSharp/IO/WritePNG) [WritePNM](/CSharp/IO/WritePNM) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkImplicitBoolean](http://www.vtk.org/doc/nightly/html/classvtkImplicitBoolean.html#details) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean)  |
| [vtkIntArray](http://www.vtk.org/doc/nightly/html/classvtkIntArray.html#details) | [NullPoint](/CSharp/PolyData/NullPoint)  |
| [vtkInteractorStyleImage](http://www.vtk.org/doc/nightly/html/classvtkInteractorStyleImage.html#details) | [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries)  |
| [vtkJPEGReader](http://www.vtk.org/doc/nightly/html/classvtkJPEGReader.html#details) | [JPEGReader](/CSharp/IO/JPEGReader) [JPEGWriter](/CSharp/IO/JPEGWriter)  |
| [vtkJPEGWriter](http://www.vtk.org/doc/nightly/html/classvtkJPEGWriter.html#details) | [JPEGWriter](/CSharp/IO/JPEGWriter)  |
| [vtkLandmarkTransform](http://www.vtk.org/doc/nightly/html/classvtkLandmarkTransform.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames)  |
| [vtkLine](http://www.vtk.org/doc/nightly/html/classvtkLine.html#details) | [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [DistancePointToLine](/CSharp/SimpleOperations/DistancePointToLine) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkLinearSubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkLinearSubdivisionFilter.html#details) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkLineSource](http://www.vtk.org/doc/nightly/html/classvtkLineSource.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [Line](/CSharp/GeometricObjects/Line)  |
| [vtkLODActor](http://www.vtk.org/doc/nightly/html/classvtkLODActor.html#details) | [ReadPDB](/CSharp/IO/ReadPDB) [SelectPolyData](/CSharp/PolyData/SelectPolyData)  |
| [vtkLookupTable](http://www.vtk.org/doc/nightly/html/classvtkLookupTable.html#details) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [DEMReader](/CSharp/IO/DEMReader) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [PlatonicSolid](/CSharp/GeometricObjects/PlatonicSolid) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkLoopSubdivisionFilter](http://www.vtk.org/doc/nightly/html/classvtkLoopSubdivisionFilter.html#details) | [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkMarchingCubes](http://www.vtk.org/doc/nightly/html/classvtkMarchingCubes.html#details) | [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface) [MarchingCubes](/CSharp/Modelling/MarchingCubes)  |
| [vtkMarchingSquares](http://www.vtk.org/doc/nightly/html/classvtkMarchingSquares.html#details) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkMath](http://www.vtk.org/doc/nightly/html/classvtkMath.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [DistanceBetweenPoints](/CSharp/SimpleOperations/DistanceBetweenPoints) [GaussianRandomNumber](/CSharp/SimpleOperations/GaussianRandomNumber) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [UniformRandomNumber](/CSharp/SimpleOperations/UniformRandomNumber)  |
| [vtkMatrix4x4](http://www.vtk.org/doc/nightly/html/classvtkMatrix4x4.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform)  |
| [vtkMatrixMathFilter](http://www.vtk.org/doc/nightly/html/classvtkMatrixMathFilter.html#details) | [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkMergePoints](http://www.vtk.org/doc/nightly/html/classvtkMergePoints.html#details) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkMeshQuality](http://www.vtk.org/doc/nightly/html/classvtkMeshQuality.html#details) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkMetaImageReader](http://www.vtk.org/doc/nightly/html/classvtkMetaImageReader.html#details) | [MetaImageReader](/CSharp/IO/MetaImageReader) [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkMetaImageWriter](http://www.vtk.org/doc/nightly/html/classvtkMetaImageWriter.html#details) | [MetaImageWriter](/CSharp/IO/MetaImageWriter)  |
| [vtkMinimalStandardRandomSequence](http://www.vtk.org/doc/nightly/html/classvtkMinimalStandardRandomSequence.html#details) | [RandomSequence](/CSharp/SimpleOperations/RandomSequence)  |
| [vtkMultiBlockDataSet](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockDataSet.html#details) | [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter)  |
| [vtkMultiBlockMergeFilter](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockMergeFilter.html#details) | [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter)  |
| [vtkMultiBlockPLOT3DReader](http://www.vtk.org/doc/nightly/html/classvtkMultiBlockPLOT3DReader.html#details) | [ReadPLOT3D](/CSharp/IO/ReadPLOT3D)  |
| [vtkOBBDicer](http://www.vtk.org/doc/nightly/html/classvtkOBBDicer.html#details) | [OBBDicer](/CSharp/Meshes/OBBDicer)  |
| [vtkOBJReader](http://www.vtk.org/doc/nightly/html/classvtkOBJReader.html#details) | [ReadOBJ](/CSharp/IO/ReadOBJ)  |
| [vtkOrientedGlyphContourRepresentation](http://www.vtk.org/doc/nightly/html/classvtkOrientedGlyphContourRepresentation.html#details) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkOutlineCornerFilter](http://www.vtk.org/doc/nightly/html/classvtkOutlineCornerFilter.html#details) | [OBBDicer](/CSharp/Meshes/OBBDicer)  |
| [vtkOutlineFilter](http://www.vtk.org/doc/nightly/html/classvtkOutlineFilter.html#details) | [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkParametricBoy](http://www.vtk.org/doc/nightly/html/classvtkParametricBoy.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricConicSpiral](http://www.vtk.org/doc/nightly/html/classvtkParametricConicSpiral.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricCrossCap](http://www.vtk.org/doc/nightly/html/classvtkParametricCrossCap.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricDini](http://www.vtk.org/doc/nightly/html/classvtkParametricDini.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricEllipsoid](http://www.vtk.org/doc/nightly/html/classvtkParametricEllipsoid.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricEnneper](http://www.vtk.org/doc/nightly/html/classvtkParametricEnneper.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFigure8Klein](http://www.vtk.org/doc/nightly/html/classvtkParametricFigure8Klein.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFunction](http://www.vtk.org/doc/nightly/html/classvtkParametricFunction.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricFunctionSource](http://www.vtk.org/doc/nightly/html/classvtkParametricFunctionSource.html#details) | [ParametricObjects](/CSharp/GeometricObjects/ParametricObjects) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricKlein](http://www.vtk.org/doc/nightly/html/classvtkParametricKlein.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricMobius](http://www.vtk.org/doc/nightly/html/classvtkParametricMobius.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricRandomHills](http://www.vtk.org/doc/nightly/html/classvtkParametricRandomHills.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricRoman](http://www.vtk.org/doc/nightly/html/classvtkParametricRoman.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSpline](http://www.vtk.org/doc/nightly/html/classvtkParametricSpline.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSuperEllipsoid](http://www.vtk.org/doc/nightly/html/classvtkParametricSuperEllipsoid.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricSuperToroid](http://www.vtk.org/doc/nightly/html/classvtkParametricSuperToroid.html#details) | [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParametricTorus](http://www.vtk.org/doc/nightly/html/classvtkParametricTorus.html#details) | [ParametricObjects](/CSharp/GeometricObjects/ParametricObjects) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo)  |
| [vtkParticleReader](http://www.vtk.org/doc/nightly/html/classvtkParticleReader.html#details) | [ParticleReader](/CSharp/IO/ParticleReader)  |
| [vtkPDBReader](http://www.vtk.org/doc/nightly/html/classvtkPDBReader.html#details) | [ReadPDB](/CSharp/IO/ReadPDB)  |
| [vtkPerspectiveTransform](http://www.vtk.org/doc/nightly/html/classvtkPerspectiveTransform.html#details) | [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform)  |
| [vtkPlane](http://www.vtk.org/doc/nightly/html/classvtkPlane.html#details) | [CapClip](/CSharp/Meshes/CapClip) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [ProjectPointPlane](/CSharp/SimpleOperations/ProjectPointPlane) [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkPlanes](http://www.vtk.org/doc/nightly/html/classvtkPlanes.html#details) | [Frustum](/CSharp/GeometricObjects/Frustum) [Planes](/CSharp/GeometricObjects/Planes)  |
| [vtkPlanesIntersection](http://www.vtk.org/doc/nightly/html/classvtkPlanesIntersection.html#details) | [PlanesIntersection](/CSharp/GeometricObjects/PlanesIntersection)  |
| [vtkPlaneSource](http://www.vtk.org/doc/nightly/html/classvtkPlaneSource.html#details) | [Plane](/CSharp/GeometricObjects/Plane)  |
| [vtkPlatonicSolidSource](http://www.vtk.org/doc/nightly/html/classvtkPlatonicSolidSource.html#details) | [PlatonicSolid](/CSharp/GeometricObjects/PlatonicSolid)  |
| [vtkPLYReader](http://www.vtk.org/doc/nightly/html/classvtkPLYReader.html#details) | [ReadPLY](/CSharp/IO/ReadPLY)  |
| [vtkPLYWriter](http://www.vtk.org/doc/nightly/html/classvtkPLYWriter.html#details) | [ConvertFile](/CSharp/IO/ConvertFile)  |
| [vtkPNGReader](http://www.vtk.org/doc/nightly/html/classvtkPNGReader.html#details) | [PNGReader](/CSharp/IO/PNGReader) [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkPNGWriter](http://www.vtk.org/doc/nightly/html/classvtkPNGWriter.html#details) | [WritePNG](/CSharp/IO/WritePNG)  |
| [vtkPNMReader](http://www.vtk.org/doc/nightly/html/classvtkPNMReader.html#details) | [ReadPNM](/CSharp/IO/ReadPNM) [WritePNM](/CSharp/IO/WritePNM)  |
| [vtkPNMWriter](http://www.vtk.org/doc/nightly/html/classvtkPNMWriter.html#details) | [WritePNM](/CSharp/IO/WritePNM)  |
| [vtkPoints](http://www.vtk.org/doc/nightly/html/classvtkPoints.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [NullPoint](/CSharp/PolyData/NullPoint) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [PlanesIntersection](/CSharp/GeometricObjects/PlanesIntersection) [Point](/CSharp/GeometricObjects/Point) [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonIntersection](/CSharp/GeometricObjects/PolygonIntersection) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Pyramid](/CSharp/GeometricObjects/Pyramid) [Quad](/CSharp/GeometricObjects/Quad) [ReadPlainText](/CSharp/IO/ReadPlainText) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WriteVTP](/CSharp/IO/WriteVTP) [WriteVTU](/CSharp/IO/WriteVTU) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkPolyData](http://www.vtk.org/doc/nightly/html/classvtkPolyData.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [BandedPolyDataContourFilter](/CSharp/VisualizationAlgorithms/BandedPolyDataContourFilter) [CapClip](/CSharp/Meshes/CapClip) [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [Decimate](/CSharp/Meshes/Decimate) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [Frustum](/CSharp/GeometricObjects/Frustum) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [IterateOverLines](/CSharp/PolyData/IterateOverLines) [LongLine](/CSharp/GeometricObjects/LongLine) [NullPoint](/CSharp/PolyData/NullPoint) [OBBDicer](/CSharp/Meshes/OBBDicer) [Point](/CSharp/GeometricObjects/Point) [PolyDataGetPoint](/CSharp/PolyData/PolyDataGetPoint) [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [PolyLine](/CSharp/GeometricObjects/PolyLine) [Quad](/CSharp/GeometricObjects/Quad) [QuadricClustering](/CSharp/Meshes/QuadricClustering) [QuadricDecimation](/CSharp/Meshes/QuadricDecimation) [ReadPlainText](/CSharp/IO/ReadPlainText) [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter) [Subdivision](/CSharp/Meshes/Subdivision) [Triangle](/CSharp/GeometricObjects/Triangle) [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip) [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction) [Vertex](/CSharp/GeometricObjects/Vertex) [WarpVector](/CSharp/PolyData/WarpVector) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkPolyDataAlgorithm](http://www.vtk.org/doc/nightly/html/classvtkPolyDataAlgorithm.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkPolyDataConnectivityFilter](http://www.vtk.org/doc/nightly/html/classvtkPolyDataConnectivityFilter.html#details) | [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion)  |
| [vtkPolygon](http://www.vtk.org/doc/nightly/html/classvtkPolygon.html#details) | [Polygon](/CSharp/GeometricObjects/Polygon) [PolygonIntersection](/CSharp/GeometricObjects/PolygonIntersection)  |
| [vtkPolygonalSurfaceContourLineInterpolator](http://www.vtk.org/doc/nightly/html/classvtkPolygonalSurfaceContourLineInterpolator.html#details) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkPolygonalSurfacePointPlacer](http://www.vtk.org/doc/nightly/html/classvtkPolygonalSurfacePointPlacer.html#details) | [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator)  |
| [vtkPolyLine](http://www.vtk.org/doc/nightly/html/classvtkPolyLine.html#details) | [PolyLine](/CSharp/GeometricObjects/PolyLine)  |
| [vtkPyramid](http://www.vtk.org/doc/nightly/html/classvtkPyramid.html#details) | [Pyramid](/CSharp/GeometricObjects/Pyramid)  |
| [vtkQuad](http://www.vtk.org/doc/nightly/html/classvtkQuad.html#details) | [Quad](/CSharp/GeometricObjects/Quad)  |
| [vtkQuadricClustering](http://www.vtk.org/doc/nightly/html/classvtkQuadricClustering.html#details) | [QuadricClustering](/CSharp/Meshes/QuadricClustering)  |
| [vtkQuadricDecimation](http://www.vtk.org/doc/nightly/html/classvtkQuadricDecimation.html#details) | [QuadricDecimation](/CSharp/Meshes/QuadricDecimation)  |
| [vtkRegularPolygonSource](http://www.vtk.org/doc/nightly/html/classvtkRegularPolygonSource.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [RegularPolygonSource](/CSharp/GeometricObjects/RegularPolygonSource) [Triangulate](/CSharp/Meshes/Triangulate)  |
| [vtkSampleFunction](http://www.vtk.org/doc/nightly/html/classvtkSampleFunction.html#details) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkSelection](http://www.vtk.org/doc/nightly/html/classvtkSelection.html#details) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkSelectionNode](http://www.vtk.org/doc/nightly/html/classvtkSelectionNode.html#details) | [FillHoles](/CSharp/Meshes/FillHoles)  |
| [vtkSelectPolyData](http://www.vtk.org/doc/nightly/html/classvtkSelectPolyData.html#details) | [SelectPolyData](/CSharp/PolyData/SelectPolyData)  |
| [vtkShrinkPolyData](http://www.vtk.org/doc/nightly/html/classvtkShrinkPolyData.html#details) | [ShrinkPolyData](/CSharp/PolyData/ShrinkPolyData)  |
| [vtkSimpleElevationFilter](http://www.vtk.org/doc/nightly/html/classvtkSimpleElevationFilter.html#details) | [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkSimplePointsReader](http://www.vtk.org/doc/nightly/html/classvtkSimplePointsReader.html#details) | [SimplePointsReader](/CSharp/IO/SimplePointsReader)  |
| [vtkSphere](http://www.vtk.org/doc/nightly/html/classvtkSphere.html#details) | [ImplicitBoolean](/CSharp/Filters/ImplicitBoolean) [ImplicitSphere](/CSharp/ImplicitFunctions/ImplicitSphere) [SampleFunction](/CSharp/ImplicitFunctions/SampleFunction)  |
| [vtkSphereSource](http://www.vtk.org/doc/nightly/html/classvtkSphereSource.html#details) | [Axes](/CSharp/GeometricObjects/Axes) [CapClip](/CSharp/Meshes/CapClip) [ClosedSurface](/CSharp/PolyData/ClosedSurface) [ColorDisconnectedRegions](/CSharp/PolyData/ColorDisconnectedRegions) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [Decimate](/CSharp/Meshes/Decimate) [DijkstraGraphGeodesicPath](/CSharp/PolyData/DijkstraGraphGeodesicPath) [ExtractEdges](/CSharp/Meshes/ExtractEdges) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [MarchingCubes](/CSharp/Modelling/MarchingCubes) [MultiBlockMergeFilter](/CSharp/PolyData/MultiBlockMergeFilter) [OBBDicer](/CSharp/Meshes/OBBDicer) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [Planes](/CSharp/GeometricObjects/Planes) [PlanesIntersection](/CSharp/GeometricObjects/PlanesIntersection) [PolyDataConnectivityFilter_LargestRegion](/CSharp/PolyData/PolyDataConnectivityFilter_LargestRegion) [PolyDataConnectivityFilter_SpecifiedRegion](/CSharp/PolyData/PolyDataConnectivityFilter_SpecifiedRegion) [PolyDataGetPoint](/CSharp/PolyData/PolyDataGetPoint) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [QuadricClustering](/CSharp/Meshes/QuadricClustering) [QuadricDecimation](/CSharp/Meshes/QuadricDecimation) [ReadPDB](/CSharp/IO/ReadPDB) [SelectPolyData](/CSharp/PolyData/SelectPolyData) [ShrinkPolyData](/CSharp/PolyData/ShrinkPolyData) [Sphere](/CSharp/GeometricObjects/Sphere) [Subdivision](/CSharp/Meshes/Subdivision) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter) [WindowedSincPolyDataFilter](/CSharp/Meshes/WindowedSincPolyDataFilter)  |
| [vtkSTLReader](http://www.vtk.org/doc/nightly/html/classvtkSTLReader.html#details) | [ReadSTL](/CSharp/IO/ReadSTL)  |
| [vtkStripper](http://www.vtk.org/doc/nightly/html/classvtkStripper.html#details) | [CapClip](/CSharp/Meshes/CapClip)  |
| [vtkStructuredGrid](http://www.vtk.org/doc/nightly/html/classvtkStructuredGrid.html#details) | [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkStructuredGridGeometryFilter](http://www.vtk.org/doc/nightly/html/classvtkStructuredGridGeometryFilter.html#details) | [ReadPLOT3D](/CSharp/IO/ReadPLOT3D) [ReadStructuredGrid](/CSharp/IO/ReadStructuredGrid) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkStructuredPointsReader](http://www.vtk.org/doc/nightly/html/classvtkStructuredPointsReader.html#details) | [ExtractLargestIsosurface](/CSharp/Modelling/ExtractLargestIsosurface)  |
| [vtkSuperquadricSource](http://www.vtk.org/doc/nightly/html/classvtkSuperquadricSource.html#details) | [SolidClip](/CSharp/Meshes/SolidClip)  |
| [vtkTetra](http://www.vtk.org/doc/nightly/html/classvtkTetra.html#details) | [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkTextMapper](http://www.vtk.org/doc/nightly/html/classvtkTextMapper.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkTextProperty](http://www.vtk.org/doc/nightly/html/classvtkTextProperty.html#details) | [GeometricObjectsDemo](/CSharp/GeometricObjects/GeometricObjectsDemo) [ParametricObjectsDemo](/CSharp/GeometricObjects/ParametricObjectsDemo) [ReadDICOMSeries](/CSharp/IO/ReadDICOMSeries) [Subdivision](/CSharp/Meshes/Subdivision)  |
| [vtkThreshold](http://www.vtk.org/doc/nightly/html/classvtkThreshold.html#details) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells)  |
| [vtkThresholdPoints](http://www.vtk.org/doc/nightly/html/classvtkThresholdPoints.html#details) | [VectorFieldNonZeroExtraction](/CSharp/PolyData/VectorFieldNonZeroExtraction)  |
| [vtkTIFFReader](http://www.vtk.org/doc/nightly/html/classvtkTIFFReader.html#details) | [ReadTIFF](/CSharp/IO/ReadTIFF) [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkTIFFWriter](http://www.vtk.org/doc/nightly/html/classvtkTIFFWriter.html#details) | [WriteTIFF](/CSharp/IO/WriteTIFF)  |
| [vtkTransform](http://www.vtk.org/doc/nightly/html/classvtkTransform.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [Axes](/CSharp/GeometricObjects/Axes) [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow) [PerspectiveTransform](/CSharp/SimpleOperations/PerspectiveTransform) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkTransformFilter](http://www.vtk.org/doc/nightly/html/classvtkTransformFilter.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkTransformPolyDataFilter](http://www.vtk.org/doc/nightly/html/classvtkTransformPolyDataFilter.html#details) | [OrientedArrow](/CSharp/GeometricObjects/OrientedArrow)  |
| [vtkTriangle](http://www.vtk.org/doc/nightly/html/classvtkTriangle.html#details) | [CellEdges](/CSharp/Meshes/CellEdges) [Triangle](/CSharp/GeometricObjects/Triangle) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkTriangleFilter](http://www.vtk.org/doc/nightly/html/classvtkTriangleFilter.html#details) | [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [PolygonalSurfaceContourLineInterpolator](/CSharp/PolyData/PolygonalSurfaceContourLineInterpolator) [Subdivision](/CSharp/Meshes/Subdivision) [Triangulate](/CSharp/Meshes/Triangulate)  |
| [vtkTriangleStrip](http://www.vtk.org/doc/nightly/html/classvtkTriangleStrip.html#details) | [TriangleStrip](/CSharp/GeometricObjects/TriangleStrip)  |
| [vtkTubeFilter](http://www.vtk.org/doc/nightly/html/classvtkTubeFilter.html#details) | [ReadPDB](/CSharp/IO/ReadPDB)  |
| [vtkUndirectedGraph](http://www.vtk.org/doc/nightly/html/classvtkUndirectedGraph.html#details) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkUnsignedCharArray](http://www.vtk.org/doc/nightly/html/classvtkUnsignedCharArray.html#details) | [ColoredElevationMap](/CSharp/Meshes/ColoredElevationMap) [ColoredLines](/CSharp/GeometricObjects/ColoredLines) [ElevationFilter](/CSharp/Meshes/ElevationFilter) [SimpleElevationFilter](/CSharp/Meshes/SimpleElevationFilter)  |
| [vtkUnstructuredGrid](http://www.vtk.org/doc/nightly/html/classvtkUnstructuredGrid.html#details) | [Hexahedron](/CSharp/GeometricObjects/Hexahedron) [HighlightBadCells](/CSharp/PolyData/HighlightBadCells) [Pyramid](/CSharp/GeometricObjects/Pyramid) [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile) [Tetrahedron](/CSharp/GeometricObjects/Tetrahedron) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkUnstructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkUnstructuredGridReader.html#details) | [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter)  |
| [vtkVertex](http://www.vtk.org/doc/nightly/html/classvtkVertex.html#details) | [Vertex](/CSharp/GeometricObjects/Vertex)  |
| [vtkVertexGlyphFilter](http://www.vtk.org/doc/nightly/html/classvtkVertexGlyphFilter.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [ReadPlainText](/CSharp/IO/ReadPlainText)  |
| [vtkVolume16Reader](http://www.vtk.org/doc/nightly/html/classvtkVolume16Reader.html#details) | [MarchingSquares](/CSharp/WishList/Modelling/MarchingSquares)  |
| [vtkVoxelModeller](http://www.vtk.org/doc/nightly/html/classvtkVoxelModeller.html#details) | [MarchingCubes](/CSharp/Modelling/MarchingCubes)  |
| [vtkVRMLImporter](http://www.vtk.org/doc/nightly/html/classvtkVRMLImporter.html#details) | [VRML](/CSharp/IO/VRML)  |
| [vtkWarpVector](http://www.vtk.org/doc/nightly/html/classvtkWarpVector.html#details) | [WarpVector](/CSharp/PolyData/WarpVector)  |
| [vtkWeightedTransformFilter](http://www.vtk.org/doc/nightly/html/classvtkWeightedTransformFilter.html#details) | [WeightedTransformFilter](/CSharp/PolyData/WeightedTransformFilter)  |
| [vtkWindowedSincPolyDataFilter](http://www.vtk.org/doc/nightly/html/classvtkWindowedSincPolyDataFilter.html#details) | [WindowedSincPolyDataFilter](/CSharp/Meshes/WindowedSincPolyDataFilter)  |
| [vtkXGMLReader](http://www.vtk.org/doc/nightly/html/classvtkXGMLReader.html#details) | [XGMLReader](/CSharp/InfoVis/XGMLReader)  |
| [vtkXMLGenericDataObjectReader](http://www.vtk.org/doc/nightly/html/classvtkXMLGenericDataObjectReader.html#details) | [ReadUnknownTypeXMLFile](/CSharp/IO/ReadUnknownTypeXMLFile)  |
| [vtkXMLImageDataReader](http://www.vtk.org/doc/nightly/html/classvtkXMLImageDataReader.html#details) | [ReadImageData](/CSharp/IO/ReadImageData) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkXMLImageDataWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLImageDataWriter.html#details) | [IsoContours](/CSharp/ImplicitFunctions/IsoContours) [WriteVTI](/CSharp/IO/WriteVTI)  |
| [vtkXMLPolyDataReader](http://www.vtk.org/doc/nightly/html/classvtkXMLPolyDataReader.html#details) | [CapClip](/CSharp/Meshes/CapClip) [ContoursFromPolyData](/CSharp/Filtering/ContoursFromPolyData) [ConvertFile](/CSharp/IO/ConvertFile) [Curvature](/CSharp/PolyData/Curvature) [FilledContours](/CSharp/VisualizationAlgorithms/FilledContours) [FillHoles](/CSharp/Meshes/FillHoles) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [OBBDicer](/CSharp/Meshes/OBBDicer) [ReadPolyData](/CSharp/IO/ReadPolyData) [Subdivision](/CSharp/Meshes/Subdivision) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkXMLPolyDataWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLPolyDataWriter.html#details) | [AlignFrames](/CSharp/PolyData/AlignFrames) [Curvature](/CSharp/PolyData/Curvature) [FindAllArrayNames](/CSharp/IO/FindAllArrayNames) [MatrixMathFilter](/CSharp/Meshes/MatrixMathFilter) [WriteVTP](/CSharp/IO/WriteVTP)  |
| [vtkXMLRectilinearGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLRectilinearGridReader.html#details) | [ReadRectilinearGrid](/CSharp/IO/ReadRectilinearGrid)  |
| [vtkXMLStructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLStructuredGridReader.html#details) | [ReadStructuredGrid](/CSharp/IO/ReadStructuredGrid) [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkXMLStructuredGridWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLStructuredGridWriter.html#details) | [XMLStructuredGridWriter](/CSharp/IO/XMLStructuredGridWriter)  |
| [vtkXMLUnstructuredGridReader](http://www.vtk.org/doc/nightly/html/classvtkXMLUnstructuredGridReader.html#details) | [ReadUnstructuredGrid](/CSharp/IO/ReadUnstructuredGrid) [WriteVTU](/CSharp/IO/WriteVTU)  |
| [vtkXMLUnstructuredGridWriter](http://www.vtk.org/doc/nightly/html/classvtkXMLUnstructuredGridWriter.html#details) | [WriteVTU](/CSharp/IO/WriteVTU)  |
