#include <vtkImageActor.h>
#include <vtkImageMapper3D.h>
#include <vtkImageReader2.h>
#include <vtkImageReader2Factory.h>
#include <vtkInteractorStyleImage.h>
#include <vtkNamedColors.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRenderer.h>
#include <vtkSmartPointer.h>

int main(int argc, char* argv[])
{
  // Verify command line arguments.
  if (argc < 2)
  {
    std::cout << "Usage: " << argv[0] << " InputFilename e.g. Gourds.png"
              << std::endl;
    return EXIT_FAILURE;
  }

  // Parse command line arguments.
  std::string inputFilename = argv[1];

  // Read file.
  vtkNew<vtkImageReader2Factory> readerFactory;
  vtkSmartPointer<vtkImageReader2> imageReader;
  imageReader.TakeReference(
      readerFactory->CreateImageReader2(inputFilename.c_str()));
  imageReader->SetFileName(inputFilename.c_str());
  imageReader->Update();

  // Create an actor.
  vtkNew<vtkImageActor> actor;
  actor->GetMapper()->SetInputConnection(imageReader->GetOutputPort());

  // Setup renderer.
  vtkNew<vtkNamedColors> colors;

  vtkNew<vtkRenderer> renderer;
  renderer->AddActor(actor);
  renderer->ResetCamera();
  renderer->SetBackground(colors->GetColor3d("Slate_grey").GetData());

  // Setup render window.
  vtkNew<vtkRenderWindow> renderWindow;
  renderWindow->AddRenderer(renderer);
  renderWindow->SetWindowName("ImageReader2Factory");

  // Setup render window interactor.
  vtkNew<vtkRenderWindowInteractor> renderWindowInteractor;
  vtkNew<vtkInteractorStyleImage> style;

  renderWindowInteractor->SetInteractorStyle(style);

  // Render and start interaction.
  renderWindowInteractor->SetRenderWindow(renderWindow);
  renderWindow->Render();
  renderWindowInteractor->Initialize();

  renderWindowInteractor->Start();

  return EXIT_SUCCESS;
}
