### Description
Demonstrates how to apply the connectivity filter to remove noisy isosurfaces.

To illustrate the application of connectivity analysis, we will use an MRI dataset generated by Janet MacFall at the [Center for In Vivo Microscopy](http://www.civm.duhs.duke.edu/) at Duke University. The dataset is a volume of dimensions 256^3. The data is of the root system of a small pine tree. Using the class vtkSliceCubes , an implementation of marching cubes for large volumes, we generate an initial isosurface represented by 351,536 triangles. This is a faster way of manipulating this data. If you have a large enough computer you can process the volume directly with a vtk image reader and vtkMarchingCubes.
[The example on this other page](/Cxx/VisualizationAlgorithms/PineRootConnectivityA) shows the initial dataset. Notice that there are many small, disconnected isosurfaces due to noise and isolated moisture in the data. We use vtkConnectivityFilter to remove these small, disconnected surfaces. The example on this page shows the result of applying the filter. Over 50,000 triangles were removed, leaving 299,380 triangles. The vtkConnectivityFilter is a general filter taking datasets as input, and generating an unstructured grid as output. It functions by extracting cells that are connected at points (i.e., share common points). In this example the single largest surface is extracted. It is also possible to specify cell ids and point ids and extract surfaces connected to these.

!!! info
    To count the number of triangles in the polydata we do the following:
    #### C++
    We use a lambda function
    ``` c++
    auto NumberofTriangles = [](auto *pd)
    ```
    #### Python
    We just implement:
    ``` python
    def NumberOfTriangles(pd):
    ```
    within the scope of the calling function.

!!! cite
    *Comparative Water Uptake by Roots of Different Ages in Seedlings of Loblolly Pine (Pinus taeda L.)* December 1991. New Phytologist 119(4):551 - 560.

!!! info
    See [Figure 9-51](/VTKBook/09Chapter9/#Figure%209-51b) in [Chapter 9](/VTKBook/09Chapter9) in the [VTK Textbook](/VTKBook/01Chapter1/).
