# Append a module to the list optional if the module is found in library

if (VTK_VERSION VERSION_LESS "8.90.0")
macro(Add_Optional_If_In_Library module optional)
  if("${${module}_LOADED}x" STREQUAL "1x")
    list(APPEND optional ${module})
  endif()
endmacro()
else()
macro(Add_Optional_If_In_Library module library optional)
  set(moduleTest ${module})
  string(REGEX REPLACE "vtk" "" module ${moduleTest})
  string(FIND "${library}" ${moduleTest} found)
  if(found GREATER -1)
    list(APPEND optional ${moduleTest})
  endif()
endmacro()
endif()
