### Description

This depicts a human figure transected by the three commonly used anatomical planes:

- **Sagittal plane** – is perpendicular to the ground divides the body into a left section and a right section.
- **Coronal plane** – is perpendicular to the ground and divides the body into a front (anterior) section and back (posterior) section.
- **Transverse plane** – or *axial plane* is parallel to the ground  divides the body into an upper (superior) section and a bottom (inferior) section.

Four annotated cube actors are also provided demonstrating different coordinate systems.
The annotations on the faces of the cube actors are:

- **Sagittal plane**
    - **L** - left.
    - **R** - right.
- **Coronal plane**
    - **A** - anterior.
    - **P** - posterior.
- **Transverse plane**
    - **S** - superior.
    - **I** - inferior.
    
The annotated cube actors demonstrate the various coordinate systems:
- The anatomical coordinate system forming a 3D basis is defined along the anatomical axes of anterior-posterior, inferior-superior, and left-right. These are the positive directions. In a Cartesian system this is RPS (Right, Posterior, Superior). The top-left annotated cube actor shows this basis, this is a left-handed system.
- RAS (Right, Anterior, Superior), left-right, posterior-anterior, and inferior-superior. This is the usual right-handed system used by VTK and Slicer.
The bottom left annotated cube actor shows this basis.
- LPS (Left, Posterior, Superior), right-left, anterior-posterior, and inferior-superior. This is used in DICOM images and by the ITK toolkit.
The bottom right annotated cube actor shows this basis.
- The upper right cube actor has no axes and simply shows the planes.

RPS is a left-handed system whilst RAS and LPS are right-handed.

Note that the text for the planes is carefully placed to avoid obstructing the figure and it also sits slightly above the plane.
