### Description

Snippets are chunks of code that can be cut (*snipped*) and pasted into examples. We want each example to be stand-alone, so we do not keep the snippet code in a library.

### Available snippets

#### [CameraPosition](/Cxx/Snippets/CameraPosition.md)

Output the camera position while moving the image.

#### [CheckVTKVersion](/Cxx/Snippets/CheckVTKVersion.md)

Check the VTK version returning `true` if the requested VTK version is >= the current version.

#### [PointToGlyph](/Cxx/Snippets/PointToGlyph.md)

Represent points as glyphs.

#### [ReadPolyData](/Cxx/Snippets/ReadPolyData.md)

Uses the appropriate vtkPolyData reader to read any vtkPolyData file.

#### [SaveSceneToFieldData](/Cxx/Snippets/SaveSceneToFieldData.md)

Stores the current vtkCamera location in a vtkDataSet's vtkFieldData.

#### [RestoreSceneFromFieldData](/Cxx/Snippets/RestoreSceneFromFieldData.md)

Restores the saved vtkCamera view from a vtkDataSet's vtkFieldData.

#### [SaveSceneToFile](/Cxx/Snippets/SaveSceneToFile.md)

Stores the current vtkCamera location in a file.

#### [RestoreSceneFromFile](/Cxx/Snippets/RestoreSceneFromFile.md)

Restores the saved vtkCamera view from a file.

#### [ChooseContrastingColor](/Cxx/Snippets/ChooseContrastingColor.md)

Given a color, find a contrasting color. If the given color is "light", use the lightColor otherwise use the darkColor

#### [ViewportBorders](/Cxx/Snippets/ViewportBorders.md)

Draw the borders of a vtkRenderer's viewports.

#### [WriteImage](/Cxx/Snippets/WriteImage.md)
Take a screen shot and save it to a file.
