import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import vtk.vtkActor;
import vtk.vtkSphereSource;
import vtk.vtkNativeLibrary;
import vtk.vtkPanel;
import vtk.vtkPolyDataMapper;


/**
 Java Program to Display a  Wireframe Sphere using VTK. 
 Author: Bharatesh Chakravarthi, Chung Ang University,
 Seoul, South Korea. 
 */
 
 
public class Sphere extends JPanel implements ActionListener {
  private static final long serialVersionUID = 1L;
  private vtkPanel renWin;
  private JButton exitButton;

  // -----------------------------------------------------------------
  // Load VTK library and print which library was not properly loaded
  static {
    if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
      for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
        if (!lib.IsLoaded()) {
          System.out.println(lib.GetLibraryName() + " not loaded");
        }
      }
    }
    vtkNativeLibrary.DisableOutputWindow(null);
  }
  // -----------------------------------------------------------------
  
  
  public Sphere() {
    super(new BorderLayout());

  //Create a Sphere
  vtkSphereSource Sphere = new vtkSphereSource();
  Sphere.SetCenter(0.0,0.0,0.0);
  Sphere.SetRadius(1.0);
  Sphere.Update();
  
  //Change Phi and Theta Value for Smooth Surface
  Sphere.SetPhiResolution(10);
  Sphere.SetThetaResolution(10);
  
  //Create a Mapper and Actor
  vtkPolyDataMapper Mapper = new vtkPolyDataMapper();
  Mapper.SetInputConnection(Sphere.GetOutputPort());

  vtkActor Actor = new vtkActor();
  Actor.SetMapper(Mapper);
  Actor.GetProperty().SetColor(1.0, 1.0, 1.0);
  //Setting up the wireframe property to Sphere. Comment the below line to display Solid Sphere
  Actor.GetProperty().SetRepresentationToWireframe();
 
  
   
  renWin = new vtkPanel();
  renWin.GetRenderer().AddActor(Actor);
  renWin.resetCamera();

  // Add Java UI components
  exitButton = new JButton("Exit");
  exitButton.addActionListener(this);

  add(renWin, BorderLayout.CENTER);
  add(exitButton, BorderLayout.SOUTH);
  }

  /** An ActionListener that listens to the button. */
  public void actionPerformed(ActionEvent e) {
    if (e.getSource().equals(exitButton)) {
      System.exit(0);
    }
  }

  public static void main(String s[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        JFrame frame = new JFrame("Sphere");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(new Sphere(), BorderLayout.CENTER);
        frame.setSize(400, 400);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
      }
    });
  }
}
