### Description
Snippets are chunks of code that can be cut (*snipped*) and pasted into examples. We want each example to be stand-alone, so we do not keep the snippet code in a library.

### Available snippets

#### [ReadPolyData](/Cxx/Snippets/ReadPolyData.md)
Uses the appropriate vtkPolyData reader to read any vtkPolyData file.

#### [SaveSceneToFieldData](/Cxx/Snippets/SaveSceneToFieldData)
Stores the current vtkCamera location in a vtkDataSet's vtkFieldData.

#### [RestoreSceneFromFieldData](/Cxx/Snippets/RestoreSceneFromFieldData)
Restores the saved vtkCamera view from a vtkDataSet's vtkFieldData.

#### [SaveSceneToFile](/Cxx/Snippets/SaveSceneToFile)
Stores the current vtkCamera location in a file.

#### [RestoreSceneFromFile](/Cxx/Snippets/RestoreSceneFromFile)
Restores the saved vtkCamera view from a file.

#### [ChooseContrastingColor](/Cxx/Snippets/ChooseContrastingColor)
Given a color, find a contrasting color. If the goven color is "light", use the lightColor otherwise use the darkColor

#### [ViewportBorders](/Cxx/Snippets/ViewportBorders)
Draw the borders of a vtkRenderer's viewports.

