### Description

This example illustrates how to extract the cells that exist inside a closed surface.
It uses vtkSelectEnclosedPoints to mark points that are inside and outside the surface. vtkMultiThreshold is used to extract the three meshes into three vtkMultiBlockDataSet's. The cells completely outside are shown in crimson, completely inside are yellow and border cells are green. A translucent copy of the closed surface helps illustrate the selection process.

If two polydata datasets are provided, the example uses the second as the closed surface. If only one dataset is provided, the closed surface is generated by rotating the first dataset by 90 degrees around its Y axis.

!!! info
    The example is run with the [cow.g](https://raw.githubusercontent.com/lorensen/VTKExamples/master/src/Testing/Data/cow.g) data.

!!! warning
    The surface that contains cells must be closed and manifold. The example does not check for this. Run ClosedSurface [(C++)](/Cxx/PolyData/ClosedSurface) or [(Python)](/Python/PolyData/ClosedSurface) to check your surface.
