/**
 * @class   vtkCGALXYZWriter
 * @brief   write point cloud as xyz
 *
 * vtkCGALXYZWriter write point clouds using
 * CGAL point cloud data reader functionality.
 */

#ifndef vtkCGALXYZReader_h
#define vtkCGALXYZReader_h

#include "vtkCGALPSPModule.h" // For export macro
#include "vtkCGALPolyDataAlgorithm.h"

class vtkDataArraySelection;
class vtkDataSet;
class vtkDoubleArray;
class vtkIntArray;
class vtkStdString;
class vtkStringArray;
class vtkAIMToolsPrivate;

class VTKCGALPSP_EXPORT vtkCGALXYZWriter : public vtkCGALPolyDataAlgorithm
{
public:
  vtkTypeMacro(vtkCGALXYZWriter, vtkCGALPolyDataAlgorithm);
  static vtkCGALXYZWriter* New();

  void PrintSelf(ostream& os, vtkIndent indent) override;

  ///@{
  /**
   * Get/Set the name of the output file.
   */
  vtkSetFilePathMacro(FileName);
  vtkGetFilePathMacro(FileName);
  ///@}

  int Write();

protected:
  vtkCGALXYZWriter();
  ~vtkCGALXYZWriter() override;

  int RequestData(vtkInformation* request, vtkInformationVector** inputVector,
    vtkInformationVector* outputVector) override;


private:
  vtkCGALXYZWriter(const vtkCGALXYZWriter&) = delete;
  void operator=(const vtkCGALXYZWriter&)   = delete;

  char* FileName;
};

#endif // vtkCGALXYZReader_h
