/**
 * @class   vtkCGALDelaunay3to2
 * @brief   remesh using the CGAL delaunay
 *
 * vtkCGALDelaunay3to2 allows to create plannar delaunay meshes
 * from a set of planar points, edges and polygons.
 * From now on, the input mesh needs to be planar along x, y or z.
 * Constraints should not overlap each others.
 */

#ifndef vtkCGALDelaunay3to2_h
#define vtkCGALDelaunay3to2_h

#include "vtkPolyDataAlgorithm.h"

// CGAL includes
#include "vtkCGALDelaunayModule.h" // For export macro

class VTKCGALDELAUNAY_EXPORT vtkCGALDelaunay3to2 : public vtkPolyDataAlgorithm
{
public:
  static vtkCGALDelaunay3to2* New();
  vtkTypeMacro(vtkCGALDelaunay3to2, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkCGALDelaunay3to2()           = default;
  ~vtkCGALDelaunay3to2() override = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkCGALDelaunay3to2(const vtkCGALDelaunay3to2&) = delete;
  void operator=(const vtkCGALDelaunay3to2&) = delete;
};

#endif
