#include <iostream>

#include <vtkNew.h>
#include <vtkTestUtilities.h>
#include <vtkXMLPolyDataReader.h>
#include <vtkXMLPolyDataWriter.h>

#include "vtkCGALDelaunay2.h"
#include "vtkCGALDelaunay3to2.h"

int TestDelaunayExecution(int, char* argv[])
{
  // Open data

  vtkNew<vtkXMLPolyDataReader> reader1;
  std::string                  cfname1(argv[1]);
  cfname1 += "shrink_plane.vtp";
  reader1->SetFileName(cfname1.c_str());

  vtkNew<vtkXMLPolyDataReader> reader2;
  std::string                  cfname2(argv[1]);
  cfname2 += "shrink_sphere.vtp";
  reader2->SetFileName(cfname2.c_str());

  // Remesh

  vtkNew<vtkCGALDelaunay2> rm2;
  rm2->SetInputConnection(reader1->GetOutputPort());

  vtkNew<vtkCGALDelaunay3to2> rm3to2;
  rm3to2->SetInputConnection(reader2->GetOutputPort());

  // Save result

  vtkNew<vtkXMLPolyDataWriter> writer;

  writer->SetInputConnection(rm2->GetOutputPort());
  writer->SetFileName("delaunay2_remesh.vtp");
  writer->Write();

  writer->SetInputConnection(rm3to2->GetOutputPort());
  writer->SetFileName("delaunay3to2_remesh.vtp");
  writer->Write();

  return 0;
}
