#!/bin/bash

# VTK-m v2.0.0-rc1 - Dec 27, 2022
VTKM_HASH=d2ee109c4682893cc6b5e0180299521be5de041f
VTKM_SHORT_HASH=${VTKM_HASH:0:8}

# ADIOS2 master - Dec 9, 2022
ADIOS_HASH=b11cde59d82756bcd5cf3a9720958a3add030f5a
ADIOS_SHORT_HASH=${ADIOS_HASH:0:8}

cp install_cmake.sh ubuntu18
cp install_adios2.sh ubuntu18
cp install_vtkm.sh ubuntu18
IMAGE_NAME=kitware/vtk:ci-fides-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}-latest
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  --build-arg ADIOS_HASH=$ADIOS_HASH \
  -t $IMAGE_NAME \
  ubuntu18/
rm ubuntu18/install_adios2.sh
rm ubuntu18/install_vtkm.sh
rm ubuntu18/install_cmake.sh
docker push $IMAGE_NAME

cp install_cmake.sh ubuntu18-ompi
cp install_adios2.sh ubuntu18-ompi
cp install_vtkm.sh ubuntu18-ompi
IMAGE_NAME=kitware/vtk:ci-fides-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}-ompi-latest
docker image build --build-arg VTKM_HASH=$VTKM_HASH \
  --build-arg ADIOS_HASH=$ADIOS_HASH \
  -t $IMAGE_NAME \
  ubuntu18-ompi/
rm ubuntu18-ompi/install_adios2.sh
rm ubuntu18-ompi/install_vtkm.sh
rm ubuntu18-ompi/install_cmake.sh
docker push $IMAGE_NAME

#edit names in .gitlab-ci.yml
sed -i -e "s/ci-fides-vtkm[a-zA-Z0-9]\{8\}-adios[a-zA-Z0-9]\{8\}/ci-fides-vtkm${VTKM_SHORT_HASH}-adios${ADIOS_SHORT_HASH}/g" ../../os-linux.yml
