#!/bin/sh
set -x

set -x

readonly adios_repo="https://github.com/ornladios/ADIOS2"
readonly adios_commit="v2.10.1"

readonly adios_root="$HOME/adios"
readonly adios_src="$adios_root/src"
readonly adios_build_root="$adios_root/build"

git clone -b "$adios_commit" "$adios_repo" "$adios_src"

adios_build () {
    local subdir="$1"
    shift

    cmake -GNinja \
        -S "$adios_src" \
        -B "$adios_build_root/$subdir" \
        -DCMAKE_BUILD_TYPE=Release \
        -DBUILD_SHARED_LIBS=ON \
        -DADIOS2_BUILD_EXAMPLES=OFF \
        -DBUILD_TESTING=OFF \
        -DCMAKE_INSTALL_PREFIX=/usr \
        -DCMAKE_INSTALL_LIBDIR=lib \
        -DADIOS2_USE_HDF5=OFF \
        -DADIOS2_USE_ZeroMQ=OFF \
        -DADIOS2_USE_Python=OFF \
        -DADIOS2_USE_Fortran=OFF \
        -DADIOS2_USE_SST=OFF \
        -DADIOS2_USE_BZip2=OFF \
        -DADIOS2_USE_ZFP=OFF \
        -DADIOS2_USE_SZ=OFF \
        -DADIOS2_USE_MGARD=OFF \
        -DADIOS2_USE_PNG=OFF \
        -DADIOS2_USE_Endian_Reverse=OFF \
        -DADIOS2_USE_IME=OFF \
        "$@"
    cmake --build "$adios_build_root/$subdir"
    cmake --build "$adios_build_root/$subdir" --target install
}

readonly build_type="$1"

if [ "$build_type" = "asan" ]; then
    # MPI-less build used for testing with sanitizers
    adios_build nompi \
        -DADIOS2_USE_MPI=OFF
else
    # OpenMPI
    adios_build openmpi \
        -DADIOS2_USE_MPI=ON
fi

rm -rf "$adios_root"
