////
//// BEGIN-EXAMPLE VTKDataSetWriter.cxx
////
#include <vtkm/io/writer/VTKDataSetWriter.h>

void SaveDataAsVTKFile(vtkm::cont::DataSet data)
{
  vtkm::io::writer::VTKDataSetWriter writer("data.vtk");

  writer.WriteDataSet(data);
}
////
//// END-EXAMPLE VTKDataSetWriter.cxx
////

////
//// BEGIN-EXAMPLE VTKDataSetReader.cxx
////
#include <vtkm/io/reader/VTKDataSetReader.h>

vtkm::cont::DataSet OpenDataFromVTKFile()
{
  vtkm::io::reader::VTKDataSetReader reader("data.vtk");

  return reader.ReadDataSet();
}
////
//// END-EXAMPLE VTKDataSetReader.cxx
////

////
//// BEGIN-EXAMPLE VTKmImageReader.cxx
////
#include <vtkm/io/reader/ImageReader.h>

std::vector<vtkm::cont::DataSet> ReadImageData(vtkm::rendering::Canvas canvas)
{
  vtkm::io::reader::PNGReader pngReader();
  vtkm::io::reader::PNMReader pnmReader()

  auto pngData = pngReader.ReadFromFile("data.png");
  auto ppmData = pnmReader.ReadFromFile("data.ppm");
  auto canvasData = pngReader.CreateImageDataSet(canvas);
  return {pngData, ppmData, canvasData};
}
////
//// END-EXAMPLE VTKmImageReader.cxx
////

////
//// BEGIN-EXAMPLE VTKmImageWriter.cxx
////
#include <vtkm/io/reader/ImageReader.h>

void WriteImageData(vtkm::cont::DataSet dataSet)
{
  vtkm::io::writer::PNGWriter pngWriter();
  vtkm::io::writer::PNMWriter pnmWriter(65535);

  pngWriter.WriteToFile("data.png", dataSet);
  pnmWriter.WriteToFile("data.ppm", dataSet);
}
////
//// END-EXAMPLE VTKmImageWriter.cxx
////

#include <vtkm/cont/testing/MakeTestDataSet.h>
#include <vtkm/cont/testing/Testing.h>

namespace
{

void TestIO()
{
  std::cout << "Writing data" << std::endl;
  vtkm::cont::testing::MakeTestDataSet makeDataSet;
  vtkm::cont::DataSet createdData = makeDataSet.Make3DExplicitDataSetCowNose();
  SaveDataAsVTKFile(createdData);

  std::cout << "Reading data" << std::endl;
  vtkm::cont::DataSet readData = OpenDataFromVTKFile();

  const vtkm::cont::CellSet* createdCellSet =
    createdData.GetCellSet().GetCellSetBase();
  const vtkm::cont::CellSet* readCellSet = readData.GetCellSet().GetCellSetBase();
  VTKM_TEST_ASSERT(createdCellSet->GetNumberOfCells() ==
                     readCellSet->GetNumberOfCells(),
                   "Createded and read data do not match.");
  VTKM_TEST_ASSERT(createdCellSet->GetNumberOfPoints() ==
                     readCellSet->GetNumberOfPoints(),
                   "Createded and read data do not match.");
}

} // namespace

int IO(int argc, char* argv[])
{
  return vtkm::cont::testing::Testing::Run(TestIO, argc, argv);
}
