/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ReplicateAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Init utility for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ReplicateAttributes::Init()
{
    useUnitCellVectors = false;
    xVector[0] = 1;
    xVector[1] = 0;
    xVector[2] = 0;
    yVector[0] = 0;
    yVector[1] = 1;
    yVector[2] = 0;
    zVector[0] = 0;
    zVector[1] = 0;
    zVector[2] = 1;
    xReplications = 1;
    yReplications = 1;
    zReplications = 1;
    mergeResults = true;
    replicateUnitCellAtoms = false;
    shiftPeriodicAtomOrigin = false;
    newPeriodicOrigin[0] = 0;
    newPeriodicOrigin[1] = 0;
    newPeriodicOrigin[2] = 0;

    ReplicateAttributes::SelectAll();
}

// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Copy utility for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ReplicateAttributes::Copy(const ReplicateAttributes &obj)
{
    useUnitCellVectors = obj.useUnitCellVectors;
    xVector[0] = obj.xVector[0];
    xVector[1] = obj.xVector[1];
    xVector[2] = obj.xVector[2];

    yVector[0] = obj.yVector[0];
    yVector[1] = obj.yVector[1];
    yVector[2] = obj.yVector[2];

    zVector[0] = obj.zVector[0];
    zVector[1] = obj.zVector[1];
    zVector[2] = obj.zVector[2];

    xReplications = obj.xReplications;
    yReplications = obj.yReplications;
    zReplications = obj.zReplications;
    mergeResults = obj.mergeResults;
    replicateUnitCellAtoms = obj.replicateUnitCellAtoms;
    shiftPeriodicAtomOrigin = obj.shiftPeriodicAtomOrigin;
    newPeriodicOrigin[0] = obj.newPeriodicOrigin[0];
    newPeriodicOrigin[1] = obj.newPeriodicOrigin[1];
    newPeriodicOrigin[2] = obj.newPeriodicOrigin[2];


    ReplicateAttributes::SelectAll();
}

// Type map format string
const char *ReplicateAttributes::TypeMapFormatString = REPLICATEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ReplicateAttributes::TmfsStruct = {REPLICATEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Default constructor for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes::ReplicateAttributes() : 
    AttributeSubject(ReplicateAttributes::TypeMapFormatString)
{
    ReplicateAttributes::Init();
}

// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Constructor for the derived classes of ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes::ReplicateAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ReplicateAttributes::Init();
}

// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Copy constructor for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes::ReplicateAttributes(const ReplicateAttributes &obj) : 
    AttributeSubject(ReplicateAttributes::TypeMapFormatString)
{
    ReplicateAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ReplicateAttributes::ReplicateAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes::ReplicateAttributes(const ReplicateAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ReplicateAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ReplicateAttributes::~ReplicateAttributes
//
// Purpose: 
//   Destructor for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes::~ReplicateAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ReplicateAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ReplicateAttributes& 
ReplicateAttributes::operator = (const ReplicateAttributes &obj)
{
    if (this == &obj) return *this;

    ReplicateAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ReplicateAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ReplicateAttributes::operator == (const ReplicateAttributes &obj) const
{
    // Compare the xVector arrays.
    bool xVector_equal = true;
    for(int i = 0; i < 3 && xVector_equal; ++i)
        xVector_equal = (xVector[i] == obj.xVector[i]);

    // Compare the yVector arrays.
    bool yVector_equal = true;
    for(int i = 0; i < 3 && yVector_equal; ++i)
        yVector_equal = (yVector[i] == obj.yVector[i]);

    // Compare the zVector arrays.
    bool zVector_equal = true;
    for(int i = 0; i < 3 && zVector_equal; ++i)
        zVector_equal = (zVector[i] == obj.zVector[i]);

    // Compare the newPeriodicOrigin arrays.
    bool newPeriodicOrigin_equal = true;
    for(int i = 0; i < 3 && newPeriodicOrigin_equal; ++i)
        newPeriodicOrigin_equal = (newPeriodicOrigin[i] == obj.newPeriodicOrigin[i]);

    // Create the return value
    return ((useUnitCellVectors == obj.useUnitCellVectors) &&
            xVector_equal &&
            yVector_equal &&
            zVector_equal &&
            (xReplications == obj.xReplications) &&
            (yReplications == obj.yReplications) &&
            (zReplications == obj.zReplications) &&
            (mergeResults == obj.mergeResults) &&
            (replicateUnitCellAtoms == obj.replicateUnitCellAtoms) &&
            (shiftPeriodicAtomOrigin == obj.shiftPeriodicAtomOrigin) &&
            newPeriodicOrigin_equal);
}

// ****************************************************************************
// Method: ReplicateAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ReplicateAttributes::operator != (const ReplicateAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ReplicateAttributes::TypeName
//
// Purpose: 
//   Type name method for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ReplicateAttributes::TypeName() const
{
    return "ReplicateAttributes";
}

// ****************************************************************************
// Method: ReplicateAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ReplicateAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ReplicateAttributes *tmp = (const ReplicateAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ReplicateAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ReplicateAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ReplicateAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ReplicateAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ReplicateAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ReplicateAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ReplicateAttributes(*this);
    else
        retval = new ReplicateAttributes;

    return retval;
}

// ****************************************************************************
// Method: ReplicateAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ReplicateAttributes::SelectAll()
{
    Select(ID_useUnitCellVectors,      (void *)&useUnitCellVectors);
    Select(ID_xVector,                 (void *)xVector, 3);
    Select(ID_yVector,                 (void *)yVector, 3);
    Select(ID_zVector,                 (void *)zVector, 3);
    Select(ID_xReplications,           (void *)&xReplications);
    Select(ID_yReplications,           (void *)&yReplications);
    Select(ID_zReplications,           (void *)&zReplications);
    Select(ID_mergeResults,            (void *)&mergeResults);
    Select(ID_replicateUnitCellAtoms,  (void *)&replicateUnitCellAtoms);
    Select(ID_shiftPeriodicAtomOrigin, (void *)&shiftPeriodicAtomOrigin);
    Select(ID_newPeriodicOrigin,       (void *)newPeriodicOrigin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ReplicateAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ReplicateAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ReplicateAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ReplicateAttributes.
    DataNode *node = new DataNode("ReplicateAttributes");

    if(completeSave || !FieldsEqual(ID_useUnitCellVectors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useUnitCellVectors", useUnitCellVectors));
    }

    if(completeSave || !FieldsEqual(ID_xVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xVector", xVector, 3));
    }

    if(completeSave || !FieldsEqual(ID_yVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yVector", yVector, 3));
    }

    if(completeSave || !FieldsEqual(ID_zVector, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zVector", zVector, 3));
    }

    if(completeSave || !FieldsEqual(ID_xReplications, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xReplications", xReplications));
    }

    if(completeSave || !FieldsEqual(ID_yReplications, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yReplications", yReplications));
    }

    if(completeSave || !FieldsEqual(ID_zReplications, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("zReplications", zReplications));
    }

    if(completeSave || !FieldsEqual(ID_mergeResults, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("mergeResults", mergeResults));
    }

    if(completeSave || !FieldsEqual(ID_replicateUnitCellAtoms, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("replicateUnitCellAtoms", replicateUnitCellAtoms));
    }

    if(completeSave || !FieldsEqual(ID_shiftPeriodicAtomOrigin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("shiftPeriodicAtomOrigin", shiftPeriodicAtomOrigin));
    }

    if(completeSave || !FieldsEqual(ID_newPeriodicOrigin, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("newPeriodicOrigin", newPeriodicOrigin, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ReplicateAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ReplicateAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ReplicateAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("useUnitCellVectors")) != 0)
        SetUseUnitCellVectors(node->AsBool());
    if((node = searchNode->GetNode("xVector")) != 0)
        SetXVector(node->AsDoubleArray());
    if((node = searchNode->GetNode("yVector")) != 0)
        SetYVector(node->AsDoubleArray());
    if((node = searchNode->GetNode("zVector")) != 0)
        SetZVector(node->AsDoubleArray());
    if((node = searchNode->GetNode("xReplications")) != 0)
        SetXReplications(node->AsInt());
    if((node = searchNode->GetNode("yReplications")) != 0)
        SetYReplications(node->AsInt());
    if((node = searchNode->GetNode("zReplications")) != 0)
        SetZReplications(node->AsInt());
    if((node = searchNode->GetNode("mergeResults")) != 0)
        SetMergeResults(node->AsBool());
    if((node = searchNode->GetNode("replicateUnitCellAtoms")) != 0)
        SetReplicateUnitCellAtoms(node->AsBool());
    if((node = searchNode->GetNode("shiftPeriodicAtomOrigin")) != 0)
        SetShiftPeriodicAtomOrigin(node->AsBool());
    if((node = searchNode->GetNode("newPeriodicOrigin")) != 0)
        SetNewPeriodicOrigin(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ReplicateAttributes::SetUseUnitCellVectors(bool useUnitCellVectors_)
{
    useUnitCellVectors = useUnitCellVectors_;
    Select(ID_useUnitCellVectors, (void *)&useUnitCellVectors);
}

void
ReplicateAttributes::SetXVector(const double *xVector_)
{
    xVector[0] = xVector_[0];
    xVector[1] = xVector_[1];
    xVector[2] = xVector_[2];
    Select(ID_xVector, (void *)xVector, 3);
}

void
ReplicateAttributes::SetYVector(const double *yVector_)
{
    yVector[0] = yVector_[0];
    yVector[1] = yVector_[1];
    yVector[2] = yVector_[2];
    Select(ID_yVector, (void *)yVector, 3);
}

void
ReplicateAttributes::SetZVector(const double *zVector_)
{
    zVector[0] = zVector_[0];
    zVector[1] = zVector_[1];
    zVector[2] = zVector_[2];
    Select(ID_zVector, (void *)zVector, 3);
}

void
ReplicateAttributes::SetXReplications(int xReplications_)
{
    xReplications = xReplications_;
    Select(ID_xReplications, (void *)&xReplications);
}

void
ReplicateAttributes::SetYReplications(int yReplications_)
{
    yReplications = yReplications_;
    Select(ID_yReplications, (void *)&yReplications);
}

void
ReplicateAttributes::SetZReplications(int zReplications_)
{
    zReplications = zReplications_;
    Select(ID_zReplications, (void *)&zReplications);
}

void
ReplicateAttributes::SetMergeResults(bool mergeResults_)
{
    mergeResults = mergeResults_;
    Select(ID_mergeResults, (void *)&mergeResults);
}

void
ReplicateAttributes::SetReplicateUnitCellAtoms(bool replicateUnitCellAtoms_)
{
    replicateUnitCellAtoms = replicateUnitCellAtoms_;
    Select(ID_replicateUnitCellAtoms, (void *)&replicateUnitCellAtoms);
}

void
ReplicateAttributes::SetShiftPeriodicAtomOrigin(bool shiftPeriodicAtomOrigin_)
{
    shiftPeriodicAtomOrigin = shiftPeriodicAtomOrigin_;
    Select(ID_shiftPeriodicAtomOrigin, (void *)&shiftPeriodicAtomOrigin);
}

void
ReplicateAttributes::SetNewPeriodicOrigin(const double *newPeriodicOrigin_)
{
    newPeriodicOrigin[0] = newPeriodicOrigin_[0];
    newPeriodicOrigin[1] = newPeriodicOrigin_[1];
    newPeriodicOrigin[2] = newPeriodicOrigin_[2];
    Select(ID_newPeriodicOrigin, (void *)newPeriodicOrigin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
ReplicateAttributes::GetUseUnitCellVectors() const
{
    return useUnitCellVectors;
}

const double *
ReplicateAttributes::GetXVector() const
{
    return xVector;
}

double *
ReplicateAttributes::GetXVector()
{
    return xVector;
}

const double *
ReplicateAttributes::GetYVector() const
{
    return yVector;
}

double *
ReplicateAttributes::GetYVector()
{
    return yVector;
}

const double *
ReplicateAttributes::GetZVector() const
{
    return zVector;
}

double *
ReplicateAttributes::GetZVector()
{
    return zVector;
}

int
ReplicateAttributes::GetXReplications() const
{
    return xReplications;
}

int
ReplicateAttributes::GetYReplications() const
{
    return yReplications;
}

int
ReplicateAttributes::GetZReplications() const
{
    return zReplications;
}

bool
ReplicateAttributes::GetMergeResults() const
{
    return mergeResults;
}

bool
ReplicateAttributes::GetReplicateUnitCellAtoms() const
{
    return replicateUnitCellAtoms;
}

bool
ReplicateAttributes::GetShiftPeriodicAtomOrigin() const
{
    return shiftPeriodicAtomOrigin;
}

const double *
ReplicateAttributes::GetNewPeriodicOrigin() const
{
    return newPeriodicOrigin;
}

double *
ReplicateAttributes::GetNewPeriodicOrigin()
{
    return newPeriodicOrigin;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ReplicateAttributes::SelectXVector()
{
    Select(ID_xVector, (void *)xVector, 3);
}

void
ReplicateAttributes::SelectYVector()
{
    Select(ID_yVector, (void *)yVector, 3);
}

void
ReplicateAttributes::SelectZVector()
{
    Select(ID_zVector, (void *)zVector, 3);
}

void
ReplicateAttributes::SelectNewPeriodicOrigin()
{
    Select(ID_newPeriodicOrigin, (void *)newPeriodicOrigin, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ReplicateAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ReplicateAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_useUnitCellVectors:      return "useUnitCellVectors";
    case ID_xVector:                 return "xVector";
    case ID_yVector:                 return "yVector";
    case ID_zVector:                 return "zVector";
    case ID_xReplications:           return "xReplications";
    case ID_yReplications:           return "yReplications";
    case ID_zReplications:           return "zReplications";
    case ID_mergeResults:            return "mergeResults";
    case ID_replicateUnitCellAtoms:  return "replicateUnitCellAtoms";
    case ID_shiftPeriodicAtomOrigin: return "shiftPeriodicAtomOrigin";
    case ID_newPeriodicOrigin:       return "newPeriodicOrigin";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ReplicateAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ReplicateAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_useUnitCellVectors:      return FieldType_bool;
    case ID_xVector:                 return FieldType_doubleArray;
    case ID_yVector:                 return FieldType_doubleArray;
    case ID_zVector:                 return FieldType_doubleArray;
    case ID_xReplications:           return FieldType_int;
    case ID_yReplications:           return FieldType_int;
    case ID_zReplications:           return FieldType_int;
    case ID_mergeResults:            return FieldType_bool;
    case ID_replicateUnitCellAtoms:  return FieldType_bool;
    case ID_shiftPeriodicAtomOrigin: return FieldType_bool;
    case ID_newPeriodicOrigin:       return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ReplicateAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ReplicateAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_useUnitCellVectors:      return "bool";
    case ID_xVector:                 return "doubleArray";
    case ID_yVector:                 return "doubleArray";
    case ID_zVector:                 return "doubleArray";
    case ID_xReplications:           return "int";
    case ID_yReplications:           return "int";
    case ID_zReplications:           return "int";
    case ID_mergeResults:            return "bool";
    case ID_replicateUnitCellAtoms:  return "bool";
    case ID_shiftPeriodicAtomOrigin: return "bool";
    case ID_newPeriodicOrigin:       return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ReplicateAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ReplicateAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ReplicateAttributes &obj = *((const ReplicateAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_useUnitCellVectors:
        {  // new scope
        retval = (useUnitCellVectors == obj.useUnitCellVectors);
        }
        break;
    case ID_xVector:
        {  // new scope
        // Compare the xVector arrays.
        bool xVector_equal = true;
        for(int i = 0; i < 3 && xVector_equal; ++i)
            xVector_equal = (xVector[i] == obj.xVector[i]);

        retval = xVector_equal;
        }
        break;
    case ID_yVector:
        {  // new scope
        // Compare the yVector arrays.
        bool yVector_equal = true;
        for(int i = 0; i < 3 && yVector_equal; ++i)
            yVector_equal = (yVector[i] == obj.yVector[i]);

        retval = yVector_equal;
        }
        break;
    case ID_zVector:
        {  // new scope
        // Compare the zVector arrays.
        bool zVector_equal = true;
        for(int i = 0; i < 3 && zVector_equal; ++i)
            zVector_equal = (zVector[i] == obj.zVector[i]);

        retval = zVector_equal;
        }
        break;
    case ID_xReplications:
        {  // new scope
        retval = (xReplications == obj.xReplications);
        }
        break;
    case ID_yReplications:
        {  // new scope
        retval = (yReplications == obj.yReplications);
        }
        break;
    case ID_zReplications:
        {  // new scope
        retval = (zReplications == obj.zReplications);
        }
        break;
    case ID_mergeResults:
        {  // new scope
        retval = (mergeResults == obj.mergeResults);
        }
        break;
    case ID_replicateUnitCellAtoms:
        {  // new scope
        retval = (replicateUnitCellAtoms == obj.replicateUnitCellAtoms);
        }
        break;
    case ID_shiftPeriodicAtomOrigin:
        {  // new scope
        retval = (shiftPeriodicAtomOrigin == obj.shiftPeriodicAtomOrigin);
        }
        break;
    case ID_newPeriodicOrigin:
        {  // new scope
        // Compare the newPeriodicOrigin arrays.
        bool newPeriodicOrigin_equal = true;
        for(int i = 0; i < 3 && newPeriodicOrigin_equal; ++i)
            newPeriodicOrigin_equal = (newPeriodicOrigin[i] == obj.newPeriodicOrigin[i]);

        retval = newPeriodicOrigin_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

