/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LagrangianAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for LagrangianAttributes::sampleType
//

static const char *sampleType_strings[] = {
"Step", "Time", "ArcLength", 
"Speed", "Vorticity", "Variable"
};

std::string
LagrangianAttributes::sampleType_ToString(LagrangianAttributes::sampleType t)
{
    int index = int(t);
    if(index < 0 || index >= 6) index = 0;
    return sampleType_strings[index];
}

std::string
LagrangianAttributes::sampleType_ToString(int t)
{
    int index = (t < 0 || t >= 6) ? 0 : t;
    return sampleType_strings[index];
}

bool
LagrangianAttributes::sampleType_FromString(const std::string &s, LagrangianAttributes::sampleType &val)
{
    val = LagrangianAttributes::Step;
    for(int i = 0; i < 6; ++i)
    {
        if(s == sampleType_strings[i])
        {
            val = (sampleType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Init utility for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LagrangianAttributes::Init()
{
    seedPoint[0] = 0;
    seedPoint[1] = 0;
    seedPoint[2] = 0;
    numSteps = 1000;
    XAxisSample = Step;
    YAxisSample = Step;

    LagrangianAttributes::SelectAll();
}

// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Copy utility for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LagrangianAttributes::Copy(const LagrangianAttributes &obj)
{
    seedPoint[0] = obj.seedPoint[0];
    seedPoint[1] = obj.seedPoint[1];
    seedPoint[2] = obj.seedPoint[2];

    numSteps = obj.numSteps;
    XAxisSample = obj.XAxisSample;
    YAxisSample = obj.YAxisSample;
    variable = obj.variable;

    LagrangianAttributes::SelectAll();
}

// Type map format string
const char *LagrangianAttributes::TypeMapFormatString = LAGRANGIANATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t LagrangianAttributes::TmfsStruct = {LAGRANGIANATTRIBUTES_TMFS};


// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Default constructor for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes::LagrangianAttributes() : 
    AttributeSubject(LagrangianAttributes::TypeMapFormatString),
    variable("default")
{
    LagrangianAttributes::Init();
}

// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Constructor for the derived classes of LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes::LagrangianAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    variable("default")
{
    LagrangianAttributes::Init();
}

// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Copy constructor for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes::LagrangianAttributes(const LagrangianAttributes &obj) : 
    AttributeSubject(LagrangianAttributes::TypeMapFormatString)
{
    LagrangianAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LagrangianAttributes::LagrangianAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes::LagrangianAttributes(const LagrangianAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LagrangianAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LagrangianAttributes::~LagrangianAttributes
//
// Purpose: 
//   Destructor for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes::~LagrangianAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LagrangianAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LagrangianAttributes& 
LagrangianAttributes::operator = (const LagrangianAttributes &obj)
{
    if (this == &obj) return *this;

    LagrangianAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LagrangianAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LagrangianAttributes::operator == (const LagrangianAttributes &obj) const
{
    // Compare the seedPoint arrays.
    bool seedPoint_equal = true;
    for(int i = 0; i < 3 && seedPoint_equal; ++i)
        seedPoint_equal = (seedPoint[i] == obj.seedPoint[i]);

    // Create the return value
    return (seedPoint_equal &&
            (numSteps == obj.numSteps) &&
            (XAxisSample == obj.XAxisSample) &&
            (YAxisSample == obj.YAxisSample) &&
            (variable == obj.variable));
}

// ****************************************************************************
// Method: LagrangianAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LagrangianAttributes::operator != (const LagrangianAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LagrangianAttributes::TypeName
//
// Purpose: 
//   Type name method for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LagrangianAttributes::TypeName() const
{
    return "LagrangianAttributes";
}

// ****************************************************************************
// Method: LagrangianAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LagrangianAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LagrangianAttributes *tmp = (const LagrangianAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LagrangianAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LagrangianAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LagrangianAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LagrangianAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LagrangianAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LagrangianAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LagrangianAttributes(*this);
    else
        retval = new LagrangianAttributes;

    return retval;
}

// ****************************************************************************
// Method: LagrangianAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LagrangianAttributes::SelectAll()
{
    Select(ID_seedPoint,   (void *)seedPoint, 3);
    Select(ID_numSteps,    (void *)&numSteps);
    Select(ID_XAxisSample, (void *)&XAxisSample);
    Select(ID_YAxisSample, (void *)&YAxisSample);
    Select(ID_variable,    (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LagrangianAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LagrangianAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LagrangianAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LagrangianAttributes.
    DataNode *node = new DataNode("LagrangianAttributes");

    if(completeSave || !FieldsEqual(ID_seedPoint, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("seedPoint", seedPoint, 3));
    }

    if(completeSave || !FieldsEqual(ID_numSteps, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numSteps", numSteps));
    }

    if(completeSave || !FieldsEqual(ID_XAxisSample, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("XAxisSample", sampleType_ToString(XAxisSample)));
    }

    if(completeSave || !FieldsEqual(ID_YAxisSample, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("YAxisSample", sampleType_ToString(YAxisSample)));
    }

    if(completeSave || !FieldsEqual(ID_variable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("variable", variable));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LagrangianAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LagrangianAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LagrangianAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("seedPoint")) != 0)
        SetSeedPoint(node->AsDoubleArray());
    if((node = searchNode->GetNode("numSteps")) != 0)
        SetNumSteps(node->AsInt());
    if((node = searchNode->GetNode("XAxisSample")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 6)
                SetXAxisSample(sampleType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            sampleType value;
            if(sampleType_FromString(node->AsString(), value))
                SetXAxisSample(value);
        }
    }
    if((node = searchNode->GetNode("YAxisSample")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 6)
                SetYAxisSample(sampleType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            sampleType value;
            if(sampleType_FromString(node->AsString(), value))
                SetYAxisSample(value);
        }
    }
    if((node = searchNode->GetNode("variable")) != 0)
        SetVariable(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LagrangianAttributes::SetSeedPoint(const double *seedPoint_)
{
    seedPoint[0] = seedPoint_[0];
    seedPoint[1] = seedPoint_[1];
    seedPoint[2] = seedPoint_[2];
    Select(ID_seedPoint, (void *)seedPoint, 3);
}

void
LagrangianAttributes::SetNumSteps(int numSteps_)
{
    numSteps = numSteps_;
    Select(ID_numSteps, (void *)&numSteps);
}

void
LagrangianAttributes::SetXAxisSample(LagrangianAttributes::sampleType XAxisSample_)
{
    XAxisSample = XAxisSample_;
    Select(ID_XAxisSample, (void *)&XAxisSample);
}

void
LagrangianAttributes::SetYAxisSample(LagrangianAttributes::sampleType YAxisSample_)
{
    YAxisSample = YAxisSample_;
    Select(ID_YAxisSample, (void *)&YAxisSample);
}

void
LagrangianAttributes::SetVariable(const std::string &variable_)
{
    variable = variable_;
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
LagrangianAttributes::GetSeedPoint() const
{
    return seedPoint;
}

double *
LagrangianAttributes::GetSeedPoint()
{
    return seedPoint;
}

int
LagrangianAttributes::GetNumSteps() const
{
    return numSteps;
}

LagrangianAttributes::sampleType
LagrangianAttributes::GetXAxisSample() const
{
    return sampleType(XAxisSample);
}

LagrangianAttributes::sampleType
LagrangianAttributes::GetYAxisSample() const
{
    return sampleType(YAxisSample);
}

const std::string &
LagrangianAttributes::GetVariable() const
{
    return variable;
}

std::string &
LagrangianAttributes::GetVariable()
{
    return variable;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LagrangianAttributes::SelectSeedPoint()
{
    Select(ID_seedPoint, (void *)seedPoint, 3);
}

void
LagrangianAttributes::SelectVariable()
{
    Select(ID_variable, (void *)&variable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LagrangianAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LagrangianAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_seedPoint:   return "seedPoint";
    case ID_numSteps:    return "numSteps";
    case ID_XAxisSample: return "XAxisSample";
    case ID_YAxisSample: return "YAxisSample";
    case ID_variable:    return "variable";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LagrangianAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LagrangianAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_seedPoint:   return FieldType_doubleArray;
    case ID_numSteps:    return FieldType_int;
    case ID_XAxisSample: return FieldType_enum;
    case ID_YAxisSample: return FieldType_enum;
    case ID_variable:    return FieldType_variablename;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LagrangianAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LagrangianAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_seedPoint:   return "doubleArray";
    case ID_numSteps:    return "int";
    case ID_XAxisSample: return "enum";
    case ID_YAxisSample: return "enum";
    case ID_variable:    return "variablename";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LagrangianAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LagrangianAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LagrangianAttributes &obj = *((const LagrangianAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_seedPoint:
        {  // new scope
        // Compare the seedPoint arrays.
        bool seedPoint_equal = true;
        for(int i = 0; i < 3 && seedPoint_equal; ++i)
            seedPoint_equal = (seedPoint[i] == obj.seedPoint[i]);

        retval = seedPoint_equal;
        }
        break;
    case ID_numSteps:
        {  // new scope
        retval = (numSteps == obj.numSteps);
        }
        break;
    case ID_XAxisSample:
        {  // new scope
        retval = (XAxisSample == obj.XAxisSample);
        }
        break;
    case ID_YAxisSample:
        {  // new scope
        retval = (YAxisSample == obj.YAxisSample);
        }
        break;
    case ID_variable:
        {  // new scope
        retval = (variable == obj.variable);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

