# PEGTL Documentation

* [Project](https://github.com/taocpp/PEGTL)
* [Getting Started](Getting-Started.md)
* [Installing and Using](Installing-and-Using.md)
  * [Requirements](Installing-and-Using.md#requirements)
  * [Installation Packages](Installing-and-Using.md#installation-packages)
    * [Linux Packages](Installing-and-Using.md#linux-packages)
    * [macOS Packages](Installing-and-Using.md#macos-packages)
  * [CMake Installation](Installing-and-Using.md#cmake-installation)
  * [Manual Installation](Installing-and-Using.md#manual-installation)
  * [Embedding the PEGTL](Installing-and-Using.md#embedding-the-pegtl)
    * [Embedding in Binaries](Installing-and-Using.md#embedding-in-binaries)
    * [Embedding in Libraries](Installing-and-Using.md#embedding-in-libraries)
    * [Embedding in Library Interfaces](Installing-and-Using.md#embedding-in-library-interfaces)
  * [Limitations](Installing-and-Using.md#limitations)
* [Rules and Grammars](Rules-and-Grammars.md)
  * [Combining Existing Rules](Rules-and-Grammars.md#combining-existing-rules)
  * [Toy S-Expression Grammar](Rules-and-Grammars.md#toy-s-expression-grammar)
  * [Creating New Rules](Rules-and-Grammars.md#creating-new-rules)
    * [Simple Rules](Rules-and-Grammars.md#simple-rules)
    * [Complex Rules](Rules-and-Grammars.md#complex-rules)
* [Actions and States](Actions-and-States.md)
  * [Actions](Actions-and-States.md#actions)
    * [Apply0](Actions-and-States.md#apply0)
    * [Apply](Actions-and-States.md#apply)
  * [States](Actions-and-States.md#states)
  * [Action Specialisation](Actions-and-States.md#action-specialisation)
  * [Changing Actions](Actions-and-States.md#changing-actions)
  * [Changing States](Actions-and-States.md#changing-states)
    * [No Switching](Actions-and-States.md#no-switching)
    * [Intrusive Switching](Actions-and-States.md#intrusive-switching)
    * [External Switching](Actions-and-States.md#external-switching)
* [Errors and Exceptions](Errors-and-Exceptions.md)
  * [Local to Global Failure](Errors-and-Exceptions.md#local-to-global-failure)
  * [Global to Local Failure](Errors-and-Exceptions.md#global-to-local-failure)
  * [Examples for Must Rules](Errors-and-Exceptions.md#examples-for-must-rules)
  * [Custom Exception Messages](Errors-and-Exceptions.md#custom-exception-messages)
* [Rule Reference](Rule-Reference.md)
  * [Meta Rules](Rule-Reference.md#meta-rules)
  * [Combinators](Rule-Reference.md#combinators)
  * [Convenience](Rule-Reference.md#convenience)
  * [Action Rules](Rule-Reference.md#action-rules)
  * [Atomic Rules](Rule-Reference.md#atomic-rules)
  * [ASCII Rules](Rule-Reference.md#ascii-rules)
  * [UTF-8 Rules](Rule-Reference.md#utf-8-rules)
  * [UTF-16 Rules](Rule-Reference.md#utf-16-rules)
  * [UTF-32 Rules](Rule-Reference.md#utf-32-rules)
  * [Full Index](Rule-Reference.md#full-index)
* [Inputs and Parsing](Inputs-and-Parsing.md)
  * [Tracking Mode](Inputs-and-Parsing.md#tracking-mode)
  * [Line Ending](Inputs-and-Parsing.md#line-ending)
  * [Source](Inputs-and-Parsing.md#source)
  * [File Input](Inputs-and-Parsing.md#file-input)
  * [Memory Input](Inputs-and-Parsing.md#memory-input)
  * [String Input](Inputs-and-Parsing.md#string-input)
  * [Stream Inputs](Inputs-and-Parsing.md#stream-inputs)
  * [Argument Input](Inputs-and-Parsing.md#argument-input)
  * [Parse Function](Inputs-and-Parsing.md#parse-function)
  * [Nested Parsing](Inputs-and-Parsing.md#nested-parsing)
  * [Incremental Input](Inputs-and-Parsing.md#incremental-input)
    * [Grammars and Buffering](Inputs-and-Parsing.md#grammars-and-buffering)
    * [Custom Data Sources](Inputs-and-Parsing.md#custom-data-sources)
* [Control and Debug](Control-and-Debug.md)
  * [Normal Control](Control-and-Debug.md#normal-control)
  * [Control Functions](Control-and-Debug.md#control-functions)
  * [Exception Throwing](Control-and-Debug.md#exception-throwing)
  * [Advanced Control](Control-and-Debug.md#advanced-control)
  * [Changing Control](Control-and-Debug.md#changing-control)
* [Parse Tree](Parse-Tree.md)
* [Contrib and Examples](Contrib-and-Examples.md)
  * [Contrib](Contrib-and-Examples.md#contrib)
  * [Examples](Contrib-and-Examples.md#examples)
* [Grammar Analysis](Grammar-Analysis.md)
* [Changelog](Changelog.md)
* [Migration Guide](Migration-Guide.md)

Copyright (c) 2014-2018 Dr. Colin Hirsch and Daniel Frey
