/*=========================================================================

   Program: ParaView
   Module:  vtkPVLogInformation.h

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#ifndef vtkPVLogInformation_h
#define vtkPVLogInformation_h

#include "vtkPVInformation.h"
#include "vtkRemotingServerManagerModule.h" // needed for exports

#include <string> // for std::string

/**
 * @class vtkPVLogInformation
 * @brief Gets the log of a specific rank as well as the verbosity level
 */
class VTKREMOTINGSERVERMANAGER_EXPORT vtkPVLogInformation : public vtkPVInformation
{
public:
  static vtkPVLogInformation* New();
  vtkTypeMacro(vtkPVLogInformation, vtkPVInformation);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  ///@{
  /**
   * vtkPVInformation overrides.
   */
  bool GatherInformation(vtkObject* target) override;
  vtkJson SaveState() const override;
  bool LoadState(const vtkJson& state) override;
  void AddInformation(vtkPVInformation* info) override;
  bool LoadInformation(const vtkJson& json) override;
  vtkJson SaveInformation() const override;
  ///@}

  /**
   * Get the recorded logs.
   */
  vtkGetMacro(Logs, const std::string&);

  /**
   * Get the starting log.
   */
  vtkGetMacro(StartingLogs, const std::string&);

  /**
   * Set the rank to get log from.
   */
  vtkSetMacro(Rank, int);

  /**
   * Get the verbosity level of the server.
   */
  vtkGetMacro(Verbosity, int);

protected:
  vtkPVLogInformation() = default;
  ~vtkPVLogInformation() override = default;

  int Rank = -1;
  std::string Logs;
  std::string StartingLogs;
  int Verbosity = 20;

  vtkPVLogInformation(const vtkPVLogInformation&) = delete;
  void operator=(const vtkPVLogInformation&) = delete;
};

#endif // vtkPVLogInformation_h
