/*=========================================================================

  Program:   ParaView
  Module:    vtkParaViewPlugin.h

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/**
 * @class vtkParaViewPlugin
 * @brief
 *
 */

#ifndef vtkParaViewPlugin_h
#define vtkParaViewPlugin_h

#include "vtkSMObject.h"

class VTKPVCLIENTSERVERCORECORE_EXPORT vtkParaViewPlugin
{
public:
  vtkParaViewPlugin();
  virtual ~vtkParaViewPlugin();

  void Print(ostream& os);

  /**
   * Method to access all properties defined on this plugin.
   * If any property is not defined, an empty string will be returned.
   */
  const std::string& GetProperty(const std::string& key);

protected:
  /**
   * Subclasses can use this method to setup properties for the plugin.
   */
  bool SetProperty(const std::string& key, const std::string& value, bool replace=false);

private:
  vtkParaViewPlugin(const vtkParaViewPlugin&) = delete;
  void operator=(const vtkParaViewPlugin&) = delete;

  class vtkInternals;
  std::unique_ptr<vtkInternals> Internals;
};

#ifdef _WIN32
// __cdecl gives an unmangled name
#define C_DECL __cdecl
#define C_EXPORT extern "C" __declspec(dllexport)
#elif defined(__GNUC__)
#define C_DECL
#define C_EXPORT extern "C" __attribute__((visibility("default")))
#else
#define C_DECL
#define C_EXPORT extern "C"
#endif

#endif
