/*=========================================================================

  Program:   ParaView
  Module:    vtkParaViewPlugin.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkParaViewPlugin.h"

#include "vtkObjectFactory.h"

class vtkParaViewPlugin::vtkInternals
{
  std::map<std::string, std::string> Properties;
  std::string Empty;
};

vtkStandardNewMacro(vtkParaViewPlugin);
//----------------------------------------------------------------------------
vtkParaViewPlugin::vtkParaViewPlugin()
  : Internals(new vtkParaViewPlugin::vtkInternals())
{
}

//----------------------------------------------------------------------------
vtkParaViewPlugin::~vtkParaViewPlugin()
{
}

//----------------------------------------------------------------------------
const std::string& vtkParaViewPlugin::GetProperty(const std::string& key)
{
  auto& internals = (*this->Internals);
  auto iter = internals.Properties.find(key);
  return iter != internals.Properties.end() ? iter->second : internals.Empty;
}

//----------------------------------------------------------------------------
bool vtkParaViewPlugin::SetProperty(const std::string& key, const std::string& value, bool replace)
{
  auto& internals = (*this->Internals);
  if (!replace)
  {
    return internals.Properties.insert(std::make_pair(key, value)).second;
  }
  else
  {
    internals.Properties[key] = value;
    return true;
  }
}

//----------------------------------------------------------------------------
void vtkParaViewPlugin::Print(ostream& os)
{
}
